/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tez.dag.api;

import java.util.Locale;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.conf.Configuration;

@InterfaceAudience.Public
public enum HistoryLogLevel {
    NONE,
    AM,
    DAG,
    VERTEX,
    TASK,
    TASK_ATTEMPT,
    ALL;

    public static final HistoryLogLevel DEFAULT;

    public boolean shouldLog(HistoryLogLevel eventLevel) {
        return eventLevel.ordinal() <= this.ordinal();
    }

    public static HistoryLogLevel getLogLevel(Configuration conf, HistoryLogLevel defaultValue) {
        String logLevel = conf.getTrimmed("tez.history.logging.log.level");
        if (logLevel == null) {
            return defaultValue;
        }
        return HistoryLogLevel.valueOf(logLevel.toUpperCase(Locale.ENGLISH));
    }

    public static boolean validateLogLevel(String logLevel) {
        if (logLevel != null) {
            try {
                HistoryLogLevel.valueOf(logLevel.toUpperCase(Locale.ENGLISH));
            }
            catch (IllegalArgumentException e) {
                return false;
            }
        }
        return true;
    }

    static {
        DEFAULT = ALL;
    }
}

