/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence;

import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import org.apache.openjpa.lib.util.ClassUtil;

public class AnnotationBuilder {
    private Class<? extends Annotation> type;
    private List<AnnotationEntry> components = new ArrayList<AnnotationEntry>();

    protected AnnotationBuilder(Class<? extends Annotation> type) {
        this.type = type;
    }

    public Class<? extends Annotation> getType() {
        return this.type;
    }

    public AnnotationBuilder add(String key, String val) {
        return this.doAdd(key, val);
    }

    public AnnotationBuilder add(String key, boolean val) {
        return this.doAdd(key, val);
    }

    public AnnotationBuilder add(String key, int val) {
        return this.doAdd(key, val);
    }

    public AnnotationBuilder add(String key, Class val) {
        return this.doAdd(key, val);
    }

    public AnnotationBuilder add(String key, EnumSet val) {
        return this.doAdd(key, val);
    }

    public AnnotationBuilder add(String key, Enum val) {
        return this.doAdd(key, val);
    }

    public AnnotationBuilder add(String key, AnnotationBuilder val) {
        if (null == val) {
            return this;
        }
        AnnotationEntry ae = this.find(key);
        if (null == ae) {
            this.doAdd(key, val);
        } else {
            ArrayList<AnnotationBuilder> list;
            if (ae.value instanceof List) {
                list = (ArrayList<AnnotationBuilder>)ae.value;
            } else if (ae.value instanceof AnnotationBuilder) {
                list = new ArrayList<AnnotationBuilder>();
                list.add((AnnotationBuilder)ae.value);
                ae.value = list;
            } else {
                throw new IllegalArgumentException("Unexpected type: " + String.valueOf(ae.value));
            }
            list.add(val);
        }
        return this;
    }

    public boolean hasComponents() {
        return this.components.size() > 0;
    }

    private AnnotationBuilder doAdd(String key, Object val) {
        if (null != val) {
            this.components.add(new AnnotationEntry(key, val));
        }
        return this;
    }

    private AnnotationEntry find(String key) {
        for (AnnotationEntry ae : this.components) {
            if (!Objects.equals(ae.key, key)) continue;
            return ae;
        }
        return null;
    }

    static String enumToString(Enum e) {
        StringBuilder sb = new StringBuilder();
        sb.append(ClassUtil.getClassName(e.getClass())).append(".").append(e);
        return sb.toString();
    }

    static String enumSetToString(EnumSet set) {
        StringBuilder sb = new StringBuilder();
        Iterator i = set.iterator();
        while (i.hasNext()) {
            Object e = i.next();
            sb.append(ClassUtil.getClassName(e.getClass())).append(".").append(e);
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    protected void toString(StringBuilder sb) {
        sb.append("@").append(ClassUtil.getClassName(this.type));
        if (this.components.size() == 0) {
            return;
        }
        sb.append("(");
        Iterator<AnnotationEntry> i = this.components.iterator();
        while (i.hasNext()) {
            AnnotationEntry e = i.next();
            e.toString(sb);
            if (!i.hasNext()) continue;
            sb.append(", ");
        }
        sb.append(")");
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.toString(sb);
        return sb.toString();
    }

    class AnnotationEntry {
        String key;
        Object value;

        AnnotationEntry(String key, Object value) {
            this.key = key;
            this.value = value;
        }

        void toString(StringBuilder sb) {
            if (null != this.key) {
                sb.append(this.key).append("=");
            }
            List.class.getTypeParameters();
            if (this.value instanceof List) {
                sb.append("{");
                List l = (List)this.value;
                Iterator i = l.iterator();
                while (i.hasNext()) {
                    AnnotationBuilder ab = (AnnotationBuilder)i.next();
                    sb.append(ab.toString());
                    if (!i.hasNext()) continue;
                    sb.append(", ");
                }
                sb.append("}");
            } else if (this.value instanceof Class) {
                String cls = ((Class)this.value).getName().replace('$', '.');
                sb.append(cls).append(".class");
            } else if (this.value instanceof String) {
                sb.append('\"').append(this.value).append('\"');
            } else if (this.value instanceof Enum) {
                sb.append(AnnotationBuilder.enumToString((Enum)this.value));
            } else if (this.value instanceof EnumSet) {
                sb.append(AnnotationBuilder.enumSetToString((EnumSet)this.value));
            } else {
                sb.append(this.value);
            }
        }
    }
}

