/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.uima.analysis_engine.AnalysisEngine;
import org.apache.uima.ruta.RutaElement;
import org.apache.uima.ruta.RutaStream;
import org.apache.uima.ruta.ScriptApply;
import org.apache.uima.ruta.block.RutaBlock;
import org.apache.uima.ruta.visitor.InferenceCrowd;

public class RutaModule
extends RutaElement {
    private final RutaBlock rootBlock;
    private Map<String, RutaModule> scripts;
    private Map<String, AnalysisEngine> descriptorEngines;
    private Map<String, AnalysisEngine> uimafitEngines;
    private Map<String, List<String>> configurationData;
    private Map<String, RutaBlock> blocks;

    public RutaModule(RutaBlock rootBlock) {
        this.rootBlock = rootBlock;
        this.scripts = new HashMap<String, RutaModule>();
        this.descriptorEngines = new HashMap<String, AnalysisEngine>();
        this.uimafitEngines = new HashMap<String, AnalysisEngine>();
        this.configurationData = new HashMap<String, List<String>>();
        this.blocks = new HashMap<String, RutaBlock>();
    }

    public ScriptApply apply(RutaStream stream, InferenceCrowd crowd) {
        crowd.beginVisit(this, null);
        ScriptApply result = this.rootBlock.apply(stream, crowd);
        crowd.endVisit(this, result);
        return result;
    }

    public RutaBlock getBlock(String id) {
        if (id == null || id.equals(this.rootBlock.getName())) {
            return this.rootBlock;
        }
        RutaBlock ownBlock = this.blocks.get(id);
        if (ownBlock != null) {
            return ownBlock;
        }
        int indexOf = id.indexOf(46);
        if (indexOf != -1) {
            String otherScriptName = id.substring(0, indexOf);
            String tail = id.substring(indexOf + 1, id.length());
            RutaModule otherScript = this.getScript(otherScriptName);
            if (otherScript != null) {
                return otherScript.getBlock(tail);
            }
        } else {
            RutaModule otherScript = this.getScript(id);
            if (otherScript != null) {
                return otherScript.getBlock(null);
            }
        }
        return null;
    }

    public RutaModule getScript(String name) {
        if (name.equals(this.rootBlock.getName())) {
            return this;
        }
        RutaModule result = this.scripts.get(name);
        if (result == null) {
            for (String each : this.scripts.keySet()) {
                String[] split = each.split("\\.");
                String last = split[split.length - 1];
                if (!last.equals(name)) continue;
                return this.scripts.get(each);
            }
        }
        return result;
    }

    public void addScript(String name, RutaModule script) {
        this.scripts.put(name, script);
    }

    public void addBlock(String id, RutaBlock block) {
        this.blocks.put(id, block);
    }

    public void setScriptDependencies(Map<String, RutaModule> additionalScripts) {
        for (String eachTarget : this.scripts.keySet()) {
            RutaModule module = additionalScripts.get(eachTarget);
            this.addScript(eachTarget, module);
        }
    }

    public AnalysisEngine getEngine(String name) {
        Map<String, AnalysisEngine> engines = this.getAllEngines();
        AnalysisEngine result = engines.get(name);
        if (result == null) {
            for (String each : engines.keySet()) {
                String[] split = each.split("\\.");
                String last = split[split.length - 1];
                if (!last.equals(name)) continue;
                return engines.get(each);
            }
        }
        return result;
    }

    public void addDescriptorEngine(String name, AnalysisEngine engine) {
        this.descriptorEngines.put(name, engine);
    }

    public void addUimafitEngine(String name, AnalysisEngine engine) {
        this.uimafitEngines.put(name, engine);
    }

    public void addConfigurationData(String name, List<String> configuration) {
        this.configurationData.put(name, configuration);
    }

    public void setDescriptorEngineDependencies(Map<String, AnalysisEngine> additionalEngines) {
        for (String eachTarget : this.descriptorEngines.keySet()) {
            AnalysisEngine engine = additionalEngines.get(eachTarget);
            this.addDescriptorEngine(eachTarget, engine);
        }
    }

    public void setUimafitEngineDependencies(Map<String, AnalysisEngine> additionalEngines) {
        for (String eachTarget : this.uimafitEngines.keySet()) {
            AnalysisEngine engine = additionalEngines.get(eachTarget);
            this.addUimafitEngine(eachTarget, engine);
        }
    }

    public Map<String, RutaModule> getScripts() {
        return this.scripts;
    }

    public Map<String, RutaBlock> getBlocks() {
        return this.blocks;
    }

    public Map<String, AnalysisEngine> getAllEngines() {
        HashMap<String, AnalysisEngine> result = new HashMap<String, AnalysisEngine>();
        result.putAll(this.descriptorEngines);
        result.putAll(this.uimafitEngines);
        return result;
    }

    public Map<String, AnalysisEngine> getDescriptorEngines() {
        return this.descriptorEngines;
    }

    public Map<String, AnalysisEngine> getUimafitEngines() {
        return this.uimafitEngines;
    }

    public RutaBlock getRootBlock() {
        return this.rootBlock;
    }

    public Map<String, List<String>> getConfigurationData() {
        return this.configurationData;
    }

    public List<String> getConfigurationData(String engine) {
        return this.configurationData.get(engine);
    }
}

