/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.cellar.hazelcast;

import java.util.Dictionary;
import org.apache.karaf.cellar.core.utils.CombinedClassLoader;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.SynchronousBundleListener;

public class HazelcastBundleListener
implements SynchronousBundleListener {
    private BundleContext bundleContext;
    private CombinedClassLoader combinedClassLoader;

    public HazelcastBundleListener(BundleContext bundleContext, CombinedClassLoader combinedClassLoader) {
        this.bundleContext = bundleContext;
        this.combinedClassLoader = combinedClassLoader;
    }

    public void scanExistingBundles() {
        Bundle[] bundles;
        for (Bundle bundle : bundles = this.bundleContext.getBundles()) {
            if (!this.isBundleEligible(bundle)) continue;
            this.combinedClassLoader.addBundle(bundle);
        }
    }

    public void bundleChanged(BundleEvent event) {
        switch (event.getType()) {
            case 2: 
            case 128: {
                if (!this.isBundleEligible(event.getBundle())) break;
                this.combinedClassLoader.addBundle(event.getBundle());
                break;
            }
            case 4: 
            case 16: 
            case 32: 
            case 256: {
                if (!this.isBundleEligible(event.getBundle())) break;
                this.combinedClassLoader.removeBundle(event.getBundle());
            }
        }
    }

    public boolean isBundleEligible(Bundle bundle) {
        String importPackage;
        Dictionary dictionary;
        return bundle != null && (dictionary = bundle.getHeaders()) != null && (importPackage = (String)dictionary.get("Import-Package")) != null && (importPackage.contains("com.hazelcast") || importPackage.contains("org.apache.karaf.cellar"));
    }
}

