/*
 * Decompiled with CFR 0.152.
 */
package org.apache.unomi.plugins.baseplugin.conditions;

import java.util.Collection;
import java.util.Map;
import org.apache.unomi.api.conditions.Condition;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilder;
import org.apache.unomi.persistence.elasticsearch.conditions.ConditionESQueryBuilderDispatcher;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.IdsQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;

public class IdsConditionESQueryBuilder
implements ConditionESQueryBuilder {
    private int maximumIdsQueryCount = 5000;

    public void setMaximumIdsQueryCount(int maximumIdsQueryCount) {
        this.maximumIdsQueryCount = maximumIdsQueryCount;
    }

    public QueryBuilder buildQuery(Condition condition, Map<String, Object> context, ConditionESQueryBuilderDispatcher dispatcher) {
        Collection ids = (Collection)condition.getParameter("ids");
        Boolean match = (Boolean)condition.getParameter("match");
        if (ids.size() > this.maximumIdsQueryCount) {
            throw new UnsupportedOperationException("Too many profiles");
        }
        IdsQueryBuilder idsQueryBuilder = QueryBuilders.idsQuery().addIds(ids.toArray(new String[0]));
        if (match.booleanValue()) {
            return idsQueryBuilder;
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery();
        boolQuery.mustNot((QueryBuilder)idsQueryBuilder);
        return boolQuery;
    }
}

