/*
 * Decompiled with CFR 0.152.
 */
package org.gephi.filters.plugin.graph;

import java.util.HashSet;
import javax.swing.Icon;
import javax.swing.JPanel;
import org.gephi.algorithms.shortestpath.BellmanFordShortestPathAlgorithm;
import org.gephi.algorithms.shortestpath.DijkstraShortestPathAlgorithm;
import org.gephi.filters.api.FilterLibrary;
import org.gephi.filters.plugin.graph.EgoBuilder;
import org.gephi.filters.plugin.graph.ShortestPathUI;
import org.gephi.filters.spi.Category;
import org.gephi.filters.spi.ComplexFilter;
import org.gephi.filters.spi.Filter;
import org.gephi.filters.spi.FilterBuilder;
import org.gephi.filters.spi.FilterProperty;
import org.gephi.graph.api.DirectedGraph;
import org.gephi.graph.api.Edge;
import org.gephi.graph.api.Graph;
import org.gephi.graph.api.Node;
import org.gephi.project.api.Workspace;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ShortestPathBuilder
implements FilterBuilder {
    public Category getCategory() {
        return FilterLibrary.TOPOLOGY;
    }

    public String getName() {
        return NbBundle.getMessage(ShortestPathBuilder.class, (String)"ShortestPathBuilder.name");
    }

    public Icon getIcon() {
        return null;
    }

    public String getDescription() {
        return NbBundle.getMessage(EgoBuilder.class, (String)"ShortestPathBuilder.description");
    }

    public Filter getFilter(Workspace workspace) {
        return new ShortestPathFilter();
    }

    public JPanel getPanel(Filter filter) {
        ShortestPathUI ui = (ShortestPathUI)Lookup.getDefault().lookup(ShortestPathUI.class);
        if (ui != null) {
            return ui.getPanel((ShortestPathFilter)filter);
        }
        return null;
    }

    public void destroy(Filter filter) {
    }

    public static class ShortestPathFilter
    implements ComplexFilter {
        private String node1Pattern = "";
        private String node2Pattern = "";

        public Graph filter(Graph graph) {
            String str1 = this.node1Pattern.toLowerCase();
            String str2 = this.node2Pattern.toLowerCase();
            Node n1 = null;
            Node n2 = null;
            for (Node n : graph.getNodes()) {
                if (n.getId().toString().toLowerCase().equals(str1)) {
                    n1 = n;
                    continue;
                }
                if (n.getLabel() != null && n.getLabel().toLowerCase().equals(str1)) {
                    n1 = n;
                    continue;
                }
                if (n.getId().toString().toLowerCase().equals(str2)) {
                    n2 = n;
                    continue;
                }
                if (n.getLabel() == null || !n.getLabel().toLowerCase().equals(str2)) continue;
                n2 = n;
            }
            if (n1 != null && n2 != null) {
                Object algorithm = graph.isDirected() ? new BellmanFordShortestPathAlgorithm((DirectedGraph)graph, n1) : new DijkstraShortestPathAlgorithm(graph, n1);
                algorithm.compute();
                HashSet<Edge> retainEdges = new HashSet<Edge>();
                HashSet<Node> retainNodes = new HashSet<Node>();
                if ((Double)algorithm.getDistances().get(n2) != Double.POSITIVE_INFINITY) {
                    retainNodes.add(n2);
                    Edge predecessorEdge = algorithm.getPredecessorIncoming(n2);
                    Node predecessor = algorithm.getPredecessor(n2);
                    while (predecessorEdge != null && predecessor != n1) {
                        retainEdges.add(predecessorEdge);
                        retainNodes.add(predecessor);
                        predecessorEdge = algorithm.getPredecessorIncoming(predecessor);
                        predecessor = algorithm.getPredecessor(predecessor);
                    }
                    retainEdges.add(predecessorEdge);
                    retainNodes.add(n1);
                }
                for (Node node : graph.getNodes().toArray()) {
                    if (retainNodes.contains(node)) continue;
                    graph.removeNode(node);
                }
                for (Node node : graph.getEdges().toArray()) {
                    if (retainEdges.contains(node)) continue;
                    graph.removeEdge((Edge)node);
                }
            }
            return graph;
        }

        public String getName() {
            return NbBundle.getMessage(ShortestPathBuilder.class, (String)"ShortestPathBuilder.name");
        }

        public FilterProperty[] getProperties() {
            try {
                return new FilterProperty[]{FilterProperty.createProperty((Filter)this, String.class, (String)"firstNodePattern"), FilterProperty.createProperty((Filter)this, String.class, (String)"secondNodePattern")};
            }
            catch (NoSuchMethodException ex) {
                Exceptions.printStackTrace((Throwable)ex);
                return new FilterProperty[0];
            }
        }

        public String getFirstNodePattern() {
            return this.node1Pattern;
        }

        public void setFirstNodePattern(String node1Pattern) {
            this.node1Pattern = node1Pattern;
        }

        public String getSecondNodePattern() {
            return this.node2Pattern;
        }

        public void setSecondNodePattern(String node2Pattern) {
            this.node2Pattern = node2Pattern;
        }
    }
}

