/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.dataconversion.internal;

import java.util.Collection;
import java.util.function.Function;
import java.util.stream.Stream;
import org.infinispan.commons.dataconversion.internal.Json;
import org.infinispan.commons.dataconversion.internal.JsonArrayCollector;

public final class JsonUtils {
    private JsonUtils() {
    }

    public static <T> Json createJsonArray(Collection<T> collection) {
        return JsonUtils.createJsonArray(collection, Json::make);
    }

    public static <T> Json createJsonArray(Stream<T> stream) {
        return JsonUtils.createJsonArray(stream, Json::make);
    }

    public static <T> Json createJsonArray(Collection<T> collection, Function<T, Json> jsonFactory) {
        return JsonUtils.createJsonArray(collection.stream(), jsonFactory);
    }

    public static <T> Json createJsonArray(Stream<T> stream, Function<T, Json> jsonFactory) {
        return stream.map(jsonFactory).collect(new JsonArrayCollector());
    }
}

