/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.HashUtils;
import org.bouncycastle.bcpg.KeyIdentifier;
import org.bouncycastle.bcpg.OnePassSignaturePacket;
import org.bouncycastle.bcpg.Packet;
import org.bouncycastle.openpgp.PGPDefaultSignatureGenerator;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPSignature;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.util.Arrays;

public class PGPOnePassSignature
extends PGPDefaultSignatureGenerator {
    private OnePassSignaturePacket sigPack;
    private PGPContentVerifier verifier;

    private static OnePassSignaturePacket cast(Packet packet) throws IOException {
        if (!(packet instanceof OnePassSignaturePacket)) {
            throw new IOException("unexpected packet in stream: " + packet);
        }
        return (OnePassSignaturePacket)packet;
    }

    public PGPOnePassSignature(BCPGInputStream pIn) throws IOException, PGPException {
        this(PGPOnePassSignature.cast(pIn.readPacket()));
    }

    PGPOnePassSignature(OnePassSignaturePacket sigPack) {
        super(sigPack.getVersion() == 3 ? 4 : sigPack.getVersion());
        this.sigPack = sigPack;
        this.sigType = sigPack.getSignatureType();
    }

    public void init(PGPContentVerifierBuilderProvider verifierBuilderProvider, PGPPublicKey pubKey) throws PGPException {
        PGPContentVerifierBuilder verifierBuilder = verifierBuilderProvider.get(this.sigPack.getKeyAlgorithm(), this.sigPack.getHashAlgorithm());
        this.verifier = verifierBuilder.build(pubKey);
        this.lastb = 0;
        this.sigOut = this.verifier.getOutputStream();
        this.checkSaltSize();
        this.updateWithSalt();
    }

    private void checkSaltSize() throws PGPException {
        if (this.getVersion() != 6) {
            return;
        }
        int expectedSaltSize = HashUtils.getV6SignatureSaltSizeInBytes(this.getHashAlgorithm());
        if (expectedSaltSize != this.getSalt().length) {
            throw new PGPException("RFC9580 defines the salt size for " + PGPUtil.getDigestName(this.getHashAlgorithm()) + " as " + expectedSaltSize + " octets, but signature has " + this.getSalt().length + " octets.");
        }
    }

    private void updateWithSalt() throws PGPException {
        if (this.version == 6) {
            try {
                this.sigOut.write(this.getSalt());
            }
            catch (IOException e) {
                throw new PGPException("Cannot salt the signature.", e);
            }
        }
    }

    public boolean verify(PGPSignature pgpSig) throws PGPException {
        this.compareSalt(pgpSig);
        try {
            this.sigOut.write(pgpSig.getSignatureTrailer());
            this.sigOut.close();
        }
        catch (IOException e) {
            throw new PGPException("unable to add trailer: " + e.getMessage(), e);
        }
        return this.verifier.verify(pgpSig.getSignature());
    }

    private void compareSalt(PGPSignature signature) throws PGPException {
        if (this.version != 6) {
            return;
        }
        if (!Arrays.constantTimeAreEqual((byte[])this.getSalt(), (byte[])signature.getSalt())) {
            throw new PGPException("Salt in OnePassSignaturePacket does not match salt in SignaturePacket.");
        }
    }

    public int getVersion() {
        return this.sigPack.getVersion();
    }

    public long getKeyID() {
        return this.sigPack.getKeyID();
    }

    public byte[] getFingerprint() {
        return this.sigPack.getFingerprint();
    }

    public KeyIdentifier getKeyIdentifier() {
        return new KeyIdentifier(this.getFingerprint(), this.getKeyID());
    }

    public byte[] getSalt() {
        return this.sigPack.getSalt();
    }

    public int getSignatureType() {
        return this.sigPack.getSignatureType();
    }

    public int getHashAlgorithm() {
        return this.sigPack.getHashAlgorithm();
    }

    public int getKeyAlgorithm() {
        return this.sigPack.getKeyAlgorithm();
    }

    public boolean isContaining() {
        return this.sigPack.isContaining();
    }

    public byte[] getEncoded() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        this.encode(bOut);
        return bOut.toByteArray();
    }

    public void encode(OutputStream outStream) throws IOException {
        BCPGOutputStream.wrap(outStream).writePacket(this.sigPack);
    }
}

