/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.provider;

import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.KrbException;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.AbstractCheckSumTypeHandler;
import org.apache.hadoop.shaded.org.apache.kerby.kerberos.kerb.crypto.cksum.HashProvider;

public abstract class AbstractUnkeyedCheckSumTypeHandler
extends AbstractCheckSumTypeHandler {
    public AbstractUnkeyedCheckSumTypeHandler(HashProvider hashProvider, int computeSize, int outputSize) {
        super(null, hashProvider, computeSize, outputSize);
    }

    @Override
    public byte[] checksum(byte[] data, int start, int len) throws KrbException {
        int outputSize = this.outputSize();
        HashProvider hp = this.hashProvider();
        hp.hash(data, start, len);
        byte[] workBuffer = hp.output();
        if (outputSize < workBuffer.length) {
            byte[] output = new byte[outputSize];
            System.arraycopy(workBuffer, 0, output, 0, outputSize);
            return output;
        }
        return workBuffer;
    }

    @Override
    public boolean verify(byte[] data, int start, int len, byte[] checksum) throws KrbException {
        byte[] newCksum = this.checksum(data, start, len);
        return AbstractUnkeyedCheckSumTypeHandler.checksumEqual(newCksum, checksum);
    }
}

