/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import java.util.ArrayList;
import java.util.Vector;
import javax.media.j3d.BranchGroupRetained;
import javax.media.j3d.CapabilityNotSetException;
import javax.media.j3d.CompressedGeometry;
import javax.media.j3d.Geometry;
import javax.media.j3d.GeometryArray;
import javax.media.j3d.GeometryAtom;
import javax.media.j3d.HashKey;
import javax.media.j3d.IndexedGeometryArray;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Locale;
import javax.media.j3d.Morph;
import javax.media.j3d.MorphRetained;
import javax.media.j3d.Node;
import javax.media.j3d.NodeRetained;
import javax.media.j3d.PickShape;
import javax.media.j3d.SceneGraphObject;
import javax.media.j3d.SceneGraphPath;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Shape3DCompileRetained;
import javax.media.j3d.Shape3DRetained;
import javax.media.j3d.SharedGroupRetained;
import javax.media.j3d.Text3DRetained;
import javax.media.j3d.Transform3D;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;

public class PickInfo {
    static final int PICK_ALL = 1;
    static final int PICK_ANY = 2;
    private SceneGraphPath sgp;
    private Node node;
    private Transform3D l2vw;
    private Point3d closestIntersectionPoint;
    private double closestDistance;
    private IntersectionInfo[] intersectionInfoArr;
    private ArrayList<IntersectionInfo> intersectionInfoList = new ArrayList();
    private boolean intersectionInfoListSorted = false;
    private Transform3D l2vwRef;
    private Node nodeRef;
    public static final int PICK_BOUNDS = 1;
    public static final int PICK_GEOMETRY = 2;
    public static final int SCENEGRAPHPATH = 1;
    public static final int NODE = 2;
    public static final int LOCAL_TO_VWORLD = 4;
    public static final int CLOSEST_INTERSECTION_POINT = 8;
    public static final int CLOSEST_DISTANCE = 16;
    public static final int CLOSEST_GEOM_INFO = 32;
    public static final int ALL_GEOM_INFO = 64;

    PickInfo() {
    }

    void setSceneGraphPath(SceneGraphPath sceneGraphPath) {
        this.sgp = sceneGraphPath;
    }

    void setNode(Node node) {
        this.node = node;
    }

    void setLocalToVWorld(Transform3D transform3D) {
        this.l2vw = transform3D;
    }

    void setClosestIntersectionPoint(Point3d point3d) {
        this.closestIntersectionPoint = point3d;
    }

    void setClosestDistance(double d) {
        this.closestDistance = d;
    }

    void setLocalToVWorldRef(Transform3D transform3D) {
        this.l2vwRef = transform3D;
    }

    void setNodeRef(Node node) {
        this.nodeRef = node;
    }

    IntersectionInfo createIntersectionInfo() {
        return new IntersectionInfo();
    }

    void insertIntersectionInfo(IntersectionInfo intersectionInfo) {
        this.intersectionInfoList.add(intersectionInfo);
        this.intersectionInfoListSorted = false;
    }

    void sortIntersectionInfoArray(IntersectionInfo[] intersectionInfoArray) {
        class Sort {
            IntersectionInfo[] iInfoArr;

            Sort(IntersectionInfo[] intersectionInfoArray) {
                this.iInfoArr = intersectionInfoArray;
            }

            void sorting() {
                if (this.iInfoArr.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.iInfoArr.length - 1);
                }
            }

            final void insertSort() {
                for (int i = 0; i < this.iInfoArr.length; ++i) {
                    for (int j = i; j > 0 && this.iInfoArr[j - 1].distance > this.iInfoArr[j].distance; --j) {
                        IntersectionInfo intersectionInfo = this.iInfoArr[j];
                        this.iInfoArr[j] = this.iInfoArr[j - 1];
                        this.iInfoArr[j - 1] = intersectionInfo;
                    }
                }
            }

            final void quicksort(int n, int n2) {
                int n3 = n;
                int n4 = n2;
                double d = this.iInfoArr[(n + n2) / 2].distance;
                while (true) {
                    if (this.iInfoArr[n3].distance < d) {
                        ++n3;
                        continue;
                    }
                    while (d < this.iInfoArr[n4].distance) {
                        --n4;
                    }
                    if (n3 <= n4) {
                        IntersectionInfo intersectionInfo = this.iInfoArr[n3];
                        this.iInfoArr[n3] = this.iInfoArr[n4];
                        this.iInfoArr[n4] = intersectionInfo;
                        ++n3;
                        --n4;
                    }
                    if (n3 > n4) break;
                }
                if (n < n4) {
                    this.quicksort(n, n4);
                }
                if (n < n2) {
                    this.quicksort(n3, n2);
                }
            }
        }
        new Sort(intersectionInfoArray).sorting();
        this.intersectionInfoListSorted = true;
    }

    static void sortPickInfoArray(PickInfo[] pickInfoArray) {
        class Sort {
            PickInfo[] pIArr;

            Sort(PickInfo[] pickInfoArray) {
                this.pIArr = pickInfoArray;
            }

            void sorting() {
                if (this.pIArr.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.pIArr.length - 1);
                }
            }

            final void insertSort() {
                for (int i = 0; i < this.pIArr.length; ++i) {
                    for (int j = i; j > 0 && this.pIArr[j - 1].closestDistance > this.pIArr[j].closestDistance; --j) {
                        PickInfo pickInfo = this.pIArr[j];
                        this.pIArr[j] = this.pIArr[j - 1];
                        this.pIArr[j - 1] = pickInfo;
                    }
                }
            }

            final void quicksort(int n, int n2) {
                int n3 = n;
                int n4 = n2;
                double d = this.pIArr[(n + n2) / 2].closestDistance;
                while (true) {
                    if (this.pIArr[n3].closestDistance < d) {
                        ++n3;
                        continue;
                    }
                    while (d < this.pIArr[n4].closestDistance) {
                        --n4;
                    }
                    if (n3 <= n4) {
                        PickInfo pickInfo = this.pIArr[n3];
                        this.pIArr[n3] = this.pIArr[n4];
                        this.pIArr[n4] = pickInfo;
                        ++n3;
                        --n4;
                    }
                    if (n3 > n4) break;
                }
                if (n < n4) {
                    this.quicksort(n, n4);
                }
                if (n < n2) {
                    this.quicksort(n3, n2);
                }
            }
        }
        new Sort(pickInfoArray).sorting();
    }

    public SceneGraphPath getSceneGraphPath() {
        return this.sgp;
    }

    public Node getNode() {
        return this.node;
    }

    public Transform3D getLocalToVWorld() {
        return this.l2vw;
    }

    public Point3d getClosestIntersectionPoint() {
        return this.closestIntersectionPoint;
    }

    public double getClosestDistance() {
        return this.closestDistance;
    }

    Transform3D getLocalToVWorldRef() {
        return this.l2vwRef;
    }

    Node getNodeRef() {
        return this.nodeRef;
    }

    public IntersectionInfo[] getIntersectionInfos() {
        if (!this.intersectionInfoListSorted) {
            this.intersectionInfoArr = new IntersectionInfo[this.intersectionInfoList.size()];
            this.intersectionInfoArr = this.intersectionInfoList.toArray(this.intersectionInfoArr);
            this.sortIntersectionInfoArray(this.intersectionInfoArr);
        }
        return this.intersectionInfoArr;
    }

    static ArrayList<NodeRetained> initSceneGraphPath(NodeRetained nodeRetained) {
        ArrayList<NodeRetained> arrayList = new ArrayList<NodeRetained>(5);
        do {
            if (!nodeRetained.source.getCapability(1)) continue;
            arrayList.add(nodeRetained);
        } while ((nodeRetained = nodeRetained.parent) != null);
        return arrayList;
    }

    private static Node[] createPath(NodeRetained nodeRetained, BranchGroupRetained branchGroupRetained, GeometryAtom geometryAtom, ArrayList<NodeRetained> arrayList) {
        ArrayList<NodeRetained> arrayList2 = PickInfo.retrievePath(nodeRetained, branchGroupRetained, geometryAtom.source.key);
        assert (arrayList2 != null);
        return PickInfo.mergePath(arrayList2, arrayList);
    }

    private static boolean inside(BranchGroupRetained[] branchGroupRetainedArray, BranchGroupRetained branchGroupRetained) {
        if (branchGroupRetained == null || branchGroupRetainedArray == null) {
            return true;
        }
        for (int i = 0; i < branchGroupRetainedArray.length; ++i) {
            if (branchGroupRetainedArray[i] != branchGroupRetained) continue;
            return true;
        }
        return false;
    }

    private static ArrayList<NodeRetained> retrievePath(NodeRetained nodeRetained, NodeRetained nodeRetained2, HashKey hashKey) {
        ArrayList<NodeRetained> arrayList = new ArrayList<NodeRetained>(5);
        NodeRetained nodeRetained3 = nodeRetained;
        if (nodeRetained3.inSharedGroup) {
            hashKey = new HashKey(hashKey);
        }
        do {
            if (nodeRetained3 == nodeRetained2) {
                return arrayList;
            }
            if (nodeRetained3.source.getCapability(1)) {
                arrayList.add(nodeRetained3);
            }
            if (!(nodeRetained3 instanceof SharedGroupRetained)) continue;
            String string = hashKey.getLastNodeId();
            Vector<NodeRetained> vector = ((SharedGroupRetained)nodeRetained3).parents;
            int n = vector.size();
            NodeRetained nodeRetained4 = nodeRetained3;
            for (int i = 0; i < n; ++i) {
                NodeRetained nodeRetained5 = vector.get(i);
                if (!nodeRetained5.nodeId.equals(string)) continue;
                nodeRetained3 = nodeRetained5;
                arrayList.add(nodeRetained3);
                break;
            }
            if (nodeRetained3 != nodeRetained4) continue;
            return null;
        } while ((nodeRetained3 = nodeRetained3.parent) != null);
        if (nodeRetained2 == null) {
            return arrayList;
        }
        return null;
    }

    private static Node[] mergePath(ArrayList<NodeRetained> arrayList, ArrayList<NodeRetained> arrayList2) {
        int n;
        int n2 = arrayList.size();
        int n3 = arrayList2 == null ? n2 : n2 + arrayList2.size();
        Node[] nodeArray = new Node[n3];
        int n4 = n3 - 1;
        for (n = 0; n < n2; ++n) {
            nodeArray[n4 - n] = (Node)arrayList.get((int)n).source;
        }
        int n5 = 0;
        while (n < n3) {
            nodeArray[n4 - n] = (Node)arrayList2.get((int)n5).source;
            ++n;
            ++n5;
        }
        return nodeArray;
    }

    static void sortGeomAtoms(GeometryAtom[] geometryAtomArray, PickShape pickShape) {
        double[] dArray = new double[geometryAtomArray.length];
        Point4d point4d = new Point4d();
        for (int i = 0; i < geometryAtomArray.length; ++i) {
            pickShape.intersect(geometryAtomArray[i].source.vwcBounds, point4d);
            dArray[i] = point4d.w;
        }
        class Sort {
            GeometryAtom[] atoms;
            final /* synthetic */ double[] val$distance;

            Sort(GeometryAtom[] geometryAtomArray) {
                this.val$distance = (double[])geometryAtomArray;
                this.atoms = var1_1;
            }

            void sorting() {
                if (this.atoms.length < 7) {
                    this.insertSort();
                } else {
                    this.quicksort(0, this.atoms.length - 1);
                }
            }

            final void insertSort() {
                for (int i = 0; i < this.atoms.length; ++i) {
                    for (int j = i; j > 0 && this.val$distance[j - 1] > this.val$distance[j]; --j) {
                        double d = this.val$distance[j];
                        this.val$distance[j] = this.val$distance[j - 1];
                        this.val$distance[j - 1] = d;
                        GeometryAtom geometryAtom = this.atoms[j];
                        this.atoms[j] = this.atoms[j - 1];
                        this.atoms[j - 1] = geometryAtom;
                    }
                }
            }

            final void quicksort(int n, int n2) {
                int n3 = n;
                int n4 = n2;
                double d = this.val$distance[(n + n2) / 2];
                while (true) {
                    if (this.val$distance[n3] < d) {
                        ++n3;
                        continue;
                    }
                    while (d < this.val$distance[n4]) {
                        --n4;
                    }
                    if (n3 <= n4) {
                        double d2 = this.val$distance[n3];
                        this.val$distance[n3] = this.val$distance[n4];
                        this.val$distance[n4] = d2;
                        GeometryAtom geometryAtom = this.atoms[n3];
                        this.atoms[n3] = this.atoms[n4];
                        this.atoms[n4] = geometryAtom;
                        ++n3;
                        --n4;
                    }
                    if (n3 > n4) break;
                }
                if (n < n4) {
                    this.quicksort(n, n4);
                }
                if (n < n2) {
                    this.quicksort(n3, n2);
                }
            }
        }
        new Sort(geometryAtomArray, dArray).sorting();
    }

    static ArrayList<PickInfo> getPickInfos(ArrayList<NodeRetained> arrayList, BranchGroupRetained branchGroupRetained, GeometryAtom[] geometryAtomArray, Locale locale, int n, int n2) {
        ArrayList<PickInfo> arrayList2 = new ArrayList<PickInfo>(5);
        ArrayList<NodeRetained> arrayList3 = null;
        if (geometryAtomArray == null || geometryAtomArray.length == 0) {
            return null;
        }
        for (int i = 0; i < geometryAtomArray.length; ++i) {
            int n3;
            int n4;
            Object object;
            Node[] nodeArray;
            assert (geometryAtomArray[i] != null && geometryAtomArray[i].source != null);
            PickInfo pickInfo = null;
            Shape3DRetained shape3DRetained = geometryAtomArray[i].source;
            NodeRetained nodeRetained = shape3DRetained.sourceNode;
            if (!PickInfo.inside(shape3DRetained.branchGroupPath, branchGroupRetained) || nodeRetained == null) continue;
            if (nodeRetained instanceof Shape3DRetained) {
                nodeArray = (Node[])nodeRetained;
                object = null;
                for (n4 = 0; n4 < nodeArray.geometryList.size() && (object = nodeArray.geometryList.get(n4)) == null; ++n4) {
                }
                if (object == null) continue;
                if (object instanceof Text3DRetained) {
                    if (arrayList3 == null) {
                        arrayList3 = new ArrayList<NodeRetained>(3);
                    } else {
                        n4 = arrayList3.size();
                        n3 = 0;
                        for (int j = 0; j < n4; ++j) {
                            if (arrayList3.get(j) != nodeRetained) continue;
                            n3 = 1;
                            break;
                        }
                        if (n3 != 0) continue;
                    }
                    arrayList3.add(nodeRetained);
                }
            }
            if (nodeRetained instanceof Shape3DCompileRetained) {
                nodeArray = (Shape3DCompileRetained)nodeRetained;
                object = null;
                n4 = 1;
                for (n3 = 0; n3 < nodeArray.srcList.length; ++n3) {
                    pickInfo = null;
                    if ((n & 1) != 0) {
                        if (n4 != 0) {
                            object = PickInfo.createPath(nodeRetained, branchGroupRetained, geometryAtomArray[i], arrayList);
                            n4 = 0;
                        }
                        if (object != null) {
                            SceneGraphPath sceneGraphPath = new SceneGraphPath(locale, (Node[])object, (Node)nodeArray.srcList[n3]);
                            sceneGraphPath.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
                            if (pickInfo == null) {
                                pickInfo = new PickInfo();
                            }
                            pickInfo.setSceneGraphPath(sceneGraphPath);
                        }
                    }
                    if ((n & 2) != 0) {
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setNode((Node)nodeArray.srcList[n3]);
                    }
                    if ((n & 4) != 0) {
                        Transform3D transform3D = geometryAtomArray[i].source.getCurrentLocalToVworld();
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setLocalToVWorld(new Transform3D(transform3D));
                    }
                    if ((n & 0x10) != 0 || (n & 0x20) != 0 || (n & 8) != 0 || (n & 0x40) != 0) {
                        if (pickInfo == null) {
                            pickInfo = new PickInfo();
                        }
                        pickInfo.setNodeRef((Node)nodeArray.srcList[n3]);
                        Transform3D transform3D = geometryAtomArray[i].source.getCurrentLocalToVworld();
                        pickInfo.setLocalToVWorldRef(transform3D);
                    }
                    if (pickInfo != null) {
                        arrayList2.add(pickInfo);
                    }
                    if (n2 != 2) continue;
                    return arrayList2;
                }
                continue;
            }
            nodeArray = null;
            if ((n & 1) != 0 && (nodeArray = PickInfo.createPath(nodeRetained, branchGroupRetained, geometryAtomArray[i], arrayList)) != null) {
                object = new SceneGraphPath(locale, nodeArray, (Node)nodeRetained.source);
                object.setTransform(shape3DRetained.getCurrentLocalToVworld(0));
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setSceneGraphPath((SceneGraphPath)object);
            }
            if ((n & 2) != 0) {
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setNode((Node)nodeRetained.source);
            }
            if ((n & 4) != 0) {
                object = geometryAtomArray[i].source.getCurrentLocalToVworld();
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setLocalToVWorld(new Transform3D((Transform3D)object));
            }
            if ((n & 0x10) != 0 || (n & 0x20) != 0 || (n & 8) != 0 || (n & 0x40) != 0) {
                if (pickInfo == null) {
                    pickInfo = new PickInfo();
                }
                pickInfo.setNodeRef((Node)nodeRetained.source);
                object = geometryAtomArray[i].source.getCurrentLocalToVworld();
                pickInfo.setLocalToVWorldRef((Transform3D)object);
            }
            if (pickInfo != null) {
                arrayList2.add(pickInfo);
            }
            if (n2 != 2) continue;
            return arrayList2;
        }
        return arrayList2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static PickInfo[] pick(Object object, GeometryAtom[] geometryAtomArray, int n, int n2, PickShape pickShape, int n3) {
        int n4;
        PickInfo[] pickInfoArray = null;
        Locale locale = null;
        BranchGroupRetained branchGroupRetained = null;
        ArrayList<PickInfo> arrayList = null;
        if (object instanceof Locale) {
            locale = (Locale)object;
        } else if (object instanceof BranchGroupRetained) {
            branchGroupRetained = (BranchGroupRetained)object;
            locale = branchGroupRetained.locale;
        }
        Object object2 = locale.universe.sceneGraphLock;
        synchronized (object2) {
            ArrayList<NodeRetained> arrayList2 = null;
            if (branchGroupRetained != null) {
                arrayList2 = PickInfo.initSceneGraphPath(branchGroupRetained);
            }
            arrayList = PickInfo.getPickInfos(arrayList2, branchGroupRetained, geometryAtomArray, locale, n2, n3);
        }
        if (n == 2 && arrayList != null && (n4 = arrayList.size()) > 0) {
            object2 = null;
            for (int i = n4 - 1; i >= 0; --i) {
                int n5;
                PickInfo pickInfo = arrayList.get(i);
                object2 = pickInfo.getNode();
                if (object2 == null) {
                    object2 = pickInfo.getNodeRef();
                }
                if (object2 instanceof Shape3D) {
                    if (!((SceneGraphObject)object2).getCapability(12)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo0"));
                    }
                    for (n5 = 0; n5 < ((Shape3D)object2).numGeometries(); ++n5) {
                        Geometry geometry = ((Shape3D)object2).getGeometry(n5);
                        if (geometry == null) continue;
                        if (!geometry.getCapability(18)) {
                            throw new CapabilityNotSetException(J3dI18N.getString("PickInfo1"));
                        }
                        if (geometry instanceof GeometryArray) {
                            if (!geometry.getCapability(0)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo2"));
                            }
                            if (!geometry.getCapability(8)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo3"));
                            }
                            if (!geometry.getCapability(17)) {
                                throw new CapabilityNotSetException(J3dI18N.getString("PickInfo4"));
                            }
                            if (!(geometry instanceof IndexedGeometryArray) || geometry.getCapability(9)) continue;
                            throw new CapabilityNotSetException(J3dI18N.getString("PickInfo5"));
                        }
                        if (!(geometry instanceof CompressedGeometry) || geometry.getCapability(2)) continue;
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo0"));
                    }
                    if (!((Shape3DRetained)((Node)object2).retained).intersect(pickInfo, pickShape, n2)) {
                        arrayList.remove(i);
                        continue;
                    }
                    if (n3 != 2) continue;
                    pickInfoArray = new PickInfo[]{pickInfo};
                    return pickInfoArray;
                }
                if (!(object2 instanceof Morph)) continue;
                if (!((SceneGraphObject)object2).getCapability(12)) {
                    throw new CapabilityNotSetException(J3dI18N.getString("PickInfo6"));
                }
                n5 = ((MorphRetained)((Node)object2).retained).getNumGeometryArrays();
                for (int j = 0; j < n5; ++j) {
                    GeometryArray geometryArray = ((Morph)object2).getGeometryArray(j);
                    if (geometryArray == null) continue;
                    if (!geometryArray.getCapability(18)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo1"));
                    }
                    if (!geometryArray.getCapability(0)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo2"));
                    }
                    if (!geometryArray.getCapability(8)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo3"));
                    }
                    if (!geometryArray.getCapability(17)) {
                        throw new CapabilityNotSetException(J3dI18N.getString("PickInfo4"));
                    }
                    if (!(geometryArray instanceof IndexedGeometryArray) || geometryArray.getCapability(9)) continue;
                    throw new CapabilityNotSetException(J3dI18N.getString("PickInfo5"));
                }
                if (!((MorphRetained)((Node)object2).retained).intersect(pickInfo, pickShape, n2)) {
                    arrayList.remove(i);
                    continue;
                }
                if (n3 != 2) continue;
                pickInfoArray = new PickInfo[]{pickInfo};
                return pickInfoArray;
            }
        }
        if (arrayList != null && arrayList.size() > 0) {
            pickInfoArray = new PickInfo[arrayList.size()];
            return arrayList.toArray(pickInfoArray);
        }
        return null;
    }

    public class IntersectionInfo {
        private int geomIndex;
        private Geometry geom;
        private Point3d intersectionPoint;
        private double distance;
        private int[] vertexIndices;

        IntersectionInfo() {
        }

        void setGeometryIndex(int n) {
            this.geomIndex = n;
        }

        void setGeometry(Geometry geometry) {
            this.geom = geometry;
        }

        void setIntersectionPoint(Point3d point3d) {
            assert (point3d != null);
            this.intersectionPoint = new Point3d(point3d);
        }

        void setDistance(double d) {
            this.distance = d;
        }

        void setVertexIndices(int[] nArray) {
            assert (nArray != null);
            this.vertexIndices = new int[nArray.length];
            for (int i = 0; i < nArray.length; ++i) {
                this.vertexIndices[i] = nArray[i];
            }
        }

        public int getGeometryIndex() {
            return this.geomIndex;
        }

        public Geometry getGeometry() {
            return this.geom;
        }

        public Point3d getIntersectionPoint() {
            return this.intersectionPoint;
        }

        public double getDistance() {
            return this.distance;
        }

        public int[] getVertexIndices() {
            return this.vertexIndices;
        }
    }
}

