﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSMap.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/mediaconnect/MediaConnect_EXPORTS.h>
#include <aws/mediaconnect/model/NetworkInterfaceType.h>

#include <utility>

namespace Aws {
namespace Utils {
namespace Json {
class JsonValue;
class JsonView;
}  // namespace Json
}  // namespace Utils
namespace MediaConnect {
namespace Model {

/**
 * <p>The details of the VPC interfaces that you want to add to the flow.
 * </p><p><h3>See Also:</h3>   <a
 * href="http://docs.aws.amazon.com/goto/WebAPI/mediaconnect-2018-11-14/VpcInterfaceRequest">AWS
 * API Reference</a></p>
 */
class VpcInterfaceRequest {
 public:
  AWS_MEDIACONNECT_API VpcInterfaceRequest() = default;
  AWS_MEDIACONNECT_API VpcInterfaceRequest(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIACONNECT_API VpcInterfaceRequest& operator=(Aws::Utils::Json::JsonView jsonValue);
  AWS_MEDIACONNECT_API Aws::Utils::Json::JsonValue Jsonize() const;

  ///@{
  /**
   * <p>The name for the VPC interface. This name must be unique within the flow.
   * </p>
   */
  inline const Aws::String& GetName() const { return m_name; }
  inline bool NameHasBeenSet() const { return m_nameHasBeenSet; }
  template <typename NameT = Aws::String>
  void SetName(NameT&& value) {
    m_nameHasBeenSet = true;
    m_name = std::forward<NameT>(value);
  }
  template <typename NameT = Aws::String>
  VpcInterfaceRequest& WithName(NameT&& value) {
    SetName(std::forward<NameT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The type of network interface. </p>
   */
  inline NetworkInterfaceType GetNetworkInterfaceType() const { return m_networkInterfaceType; }
  inline bool NetworkInterfaceTypeHasBeenSet() const { return m_networkInterfaceTypeHasBeenSet; }
  inline void SetNetworkInterfaceType(NetworkInterfaceType value) {
    m_networkInterfaceTypeHasBeenSet = true;
    m_networkInterfaceType = value;
  }
  inline VpcInterfaceRequest& WithNetworkInterfaceType(NetworkInterfaceType value) {
    SetNetworkInterfaceType(value);
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>The Amazon Resource Name (ARN) of the role that you created when you set up
   * MediaConnect as a trusted service. </p>
   */
  inline const Aws::String& GetRoleArn() const { return m_roleArn; }
  inline bool RoleArnHasBeenSet() const { return m_roleArnHasBeenSet; }
  template <typename RoleArnT = Aws::String>
  void SetRoleArn(RoleArnT&& value) {
    m_roleArnHasBeenSet = true;
    m_roleArn = std::forward<RoleArnT>(value);
  }
  template <typename RoleArnT = Aws::String>
  VpcInterfaceRequest& WithRoleArn(RoleArnT&& value) {
    SetRoleArn(std::forward<RoleArnT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>A virtual firewall to control inbound and outbound traffic. </p>
   */
  inline const Aws::Vector<Aws::String>& GetSecurityGroupIds() const { return m_securityGroupIds; }
  inline bool SecurityGroupIdsHasBeenSet() const { return m_securityGroupIdsHasBeenSet; }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  void SetSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds = std::forward<SecurityGroupIdsT>(value);
  }
  template <typename SecurityGroupIdsT = Aws::Vector<Aws::String>>
  VpcInterfaceRequest& WithSecurityGroupIds(SecurityGroupIdsT&& value) {
    SetSecurityGroupIds(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  template <typename SecurityGroupIdsT = Aws::String>
  VpcInterfaceRequest& AddSecurityGroupIds(SecurityGroupIdsT&& value) {
    m_securityGroupIdsHasBeenSet = true;
    m_securityGroupIds.emplace_back(std::forward<SecurityGroupIdsT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The subnet IDs that you want to use for your VPC interface. A range of IP
   * addresses in your VPC. When you create your VPC, you specify a range of IPv4
   * addresses for the VPC in the form of a Classless Inter-Domain Routing (CIDR)
   * block; for example, 10.0.0.0/16. This is the primary CIDR block for your VPC.
   * When you create a subnet for your VPC, you specify the CIDR block for the
   * subnet, which is a subset of the VPC CIDR block. The subnets that you use across
   * all VPC interfaces on the flow must be in the same Availability Zone as the
   * flow. </p>
   */
  inline const Aws::String& GetSubnetId() const { return m_subnetId; }
  inline bool SubnetIdHasBeenSet() const { return m_subnetIdHasBeenSet; }
  template <typename SubnetIdT = Aws::String>
  void SetSubnetId(SubnetIdT&& value) {
    m_subnetIdHasBeenSet = true;
    m_subnetId = std::forward<SubnetIdT>(value);
  }
  template <typename SubnetIdT = Aws::String>
  VpcInterfaceRequest& WithSubnetId(SubnetIdT&& value) {
    SetSubnetId(std::forward<SubnetIdT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p> The key-value pairs that can be used to tag and organize the VPC network
   * interface. </p>
   */
  inline const Aws::Map<Aws::String, Aws::String>& GetVpcInterfaceTags() const { return m_vpcInterfaceTags; }
  inline bool VpcInterfaceTagsHasBeenSet() const { return m_vpcInterfaceTagsHasBeenSet; }
  template <typename VpcInterfaceTagsT = Aws::Map<Aws::String, Aws::String>>
  void SetVpcInterfaceTags(VpcInterfaceTagsT&& value) {
    m_vpcInterfaceTagsHasBeenSet = true;
    m_vpcInterfaceTags = std::forward<VpcInterfaceTagsT>(value);
  }
  template <typename VpcInterfaceTagsT = Aws::Map<Aws::String, Aws::String>>
  VpcInterfaceRequest& WithVpcInterfaceTags(VpcInterfaceTagsT&& value) {
    SetVpcInterfaceTags(std::forward<VpcInterfaceTagsT>(value));
    return *this;
  }
  template <typename VpcInterfaceTagsKeyT = Aws::String, typename VpcInterfaceTagsValueT = Aws::String>
  VpcInterfaceRequest& AddVpcInterfaceTags(VpcInterfaceTagsKeyT&& key, VpcInterfaceTagsValueT&& value) {
    m_vpcInterfaceTagsHasBeenSet = true;
    m_vpcInterfaceTags.emplace(std::forward<VpcInterfaceTagsKeyT>(key), std::forward<VpcInterfaceTagsValueT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_name;
  bool m_nameHasBeenSet = false;

  NetworkInterfaceType m_networkInterfaceType{NetworkInterfaceType::NOT_SET};
  bool m_networkInterfaceTypeHasBeenSet = false;

  Aws::String m_roleArn;
  bool m_roleArnHasBeenSet = false;

  Aws::Vector<Aws::String> m_securityGroupIds;
  bool m_securityGroupIdsHasBeenSet = false;

  Aws::String m_subnetId;
  bool m_subnetIdHasBeenSet = false;

  Aws::Map<Aws::String, Aws::String> m_vpcInterfaceTags;
  bool m_vpcInterfaceTagsHasBeenSet = false;
};

}  // namespace Model
}  // namespace MediaConnect
}  // namespace Aws
