﻿/**
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * SPDX-License-Identifier: Apache-2.0.
 */

#pragma once
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/pca-connector-ad/PcaConnectorAd_EXPORTS.h>
#include <aws/pca-connector-ad/model/TemplateSummary.h>

#include <utility>

namespace Aws {
template <typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils {
namespace Json {
class JsonValue;
}  // namespace Json
}  // namespace Utils
namespace PcaConnectorAd {
namespace Model {
class ListTemplatesResult {
 public:
  AWS_PCACONNECTORAD_API ListTemplatesResult() = default;
  AWS_PCACONNECTORAD_API ListTemplatesResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
  AWS_PCACONNECTORAD_API ListTemplatesResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);

  ///@{
  /**
   * <p>Use this parameter when paginating results in a subsequent request after you
   * receive a response with truncated results. Set it to the value of the
   * <code>NextToken</code> parameter from the response you just received.</p>
   */
  inline const Aws::String& GetNextToken() const { return m_nextToken; }
  template <typename NextTokenT = Aws::String>
  void SetNextToken(NextTokenT&& value) {
    m_nextTokenHasBeenSet = true;
    m_nextToken = std::forward<NextTokenT>(value);
  }
  template <typename NextTokenT = Aws::String>
  ListTemplatesResult& WithNextToken(NextTokenT&& value) {
    SetNextToken(std::forward<NextTokenT>(value));
    return *this;
  }
  ///@}

  ///@{
  /**
   * <p>Custom configuration templates used when issuing a certificate. </p>
   */
  inline const Aws::Vector<TemplateSummary>& GetTemplates() const { return m_templates; }
  template <typename TemplatesT = Aws::Vector<TemplateSummary>>
  void SetTemplates(TemplatesT&& value) {
    m_templatesHasBeenSet = true;
    m_templates = std::forward<TemplatesT>(value);
  }
  template <typename TemplatesT = Aws::Vector<TemplateSummary>>
  ListTemplatesResult& WithTemplates(TemplatesT&& value) {
    SetTemplates(std::forward<TemplatesT>(value));
    return *this;
  }
  template <typename TemplatesT = TemplateSummary>
  ListTemplatesResult& AddTemplates(TemplatesT&& value) {
    m_templatesHasBeenSet = true;
    m_templates.emplace_back(std::forward<TemplatesT>(value));
    return *this;
  }
  ///@}

  ///@{

  inline const Aws::String& GetRequestId() const { return m_requestId; }
  template <typename RequestIdT = Aws::String>
  void SetRequestId(RequestIdT&& value) {
    m_requestIdHasBeenSet = true;
    m_requestId = std::forward<RequestIdT>(value);
  }
  template <typename RequestIdT = Aws::String>
  ListTemplatesResult& WithRequestId(RequestIdT&& value) {
    SetRequestId(std::forward<RequestIdT>(value));
    return *this;
  }
  ///@}
 private:
  Aws::String m_nextToken;

  Aws::Vector<TemplateSummary> m_templates;

  Aws::String m_requestId;
  bool m_nextTokenHasBeenSet = false;
  bool m_templatesHasBeenSet = false;
  bool m_requestIdHasBeenSet = false;
};

}  // namespace Model
}  // namespace PcaConnectorAd
}  // namespace Aws
