/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.Clazz;
import proguard.classfile.Method;
import proguard.classfile.attribute.CodeAttribute;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.SwitchInstruction;
import proguard.classfile.instruction.visitor.InstructionVisitor;

public class TableSwitchInstruction
extends SwitchInstruction {
    public int lowCase;
    public int highCase;

    public TableSwitchInstruction() {
    }

    public TableSwitchInstruction(byte opcode, int defaultOffset, int lowCase, int highCase, int[] jumpOffsets) {
        this.opcode = opcode;
        this.defaultOffset = defaultOffset;
        this.lowCase = lowCase;
        this.highCase = highCase;
        this.jumpOffsets = jumpOffsets;
    }

    public TableSwitchInstruction copy(TableSwitchInstruction tableSwitchInstruction) {
        this.opcode = tableSwitchInstruction.opcode;
        this.defaultOffset = tableSwitchInstruction.defaultOffset;
        this.lowCase = tableSwitchInstruction.lowCase;
        this.highCase = tableSwitchInstruction.highCase;
        this.jumpOffsets = tableSwitchInstruction.jumpOffsets;
        return this;
    }

    @Override
    public Instruction shrink() {
        return this;
    }

    @Override
    protected void readInfo(byte[] code, int offset) {
        offset += -offset & 3;
        this.defaultOffset = TableSwitchInstruction.readInt(code, offset);
        this.lowCase = TableSwitchInstruction.readInt(code, offset += 4);
        this.highCase = TableSwitchInstruction.readInt(code, offset += 4);
        offset += 4;
        this.jumpOffsets = new int[this.highCase - this.lowCase + 1];
        for (int index = 0; index < this.jumpOffsets.length; ++index) {
            this.jumpOffsets[index] = TableSwitchInstruction.readInt(code, offset);
            offset += 4;
        }
    }

    @Override
    protected void writeInfo(byte[] code, int offset) {
        while ((offset & 3) != 0) {
            TableSwitchInstruction.writeByte(code, offset++, 0);
        }
        TableSwitchInstruction.writeInt(code, offset, this.defaultOffset);
        TableSwitchInstruction.writeInt(code, offset += 4, this.lowCase);
        TableSwitchInstruction.writeInt(code, offset += 4, this.highCase);
        offset += 4;
        int length = this.highCase - this.lowCase + 1;
        for (int index = 0; index < length; ++index) {
            TableSwitchInstruction.writeInt(code, offset, this.jumpOffsets[index]);
            offset += 4;
        }
    }

    @Override
    public int length(int offset) {
        return 1 + (-(offset + 1) & 3) + 12 + (this.highCase - this.lowCase + 1) * 4;
    }

    @Override
    public void accept(Clazz clazz, Method method, CodeAttribute codeAttribute, int offset, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitTableSwitchInstruction(clazz, method, codeAttribute, offset, this);
    }
}

