/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.oops;

import java.io.PrintStream;
import java.util.Observable;
import java.util.Observer;
import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.oops.ArrayKlass;
import sun.jvm.hotspot.oops.Klass;
import sun.jvm.hotspot.oops.MetadataField;
import sun.jvm.hotspot.oops.MetadataVisitor;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.types.Type;
import sun.jvm.hotspot.types.TypeDataBase;
import sun.jvm.hotspot.types.WrongTypeException;
import sun.jvm.hotspot.utilities.Assert;

public class ObjArrayKlass
extends ArrayKlass {
    private static MetadataField elementKlass;
    private static MetadataField bottomKlass;

    private static synchronized void initialize(TypeDataBase db) throws WrongTypeException {
        Type type = db.lookupType("ObjArrayKlass");
        elementKlass = new MetadataField(type.getAddressField("_element_klass"), 0L);
        bottomKlass = new MetadataField(type.getAddressField("_bottom_klass"), 0L);
    }

    public ObjArrayKlass(Address addr) {
        super(addr);
    }

    public Klass getElementKlass() {
        return (Klass)elementKlass.getValue(this);
    }

    public Klass getBottomKlass() {
        return (Klass)bottomKlass.getValue(this);
    }

    @Override
    public long computeModifierFlags() {
        long elementFlags = this.getElementKlass().computeModifierFlags();
        long arrayFlags = 0L;
        arrayFlags = (elementFlags & 5L) != 0L ? 1041L : 1040L;
        return arrayFlags;
    }

    @Override
    public void iterateFields(MetadataVisitor visitor) {
        super.iterateFields(visitor);
        visitor.doMetadata(elementKlass, true);
        visitor.doMetadata(bottomKlass, true);
    }

    @Override
    public Klass arrayKlassImpl(boolean orNull, int n) {
        int dimension;
        if (Assert.ASSERTS_ENABLED) {
            Assert.that(this.getDimension() <= (long)n, "check order of chain");
        }
        if ((dimension = (int)this.getDimension()) == n) {
            return this;
        }
        ObjArrayKlass ak = (ObjArrayKlass)this.getHigherDimension();
        if (ak == null) {
            if (orNull) {
                return null;
            }
            throw new RuntimeException("Can not allocate array klasses in debugging system");
        }
        if (orNull) {
            return ak.arrayKlassOrNull(n);
        }
        return ak.arrayKlass(n);
    }

    @Override
    public Klass arrayKlassImpl(boolean orNull) {
        return this.arrayKlassImpl(orNull, (int)(this.getDimension() + 1L));
    }

    @Override
    public void printValueOn(PrintStream tty) {
        tty.print("ObjArrayKlass for ");
        this.getElementKlass().printValueOn(tty);
    }

    static {
        VM.registerVMInitializedObserver(new Observer(){

            @Override
            public void update(Observable o, Object data) {
                ObjArrayKlass.initialize(VM.getVM().getTypeDataBase());
            }
        });
    }
}

