/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.core.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.core.model.AutotunePolicy;
import com.oracle.bmc.core.model.BootVolumeReplicaInfo;
import com.oracle.bmc.core.model.BootVolumeSourceDetails;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import com.oracle.bmc.http.internal.BmcEnum;
import java.beans.ConstructorProperties;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class BootVolume
extends ExplicitlySetBmcModel {
    @JsonProperty(value="availabilityDomain")
    private final String availabilityDomain;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;
    @JsonProperty(value="systemTags")
    private final Map<String, Map<String, Object>> systemTags;
    @JsonProperty(value="displayName")
    private final String displayName;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="id")
    private final String id;
    @JsonProperty(value="imageId")
    private final String imageId;
    @JsonProperty(value="isHydrated")
    private final Boolean isHydrated;
    @JsonProperty(value="vpusPerGB")
    private final Long vpusPerGB;
    @JsonProperty(value="lifecycleState")
    private final LifecycleState lifecycleState;
    @JsonProperty(value="sizeInGBs")
    private final Long sizeInGBs;
    @JsonProperty(value="sizeInMBs")
    private final Long sizeInMBs;
    @JsonProperty(value="sourceDetails")
    private final BootVolumeSourceDetails sourceDetails;
    @JsonProperty(value="timeCreated")
    private final Date timeCreated;
    @JsonProperty(value="volumeGroupId")
    private final String volumeGroupId;
    @JsonProperty(value="kmsKeyId")
    private final String kmsKeyId;
    @JsonProperty(value="isAutoTuneEnabled")
    private final Boolean isAutoTuneEnabled;
    @JsonProperty(value="autoTunedVpusPerGB")
    private final Long autoTunedVpusPerGB;
    @JsonProperty(value="bootVolumeReplicas")
    private final List<BootVolumeReplicaInfo> bootVolumeReplicas;
    @JsonProperty(value="autotunePolicies")
    private final List<AutotunePolicy> autotunePolicies;

    @Deprecated
    @ConstructorProperties(value={"availabilityDomain", "compartmentId", "definedTags", "systemTags", "displayName", "freeformTags", "id", "imageId", "isHydrated", "vpusPerGB", "lifecycleState", "sizeInGBs", "sizeInMBs", "sourceDetails", "timeCreated", "volumeGroupId", "kmsKeyId", "isAutoTuneEnabled", "autoTunedVpusPerGB", "bootVolumeReplicas", "autotunePolicies"})
    public BootVolume(String availabilityDomain, String compartmentId, Map<String, Map<String, Object>> definedTags, Map<String, Map<String, Object>> systemTags, String displayName, Map<String, String> freeformTags, String id, String imageId, Boolean isHydrated, Long vpusPerGB, LifecycleState lifecycleState, Long sizeInGBs, Long sizeInMBs, BootVolumeSourceDetails sourceDetails, Date timeCreated, String volumeGroupId, String kmsKeyId, Boolean isAutoTuneEnabled, Long autoTunedVpusPerGB, List<BootVolumeReplicaInfo> bootVolumeReplicas, List<AutotunePolicy> autotunePolicies) {
        this.availabilityDomain = availabilityDomain;
        this.compartmentId = compartmentId;
        this.definedTags = definedTags;
        this.systemTags = systemTags;
        this.displayName = displayName;
        this.freeformTags = freeformTags;
        this.id = id;
        this.imageId = imageId;
        this.isHydrated = isHydrated;
        this.vpusPerGB = vpusPerGB;
        this.lifecycleState = lifecycleState;
        this.sizeInGBs = sizeInGBs;
        this.sizeInMBs = sizeInMBs;
        this.sourceDetails = sourceDetails;
        this.timeCreated = timeCreated;
        this.volumeGroupId = volumeGroupId;
        this.kmsKeyId = kmsKeyId;
        this.isAutoTuneEnabled = isAutoTuneEnabled;
        this.autoTunedVpusPerGB = autoTunedVpusPerGB;
        this.bootVolumeReplicas = bootVolumeReplicas;
        this.autotunePolicies = autotunePolicies;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getAvailabilityDomain() {
        return this.availabilityDomain;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public Map<String, Map<String, Object>> getSystemTags() {
        return this.systemTags;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public String getId() {
        return this.id;
    }

    public String getImageId() {
        return this.imageId;
    }

    public Boolean getIsHydrated() {
        return this.isHydrated;
    }

    public Long getVpusPerGB() {
        return this.vpusPerGB;
    }

    public LifecycleState getLifecycleState() {
        return this.lifecycleState;
    }

    public Long getSizeInGBs() {
        return this.sizeInGBs;
    }

    public Long getSizeInMBs() {
        return this.sizeInMBs;
    }

    public BootVolumeSourceDetails getSourceDetails() {
        return this.sourceDetails;
    }

    public Date getTimeCreated() {
        return this.timeCreated;
    }

    public String getVolumeGroupId() {
        return this.volumeGroupId;
    }

    public String getKmsKeyId() {
        return this.kmsKeyId;
    }

    public Boolean getIsAutoTuneEnabled() {
        return this.isAutoTuneEnabled;
    }

    public Long getAutoTunedVpusPerGB() {
        return this.autoTunedVpusPerGB;
    }

    public List<BootVolumeReplicaInfo> getBootVolumeReplicas() {
        return this.bootVolumeReplicas;
    }

    public List<AutotunePolicy> getAutotunePolicies() {
        return this.autotunePolicies;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("BootVolume(");
        sb.append("super=").append(super.toString());
        sb.append("availabilityDomain=").append(String.valueOf(this.availabilityDomain));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(", systemTags=").append(String.valueOf(this.systemTags));
        sb.append(", displayName=").append(String.valueOf(this.displayName));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", id=").append(String.valueOf(this.id));
        sb.append(", imageId=").append(String.valueOf(this.imageId));
        sb.append(", isHydrated=").append(String.valueOf(this.isHydrated));
        sb.append(", vpusPerGB=").append(String.valueOf(this.vpusPerGB));
        sb.append(", lifecycleState=").append(String.valueOf((Object)this.lifecycleState));
        sb.append(", sizeInGBs=").append(String.valueOf(this.sizeInGBs));
        sb.append(", sizeInMBs=").append(String.valueOf(this.sizeInMBs));
        sb.append(", sourceDetails=").append(String.valueOf((Object)this.sourceDetails));
        sb.append(", timeCreated=").append(String.valueOf(this.timeCreated));
        sb.append(", volumeGroupId=").append(String.valueOf(this.volumeGroupId));
        sb.append(", kmsKeyId=").append(String.valueOf(this.kmsKeyId));
        sb.append(", isAutoTuneEnabled=").append(String.valueOf(this.isAutoTuneEnabled));
        sb.append(", autoTunedVpusPerGB=").append(String.valueOf(this.autoTunedVpusPerGB));
        sb.append(", bootVolumeReplicas=").append(String.valueOf(this.bootVolumeReplicas));
        sb.append(", autotunePolicies=").append(String.valueOf(this.autotunePolicies));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BootVolume)) {
            return false;
        }
        BootVolume other = (BootVolume)((Object)o);
        return Objects.equals(this.availabilityDomain, other.availabilityDomain) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.definedTags, other.definedTags) && Objects.equals(this.systemTags, other.systemTags) && Objects.equals(this.displayName, other.displayName) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.id, other.id) && Objects.equals(this.imageId, other.imageId) && Objects.equals(this.isHydrated, other.isHydrated) && Objects.equals(this.vpusPerGB, other.vpusPerGB) && Objects.equals((Object)this.lifecycleState, (Object)other.lifecycleState) && Objects.equals(this.sizeInGBs, other.sizeInGBs) && Objects.equals(this.sizeInMBs, other.sizeInMBs) && Objects.equals((Object)this.sourceDetails, (Object)other.sourceDetails) && Objects.equals(this.timeCreated, other.timeCreated) && Objects.equals(this.volumeGroupId, other.volumeGroupId) && Objects.equals(this.kmsKeyId, other.kmsKeyId) && Objects.equals(this.isAutoTuneEnabled, other.isAutoTuneEnabled) && Objects.equals(this.autoTunedVpusPerGB, other.autoTunedVpusPerGB) && Objects.equals(this.bootVolumeReplicas, other.bootVolumeReplicas) && Objects.equals(this.autotunePolicies, other.autotunePolicies) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.availabilityDomain == null ? 43 : this.availabilityDomain.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + (this.systemTags == null ? 43 : this.systemTags.hashCode());
        result = result * 59 + (this.displayName == null ? 43 : this.displayName.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.id == null ? 43 : this.id.hashCode());
        result = result * 59 + (this.imageId == null ? 43 : this.imageId.hashCode());
        result = result * 59 + (this.isHydrated == null ? 43 : this.isHydrated.hashCode());
        result = result * 59 + (this.vpusPerGB == null ? 43 : this.vpusPerGB.hashCode());
        result = result * 59 + (this.lifecycleState == null ? 43 : this.lifecycleState.hashCode());
        result = result * 59 + (this.sizeInGBs == null ? 43 : this.sizeInGBs.hashCode());
        result = result * 59 + (this.sizeInMBs == null ? 43 : this.sizeInMBs.hashCode());
        result = result * 59 + (this.sourceDetails == null ? 43 : this.sourceDetails.hashCode());
        result = result * 59 + (this.timeCreated == null ? 43 : this.timeCreated.hashCode());
        result = result * 59 + (this.volumeGroupId == null ? 43 : this.volumeGroupId.hashCode());
        result = result * 59 + (this.kmsKeyId == null ? 43 : this.kmsKeyId.hashCode());
        result = result * 59 + (this.isAutoTuneEnabled == null ? 43 : this.isAutoTuneEnabled.hashCode());
        result = result * 59 + (this.autoTunedVpusPerGB == null ? 43 : this.autoTunedVpusPerGB.hashCode());
        result = result * 59 + (this.bootVolumeReplicas == null ? 43 : this.bootVolumeReplicas.hashCode());
        result = result * 59 + (this.autotunePolicies == null ? 43 : this.autotunePolicies.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    public static enum LifecycleState implements BmcEnum
    {
        Provisioning("PROVISIONING"),
        Restoring("RESTORING"),
        Available("AVAILABLE"),
        Terminating("TERMINATING"),
        Terminated("TERMINATED"),
        Faulty("FAULTY"),
        UnknownEnumValue(null);

        private static final Logger LOG;
        private final String value;
        private static Map<String, LifecycleState> map;

        private LifecycleState(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        @JsonCreator
        public static LifecycleState create(String key) {
            if (map.containsKey(key)) {
                return map.get(key);
            }
            LOG.warn("Received unknown value '{}' for enum 'LifecycleState', returning UnknownEnumValue", (Object)key);
            return UnknownEnumValue;
        }

        static {
            LOG = LoggerFactory.getLogger(LifecycleState.class);
            map = new HashMap<String, LifecycleState>();
            for (LifecycleState v : LifecycleState.values()) {
                if (v == UnknownEnumValue) continue;
                map.put(v.getValue(), v);
            }
        }
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="availabilityDomain")
        private String availabilityDomain;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonProperty(value="systemTags")
        private Map<String, Map<String, Object>> systemTags;
        @JsonProperty(value="displayName")
        private String displayName;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="imageId")
        private String imageId;
        @JsonProperty(value="isHydrated")
        private Boolean isHydrated;
        @JsonProperty(value="vpusPerGB")
        private Long vpusPerGB;
        @JsonProperty(value="lifecycleState")
        private LifecycleState lifecycleState;
        @JsonProperty(value="sizeInGBs")
        private Long sizeInGBs;
        @JsonProperty(value="sizeInMBs")
        private Long sizeInMBs;
        @JsonProperty(value="sourceDetails")
        private BootVolumeSourceDetails sourceDetails;
        @JsonProperty(value="timeCreated")
        private Date timeCreated;
        @JsonProperty(value="volumeGroupId")
        private String volumeGroupId;
        @JsonProperty(value="kmsKeyId")
        private String kmsKeyId;
        @JsonProperty(value="isAutoTuneEnabled")
        private Boolean isAutoTuneEnabled;
        @JsonProperty(value="autoTunedVpusPerGB")
        private Long autoTunedVpusPerGB;
        @JsonProperty(value="bootVolumeReplicas")
        private List<BootVolumeReplicaInfo> bootVolumeReplicas;
        @JsonProperty(value="autotunePolicies")
        private List<AutotunePolicy> autotunePolicies;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder availabilityDomain(String availabilityDomain) {
            this.availabilityDomain = availabilityDomain;
            this.__explicitlySet__.add("availabilityDomain");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public Builder systemTags(Map<String, Map<String, Object>> systemTags) {
            this.systemTags = systemTags;
            this.__explicitlySet__.add("systemTags");
            return this;
        }

        public Builder displayName(String displayName) {
            this.displayName = displayName;
            this.__explicitlySet__.add("displayName");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder id(String id) {
            this.id = id;
            this.__explicitlySet__.add("id");
            return this;
        }

        public Builder imageId(String imageId) {
            this.imageId = imageId;
            this.__explicitlySet__.add("imageId");
            return this;
        }

        public Builder isHydrated(Boolean isHydrated) {
            this.isHydrated = isHydrated;
            this.__explicitlySet__.add("isHydrated");
            return this;
        }

        public Builder vpusPerGB(Long vpusPerGB) {
            this.vpusPerGB = vpusPerGB;
            this.__explicitlySet__.add("vpusPerGB");
            return this;
        }

        public Builder lifecycleState(LifecycleState lifecycleState) {
            this.lifecycleState = lifecycleState;
            this.__explicitlySet__.add("lifecycleState");
            return this;
        }

        public Builder sizeInGBs(Long sizeInGBs) {
            this.sizeInGBs = sizeInGBs;
            this.__explicitlySet__.add("sizeInGBs");
            return this;
        }

        public Builder sizeInMBs(Long sizeInMBs) {
            this.sizeInMBs = sizeInMBs;
            this.__explicitlySet__.add("sizeInMBs");
            return this;
        }

        public Builder sourceDetails(BootVolumeSourceDetails sourceDetails) {
            this.sourceDetails = sourceDetails;
            this.__explicitlySet__.add("sourceDetails");
            return this;
        }

        public Builder timeCreated(Date timeCreated) {
            this.timeCreated = timeCreated;
            this.__explicitlySet__.add("timeCreated");
            return this;
        }

        public Builder volumeGroupId(String volumeGroupId) {
            this.volumeGroupId = volumeGroupId;
            this.__explicitlySet__.add("volumeGroupId");
            return this;
        }

        public Builder kmsKeyId(String kmsKeyId) {
            this.kmsKeyId = kmsKeyId;
            this.__explicitlySet__.add("kmsKeyId");
            return this;
        }

        public Builder isAutoTuneEnabled(Boolean isAutoTuneEnabled) {
            this.isAutoTuneEnabled = isAutoTuneEnabled;
            this.__explicitlySet__.add("isAutoTuneEnabled");
            return this;
        }

        public Builder autoTunedVpusPerGB(Long autoTunedVpusPerGB) {
            this.autoTunedVpusPerGB = autoTunedVpusPerGB;
            this.__explicitlySet__.add("autoTunedVpusPerGB");
            return this;
        }

        public Builder bootVolumeReplicas(List<BootVolumeReplicaInfo> bootVolumeReplicas) {
            this.bootVolumeReplicas = bootVolumeReplicas;
            this.__explicitlySet__.add("bootVolumeReplicas");
            return this;
        }

        public Builder autotunePolicies(List<AutotunePolicy> autotunePolicies) {
            this.autotunePolicies = autotunePolicies;
            this.__explicitlySet__.add("autotunePolicies");
            return this;
        }

        public BootVolume build() {
            BootVolume model = new BootVolume(this.availabilityDomain, this.compartmentId, this.definedTags, this.systemTags, this.displayName, this.freeformTags, this.id, this.imageId, this.isHydrated, this.vpusPerGB, this.lifecycleState, this.sizeInGBs, this.sizeInMBs, this.sourceDetails, this.timeCreated, this.volumeGroupId, this.kmsKeyId, this.isAutoTuneEnabled, this.autoTunedVpusPerGB, this.bootVolumeReplicas, this.autotunePolicies);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(BootVolume model) {
            if (model.wasPropertyExplicitlySet("availabilityDomain")) {
                this.availabilityDomain(model.getAvailabilityDomain());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            if (model.wasPropertyExplicitlySet("systemTags")) {
                this.systemTags(model.getSystemTags());
            }
            if (model.wasPropertyExplicitlySet("displayName")) {
                this.displayName(model.getDisplayName());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("id")) {
                this.id(model.getId());
            }
            if (model.wasPropertyExplicitlySet("imageId")) {
                this.imageId(model.getImageId());
            }
            if (model.wasPropertyExplicitlySet("isHydrated")) {
                this.isHydrated(model.getIsHydrated());
            }
            if (model.wasPropertyExplicitlySet("vpusPerGB")) {
                this.vpusPerGB(model.getVpusPerGB());
            }
            if (model.wasPropertyExplicitlySet("lifecycleState")) {
                this.lifecycleState(model.getLifecycleState());
            }
            if (model.wasPropertyExplicitlySet("sizeInGBs")) {
                this.sizeInGBs(model.getSizeInGBs());
            }
            if (model.wasPropertyExplicitlySet("sizeInMBs")) {
                this.sizeInMBs(model.getSizeInMBs());
            }
            if (model.wasPropertyExplicitlySet("sourceDetails")) {
                this.sourceDetails(model.getSourceDetails());
            }
            if (model.wasPropertyExplicitlySet("timeCreated")) {
                this.timeCreated(model.getTimeCreated());
            }
            if (model.wasPropertyExplicitlySet("volumeGroupId")) {
                this.volumeGroupId(model.getVolumeGroupId());
            }
            if (model.wasPropertyExplicitlySet("kmsKeyId")) {
                this.kmsKeyId(model.getKmsKeyId());
            }
            if (model.wasPropertyExplicitlySet("isAutoTuneEnabled")) {
                this.isAutoTuneEnabled(model.getIsAutoTuneEnabled());
            }
            if (model.wasPropertyExplicitlySet("autoTunedVpusPerGB")) {
                this.autoTunedVpusPerGB(model.getAutoTunedVpusPerGB());
            }
            if (model.wasPropertyExplicitlySet("bootVolumeReplicas")) {
                this.bootVolumeReplicas(model.getBootVolumeReplicas());
            }
            if (model.wasPropertyExplicitlySet("autotunePolicies")) {
                this.autotunePolicies(model.getAutotunePolicies());
            }
            return this;
        }
    }
}

