/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib2.highlighting;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.EventListener;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.AttributeSet;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleConstants;
import org.netbeans.api.editor.caret.CaretInfo;
import org.netbeans.api.editor.caret.EditorCaret;
import org.netbeans.api.editor.caret.EditorCaretEvent;
import org.netbeans.api.editor.caret.EditorCaretListener;
import org.netbeans.api.editor.settings.AttributesUtilities;
import org.netbeans.lib.editor.util.ListenerList;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.netbeans.spi.editor.highlighting.HighlightsChangeEvent;
import org.netbeans.spi.editor.highlighting.HighlightsChangeListener;
import org.netbeans.spi.editor.highlighting.HighlightsSequence;
import org.netbeans.spi.editor.highlighting.ReleasableHighlightsContainer;
import org.netbeans.spi.editor.highlighting.SplitOffsetHighlightsSequence;
import org.openide.util.WeakListeners;

public final class CaretOverwriteModeHighlighting
implements ReleasableHighlightsContainer,
PropertyChangeListener,
EditorCaretListener {
    public static final String LAYER_TYPE_ID = "org.netbeans.modules.editor.lib2.highlighting.CaretOverwriteModeHighlighting";
    private static final Logger LOG = Logger.getLogger(CaretOverwriteModeHighlighting.class.getName());
    private final JTextComponent component;
    private boolean inited;
    private boolean visible;
    private EditorCaret editorCaret;
    private EditorCaretListener weakEditorCaretListener;
    private ListenerList<HighlightsChangeListener> listenerList = new ListenerList();
    private AttributeSet coloringAttrs;
    private CharSequence docText;
    private List<CaretInfo> sortedCarets;

    public CaretOverwriteModeHighlighting(JTextComponent component) {
        this.component = component;
        component.putClientProperty(CaretOverwriteModeHighlighting.class, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVisible(boolean visible) {
        if (visible != this.visible) {
            this.visible = visible;
            if (this.editorCaret != null) {
                CaretOverwriteModeHighlighting caretOverwriteModeHighlighting;
                List<CaretInfo> sortedCaretsL;
                if (visible) {
                    sortedCaretsL = this.editorCaret.getSortedCarets();
                    caretOverwriteModeHighlighting = this;
                    synchronized (caretOverwriteModeHighlighting) {
                        this.sortedCarets = sortedCaretsL;
                    }
                }
                caretOverwriteModeHighlighting = this;
                synchronized (caretOverwriteModeHighlighting) {
                    sortedCaretsL = this.sortedCarets;
                    this.sortedCarets = null;
                }
                if (sortedCaretsL != null) {
                    int changeStartOffset = sortedCaretsL.get(0).getDot();
                    int changeEndOffset = sortedCaretsL.get(sortedCaretsL.size() - 1).getDot() + 1;
                    this.fireHighlightsChange(changeStartOffset, changeEndOffset);
                }
            }
        }
    }

    private void init() {
        this.component.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.component));
        this.updateActiveCaret();
        this.updateColoring();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HighlightsSequence getHighlights(int startOffset, int endOffset) {
        HighlightsSequence hs;
        List<CaretInfo> sortedCaretsL;
        boolean visibleL;
        if (!this.inited) {
            this.inited = true;
            this.init();
        }
        CaretOverwriteModeHighlighting caretOverwriteModeHighlighting = this;
        synchronized (caretOverwriteModeHighlighting) {
            visibleL = this.visible;
            sortedCaretsL = this.sortedCarets;
        }
        if (this.editorCaret != null && visibleL) {
            hs = new HS(sortedCaretsL, startOffset, endOffset);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("CaretOverwriteModeHighlighting.getHighlights() <" + startOffset + "," + endOffset + ">\n");
            }
        } else {
            hs = HighlightsSequence.EMPTY;
        }
        return hs;
    }

    @Override
    public void addHighlightsChangeListener(HighlightsChangeListener listener) {
        this.listenerList.add((EventListener)listener);
    }

    @Override
    public void removeHighlightsChangeListener(HighlightsChangeListener listener) {
        this.listenerList.remove((EventListener)listener);
    }

    private void fireHighlightsChange(HighlightsChangeEvent evt) {
        for (HighlightsChangeListener listener : this.listenerList.getListeners()) {
            listener.highlightChanged(evt);
        }
    }

    private void fireHighlightsChange(int startOffset, int endOffset) {
        this.fireHighlightsChange(new HighlightsChangeEvent(this, startOffset, endOffset));
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        String propName = evt.getPropertyName();
        if (propName == null || "caret".equals(propName)) {
            this.updateActiveCaret();
        } else if ("document".equals(propName)) {
            this.updateDocText();
        } else if ("caretColor".equals(propName) || "background".equals(propName)) {
            this.updateColoring();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void caretChanged(EditorCaretEvent evt) {
        if (this.visible) {
            this.fireHighlightsChange(evt.getAffectedStartOffset(), evt.getAffectedEndOffset());
            List<CaretInfo> sortedCaretsL = this.editorCaret.getSortedCarets();
            CaretOverwriteModeHighlighting caretOverwriteModeHighlighting = this;
            synchronized (caretOverwriteModeHighlighting) {
                this.sortedCarets = sortedCaretsL;
            }
        }
    }

    @Override
    public void released() {
        this.component.removePropertyChangeListener(this);
    }

    private void updateActiveCaret() {
        Caret caret;
        if (this.visible) {
            this.setVisible(false);
        }
        if (this.editorCaret != null) {
            this.editorCaret.removeEditorCaretListener(this.weakEditorCaretListener);
            this.weakEditorCaretListener = null;
            this.editorCaret = null;
            this.docText = null;
        }
        if ((caret = this.component.getCaret()) instanceof EditorCaret) {
            this.editorCaret = (EditorCaret)caret;
        }
        if (this.editorCaret != null) {
            this.updateDocText();
            this.weakEditorCaretListener = (EditorCaretListener)WeakListeners.create(EditorCaretListener.class, (EventListener)this, (Object)this.editorCaret);
            this.editorCaret.addEditorCaretListener(this.weakEditorCaretListener);
        }
    }

    private void updateColoring() {
        this.coloringAttrs = AttributesUtilities.createImmutable((Object[])new Object[]{StyleConstants.Background, this.component.getCaretColor(), StyleConstants.Foreground, this.component.getBackground()});
    }

    private void updateDocText() {
        Document doc;
        JTextComponent c = this.component;
        CharSequence text = null;
        if (c != null && (doc = c.getDocument()) != null) {
            text = DocumentUtilities.getText((Document)doc);
        }
        this.docText = text;
    }

    private final class HS
    implements SplitOffsetHighlightsSequence {
        private final List<CaretInfo> sortedCarets;
        private final int startOffset;
        private final int endOffset;
        private int caretOffset = -1;
        private int caretSplitOffset;
        private int caretIndex;

        HS(List<CaretInfo> sortedCarets, int startOffset, int endOffset) {
            this.sortedCarets = sortedCarets;
            this.startOffset = startOffset;
            this.endOffset = endOffset;
        }

        @Override
        public boolean moveNext() {
            CaretInfo caret;
            boolean ret = false;
            if (this.caretOffset == -1) {
                while (this.caretOffset < this.startOffset && this.caretIndex < this.sortedCarets.size()) {
                    caret = this.sortedCarets.get(this.caretIndex++);
                    this.caretOffset = caret.getDot();
                }
                if (this.caretOffset != -1) {
                    ret = true;
                }
            } else {
                while (this.caretIndex < this.sortedCarets.size()) {
                    int offset;
                    if ((offset = (caret = this.sortedCarets.get(this.caretIndex++)).getDot()) > this.caretOffset) {
                        this.caretOffset = offset;
                        this.checkLogHighlight();
                        return true;
                    }
                    if (offset < this.endOffset) continue;
                    return false;
                }
            }
            if (ret) {
                char ch;
                this.caretSplitOffset = 0;
                CharSequence text = CaretOverwriteModeHighlighting.this.docText;
                if (text != null && ((ch = text.charAt(this.caretOffset)) == '\t' || ch == '\n')) {
                    this.caretSplitOffset = 1;
                }
                this.checkLogHighlight();
                return true;
            }
            return false;
        }

        private void checkLogHighlight() {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine("  CaretOverwriteModeHighlighting.Highlight <" + this.getStartOffset() + "_" + this.getStartSplitOffset() + "," + this.getEndOffset() + "_" + this.getEndSplitOffset() + ">\n");
            }
        }

        @Override
        public int getStartOffset() {
            return this.caretOffset;
        }

        @Override
        public int getStartSplitOffset() {
            return 0;
        }

        @Override
        public int getEndOffset() {
            return this.caretSplitOffset == 0 ? this.caretOffset + 1 : this.caretOffset;
        }

        @Override
        public int getEndSplitOffset() {
            return this.caretSplitOffset;
        }

        @Override
        public AttributeSet getAttributes() {
            return CaretOverwriteModeHighlighting.this.coloringAttrs;
        }
    }
}

