/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.payara.tooling.utils;

import org.netbeans.modules.payara.tooling.logging.Logger;

public class CyclicStringBuffer {
    private static final Logger LOGGER = new Logger(CyclicStringBuffer.class);
    private int size;
    private char[] buff;
    private int len;
    private int beg;

    public CyclicStringBuffer(int size) {
        this.size = size;
        this.buff = new char[size];
        this.len = 0;
        this.beg = 0;
    }

    public void resize(int size) {
        if (this.size != size) {
            this.size = size;
            this.buff = new char[size];
        }
        this.len = 0;
        this.beg = 0;
    }

    public boolean append(char c) {
        this.buff[(this.beg + this.len) % this.size] = c;
        if (this.len == this.size) {
            this.beg = (this.beg + 1) % this.size;
            return true;
        }
        ++this.len;
        return false;
    }

    public boolean prepend(char c) {
        this.beg = (this.beg + this.size - 1) % this.size;
        this.buff[this.beg] = c;
        if (this.len == this.size) {
            return true;
        }
        ++this.len;
        return false;
    }

    public boolean equals(String s) {
        if (s == null) {
            return this.len == 0;
        }
        if (this.len != s.length()) {
            return false;
        }
        boolean result = true;
        for (int i = 0; i < this.len; ++i) {
            if (this.buff[(this.beg + i) % this.size] == s.charAt(i)) continue;
            result = false;
        }
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.len);
        for (int i = 0; i < this.len; ++i) {
            sb.append(this.buff[(this.beg + i) % this.size]);
        }
        return sb.toString();
    }
}

