/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.dbgp.breakpoints;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.modules.php.api.util.StringUtils;
import org.netbeans.modules.php.dbgp.DebugSession;
import org.netbeans.modules.php.dbgp.breakpoints.AbstractBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.ExceptionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.LineBreakpoint;
import org.netbeans.modules.php.dbgp.breakpoints.Utils;
import org.netbeans.modules.php.dbgp.models.ViewModelSupport;
import org.netbeans.modules.php.dbgp.packets.Stack;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.NodeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class BreakpointModel
extends ViewModelSupport
implements NodeModel {
    public static final String BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint";
    public static final String LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint";
    public static final String CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpointHit";
    public static final String CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/BreakpointHit";
    public static final String DISABLED_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpoint";
    public static final String DISABLED_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpoint";
    public static final String DISABLED_CURRENT_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledNonLineBreakpointHit";
    public static final String DISABLED_CURRENT_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledBreakpointHit";
    public static final String LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpoint";
    public static final String CURRENT_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/ConditionalBreakpointHit";
    public static final String DISABLED_LINE_CONDITIONAL_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/DisabledConditionalBreakpoint";
    public static final String BROKEN_LINE_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/Breakpoint_broken";
    public static final String BROKEN_BREAKPOINT = "org/netbeans/modules/debugger/resources/breakpointsView/NonLineBreakpoint_broken";
    private static final String METHOD = "TXT_Method";
    private static final String EXCEPTION = "TXT_Exception";
    private static final String PARENS = "()";
    private static final String MESSAGE = "Message: ";
    private static final String CODE = "Code: ";
    private static final String FONT_COLOR = "<font color=\"#7D694A\">";
    private static final String CLOSE_FONT = "</font>";
    private static final String OPEN_HTML = "<html>";
    private static final String CLOSE_HTML = "</html>";
    private final Map<DebugSession, AbstractBreakpoint> myCurrentBreakpoints = new WeakHashMap<DebugSession, AbstractBreakpoint>();
    private volatile boolean searchCurrentBreakpointById = false;

    @Override
    public void clearModel() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getDisplayName(Object node) throws UnknownTypeException {
        if (node instanceof LineBreakpoint) {
            LineBreakpoint breakpoint = (LineBreakpoint)((Object)node);
            FileObject fileObject = (FileObject)breakpoint.getLine().getLookup().lookup(FileObject.class);
            return fileObject.getNameExt() + ":" + (breakpoint.getLine().getLineNumber() + 1);
        }
        if (node instanceof FunctionBreakpoint) {
            FunctionBreakpoint breakpoint = (FunctionBreakpoint)((Object)node);
            StringBuilder builder = new StringBuilder(NbBundle.getMessage(BreakpointModel.class, (String)METHOD));
            builder.append(" ");
            builder.append(breakpoint.getFunction());
            builder.append(PARENS);
            return builder.toString();
        }
        if (node instanceof ExceptionBreakpoint) {
            ExceptionBreakpoint breakpoint = (ExceptionBreakpoint)((Object)node);
            StringBuilder builder = new StringBuilder().append(OPEN_HTML).append(NbBundle.getMessage(BreakpointModel.class, (String)EXCEPTION)).append(" ").append(breakpoint.getException());
            String message = breakpoint.getExceptionMessage();
            String code = breakpoint.getExceptionCode();
            Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
            synchronized (map) {
                for (AbstractBreakpoint brkp : this.myCurrentBreakpoints.values()) {
                    if (!((Object)((Object)breakpoint)).equals((Object)brkp)) continue;
                    this.buildAppend(builder, MESSAGE, message);
                    this.buildAppend(builder, CODE, code);
                }
            }
            builder.append(CLOSE_HTML);
            return builder.toString();
        }
        throw new UnknownTypeException(node);
    }

    private void buildAppend(StringBuilder builder, String prepend, @NullAllowed String text) {
        if (!StringUtils.isEmpty((String)text)) {
            builder.append(" ").append(FONT_COLOR).append(prepend).append(text).append(CLOSE_FONT);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIconBase(Object node) throws UnknownTypeException {
        AbstractBreakpoint breakpoint;
        Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
        synchronized (map) {
            for (AbstractBreakpoint breakpoint2 : this.myCurrentBreakpoints.values()) {
                if (!node.equals((Object)breakpoint2)) continue;
                return this.getCurrentBreakpointIconBase(breakpoint2);
            }
        }
        if (node instanceof LineBreakpoint) {
            breakpoint = (LineBreakpoint)((Object)node);
            if (!breakpoint.isEnabled()) {
                return DISABLED_LINE_BREAKPOINT;
            }
            if (Utils.isValid(breakpoint)) {
                return LINE_BREAKPOINT;
            }
            return BROKEN_LINE_BREAKPOINT;
        }
        if (node instanceof AbstractBreakpoint) {
            breakpoint = (AbstractBreakpoint)((Object)node);
            if (!breakpoint.isEnabled()) {
                return DISABLED_BREAKPOINT;
            }
            if (Utils.isValid(breakpoint)) {
                return BREAKPOINT;
            }
            return BROKEN_BREAKPOINT;
        }
        throw new UnknownTypeException(node);
    }

    public String getShortDescription(Object node) throws UnknownTypeException {
        if (node instanceof LineBreakpoint) {
            return ((LineBreakpoint)((Object)node)).getLine().getDisplayName();
        }
        throw new UnknownTypeException(node);
    }

    public void setCurrentStack(Stack stack, DebugSession session) {
        if (stack == null) {
            this.removeCurrentBreakpoint(session);
            return;
        }
        String currentCommand = stack.getCurrentCommandName();
        if (!this.foundLineBreakpoint(stack.getFileName().replace("file:///", "file:/"), stack.getLine() - 1, session) && !this.foundFunctionBreakpoint(currentCommand, session)) {
            this.removeCurrentBreakpoint(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCurrentBreakpoint(DebugSession session) {
        Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
        synchronized (map) {
            AbstractBreakpoint breakpoint = this.myCurrentBreakpoints.remove(session);
            this.fireChangeEvent((ModelEvent)new ModelEvent.NodeChanged((Object)this, (Object)breakpoint));
        }
    }

    private String getCurrentBreakpointIconBase(AbstractBreakpoint breakpoint) {
        if (breakpoint instanceof LineBreakpoint) {
            return CURRENT_LINE_BREAKPOINT;
        }
        return CURRENT_BREAKPOINT;
    }

    private boolean foundFunctionBreakpoint(String currentCommand, DebugSession session) {
        return this.foundBreakpoint(session, new FunctionBreakpointAcceptor(currentCommand));
    }

    private boolean foundLineBreakpoint(String fileName, int line, DebugSession session) {
        return this.foundBreakpoint(session, new LineBreakpointAcceptor(fileName, line));
    }

    private boolean foundBreakpoint(DebugSession session, Acceptor acceptor) {
        Breakpoint[] breakpoints;
        for (Breakpoint breakpoint : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!(breakpoint instanceof AbstractBreakpoint) || !((AbstractBreakpoint)breakpoint).isSessionRelated(session) || !acceptor.accept(breakpoint)) continue;
            this.updateCurrentBreakpoint(session, breakpoint);
            return true;
        }
        return false;
    }

    public void setCurrentBreakpoint(DebugSession session, String id) {
        Breakpoint[] breakpoints;
        for (Breakpoint breakpoint : breakpoints = DebuggerManager.getDebuggerManager().getBreakpoints()) {
            if (!this.canSetCurrentBreakPoint(session, breakpoint, id)) continue;
            this.updateCurrentBreakpoint(session, breakpoint);
            break;
        }
    }

    private boolean canSetCurrentBreakPoint(DebugSession session, Breakpoint breakpoint, String id) {
        AbstractBreakpoint abstractBreakpoint;
        return Utils.isValid(breakpoint) && breakpoint instanceof AbstractBreakpoint && (abstractBreakpoint = (AbstractBreakpoint)breakpoint).isSessionRelated(session) && abstractBreakpoint.isEnabled() && abstractBreakpoint.getBreakpointId().equals(id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateCurrentBreakpoint(DebugSession session, Breakpoint breakpoint) {
        AbstractBreakpoint abpnt = (AbstractBreakpoint)breakpoint;
        Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
        synchronized (map) {
            AbstractBreakpoint bpnt = this.myCurrentBreakpoints.get(session);
            this.myCurrentBreakpoints.put(session, abpnt);
            this.fireChangeEvents(new ModelEvent[]{new ModelEvent.NodeChanged((Object)this, (Object)bpnt), new ModelEvent.NodeChanged((Object)this, (Object)abpnt)});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractBreakpoint getCurrentBreakpoint(DebugSession session) {
        Map<DebugSession, AbstractBreakpoint> map = this.myCurrentBreakpoints;
        synchronized (map) {
            return this.myCurrentBreakpoints.get(session);
        }
    }

    public void setSearchCurrentBreakpointById(boolean flag) {
        this.searchCurrentBreakpointById = flag;
    }

    public boolean isSearchCurrentBreakpointById() {
        return this.searchCurrentBreakpointById;
    }

    private static class FunctionBreakpointAcceptor
    implements Acceptor {
        private String myFunction;

        FunctionBreakpointAcceptor(String function) {
            this.myFunction = function;
        }

        @Override
        public boolean accept(Breakpoint breakpoint) {
            if (!(breakpoint instanceof FunctionBreakpoint)) {
                return false;
            }
            String function = ((FunctionBreakpoint)breakpoint).getFunction();
            return function == null ? false : function.equals(this.myFunction);
        }
    }

    private static interface Acceptor {
        public boolean accept(Breakpoint var1);
    }

    private static class LineBreakpointAcceptor
    implements Acceptor {
        private int myLine;
        private String myCurrentFilePath;

        LineBreakpointAcceptor(String currentFilePath, int lineNumber) {
            this.myCurrentFilePath = currentFilePath;
            this.myLine = lineNumber;
        }

        @Override
        public boolean accept(Breakpoint breakpoint) {
            if (!(breakpoint instanceof LineBreakpoint)) {
                return false;
            }
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpoint;
            return this.myLine == lineBreakpoint.getLine().getLineNumber() && this.myCurrentFilePath.equals(lineBreakpoint.getFileUrl());
        }
    }
}

