/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.terminal.iocontainer;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.util.List;
import javax.swing.Action;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JToolBar;
import org.netbeans.lib.terminalemulator.support.FindBar;
import org.netbeans.lib.terminalemulator.support.FindState;
import org.netbeans.modules.terminal.api.ui.IOVisibilityControl;
import org.netbeans.modules.terminal.api.ui.TerminalContainer;
import org.netbeans.modules.terminal.ioprovider.Terminal;
import org.openide.windows.IOContainer;
import org.openide.windows.TopComponent;

abstract class TerminalContainerCommon
extends TerminalContainer
implements IOContainer.Provider {
    private static final String PROP_ATTRIBUTES = "TerminalContainerCommonImpl.ATTRIBUTES";
    protected final TopComponent owner;
    protected final String originalName;
    private IOContainer ioContainer;
    private boolean activated = false;
    private JToolBar actionBar;
    private FindBar findBar;
    private JComponent lastSelection;

    public TerminalContainerCommon(TopComponent owner, String originalName) {
        this.owner = owner;
        this.originalName = originalName;
    }

    protected final TopComponent topComponent() {
        return this.owner;
    }

    protected final Attributes attributesFor(JComponent comp) {
        Object o = comp.getClientProperty(PROP_ATTRIBUTES);
        if (o == null) {
            Attributes a = new Attributes();
            comp.putClientProperty(PROP_ATTRIBUTES, a);
            return a;
        }
        return (Attributes)o;
    }

    @Override
    public IOContainer ioContainer() {
        if (this.ioContainer == null) {
            this.ioContainer = IOContainer.create((IOContainer.Provider)this);
        }
        return this.ioContainer;
    }

    @Override
    public final void componentActivated() {
        IOContainer.CallBacks cb;
        this.activated = true;
        JComponent comp = this.getSelected();
        if (comp != null && (cb = this.attributesFor((JComponent)comp).cb) != null) {
            cb.activated();
        }
    }

    @Override
    public final void componentDeactivated() {
        IOContainer.CallBacks cb;
        this.activated = false;
        JComponent comp = this.getSelected();
        if (comp != null && (cb = this.attributesFor((JComponent)comp).cb) != null) {
            cb.deactivated();
        }
    }

    public final void open() {
        if (this.owner != null) {
            this.owner.open();
        }
    }

    public final void requestActive() {
        if (this.owner != null) {
            this.owner.requestActive();
        }
    }

    public final void requestVisible() {
        if (this.owner != null) {
            this.owner.requestVisible();
        }
    }

    public final boolean isActivated() {
        return this.activated;
    }

    public final void add(JComponent comp, IOContainer.CallBacks cb) {
        this.addTab(comp, cb);
    }

    public final void remove(JComponent comp) {
        this.removeTab(comp);
    }

    public final void select(JComponent comp) {
        this.selectLite(comp);
    }

    public void setToolbarActions(JComponent comp, Action[] toolbarActions) {
        Attributes attrs = this.attributesFor(comp);
        attrs.toolbarActions = toolbarActions;
        if (this.getSelected() == comp) {
            this.setButtons(toolbarActions);
        }
    }

    public void setTitle(JComponent comp, String title) {
        Attributes attrs = this.attributesFor(comp);
        attrs.title = title;
        comp.setName(title);
        if (!this.contains(comp)) {
            return;
        }
        this.setTitleWork(comp, title);
    }

    public void setToolTipText(JComponent comp, String text) {
        Attributes attrs = this.attributesFor(comp);
        attrs.toolTipText = text;
        this.restoreAttrsFor(comp);
    }

    public void setIcon(JComponent comp, Icon icon) {
        Attributes attrs = this.attributesFor(comp);
        attrs.icon = icon;
        this.restoreAttrsFor(comp);
    }

    public final boolean isCloseable(JComponent comp) {
        IOContainer.CallBacks cb = this.attributesFor((JComponent)comp).cb;
        if (cb != null && IOVisibilityControl.isSupported(cb)) {
            return IOVisibilityControl.isClosable(cb);
        }
        return true;
    }

    @Override
    public void requestFocus() {
        JComponent selected = this.getSelected();
        if (selected != null) {
            selected.requestFocus();
        } else {
            super.requestFocus();
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        JComponent selected = this.getSelected();
        if (selected != null) {
            return selected.requestFocusInWindow();
        }
        return super.requestFocusInWindow();
    }

    protected abstract void addTabWork(JComponent var1);

    protected abstract void removeTabWork(JComponent var1);

    protected abstract void setTitleWork(JComponent var1, String var2);

    protected abstract boolean contains(JComponent var1);

    protected abstract void restoreAttrsFor(JComponent var1);

    protected abstract void selectLite(JComponent var1);

    public abstract JComponent getSelected();

    @Override
    public abstract List<? extends Component> getAllTabs();

    protected final void addTab(JComponent comp, IOContainer.CallBacks cb) {
        Attributes attr = this.attributesFor(comp);
        attr.cb = cb;
        this.addTabWork(comp);
    }

    protected final void removeTab(JComponent comp) {
        if (comp == null) {
            return;
        }
        IOContainer.CallBacks cb = this.attributesFor((JComponent)comp).cb;
        if (cb != null && IOVisibilityControl.isSupported(cb)) {
            if (IOVisibilityControl.isClosable(cb)) {
                if (!IOVisibilityControl.okToClose(cb)) {
                    return;
                }
            } else {
                assert (false);
                return;
            }
        }
        this.removeTabWork(comp);
        if (cb != null) {
            cb.closed();
        }
    }

    protected void initComponents() {
        this.setLayout(new BorderLayout());
        this.actionBar = new JToolBar();
        this.actionBar.setOrientation(1);
        this.actionBar.setLayout(new BoxLayout(this.actionBar, 1));
        this.actionBar.setFloatable(false);
        this.fixSize(this.actionBar);
        this.add((Component)this.actionBar, "West");
        this.actionBar.setVisible(false);
        this.findBar = new FindBar(new FindBar.Owner(){

            public void close(FindBar fb) {
                TerminalContainerCommon.this.findBar.getState().setVisible(false);
                TerminalContainerCommon.this.componentRemove((JComponent)TerminalContainerCommon.this.findBar);
                TerminalContainerCommon.this.validate();
                TerminalContainerCommon.this.requestFocus();
            }
        });
    }

    protected final void componentRemove(JComponent comp) {
        super.remove(comp);
    }

    protected final void updateWindowName(String title) {
        if (this.owner == null) {
            return;
        }
        if (title == null || title.trim().isEmpty()) {
            this.owner.setDisplayName(this.originalName);
            this.owner.setToolTipText(this.originalName);
            this.owner.setHtmlDisplayName(null);
        } else {
            String composite = this.originalName + " - ";
            if (title.contains("<html>")) {
                title = title.replace("<html>", "");
                composite = "<html> " + composite + title;
                this.owner.setHtmlDisplayName(composite);
            } else {
                this.owner.setDisplayName(composite);
                this.owner.setHtmlDisplayName(null);
            }
            this.owner.setToolTipText(composite);
        }
    }

    protected final void checkSelectionChange() {
        JComponent selection = this.getSelected();
        if (selection != this.lastSelection) {
            IOContainer.CallBacks cb;
            this.lastSelection = selection;
            this.updateBars(selection);
            if (selection != null && (cb = this.attributesFor((JComponent)selection).cb) != null) {
                cb.selected();
            }
        }
    }

    private void setFindBar(FindState findState) {
        this.findBar.setState(findState);
        if (findState != null && findState.isVisible()) {
            this.add((Component)this.findBar, "South");
        } else {
            this.componentRemove((JComponent)this.findBar);
        }
        this.validate();
    }

    private void fixSize(JToolBar actionBar) {
        Insets ins = actionBar.getMargin();
        JButton dummy = new JButton();
        dummy.setBorderPainted(false);
        dummy.setOpaque(false);
        dummy.setText(null);
        dummy.setIcon(new Icon(){

            @Override
            public int getIconHeight() {
                return 16;
            }

            @Override
            public int getIconWidth() {
                return 16;
            }

            @Override
            public void paintIcon(Component c, Graphics g, int x, int y) {
            }
        });
        actionBar.add(dummy);
        Dimension buttonPref = dummy.getPreferredSize();
        Dimension minDim = new Dimension(buttonPref.width + ins.left + ins.right, buttonPref.height + ins.top + ins.bottom);
        actionBar.setMinimumSize(minDim);
        actionBar.setPreferredSize(minDim);
        actionBar.remove(dummy);
    }

    private JButton adjustButton(JButton b) {
        b.setBorderPainted(false);
        b.setOpaque(false);
        b.setText(null);
        b.putClientProperty("hideActionText", Boolean.TRUE);
        return b;
    }

    private void setButtons(Action[] actions) {
        if (actions == null) {
            actions = new Action[]{};
        }
        JButton[] buttons = new JButton[actions.length];
        for (int ax = 0; ax < actions.length; ++ax) {
            Action a = actions[ax];
            JButton b = new JButton(a);
            buttons[ax] = this.adjustButton(b);
        }
        this.actionBar.removeAll();
        if (buttons.length != 0) {
            this.actionBar.setVisible(true);
            for (JButton b : buttons) {
                this.actionBar.add(b);
            }
        } else {
            this.actionBar.setVisible(false);
        }
        this.actionBar.revalidate();
        this.actionBar.repaint();
    }

    @Override
    public void activateSearch(JComponent comp) {
        Attributes attrs = this.attributesFor(comp);
        attrs.findState = ((Terminal)comp).getFindState();
        this.setFindBar(attrs.findState);
        this.findBar.requestTextFocus();
    }

    private void updateBars(JComponent comp) {
        if (comp != null) {
            Attributes attrs = this.attributesFor(comp);
            this.setButtons(attrs.toolbarActions);
            this.setFindBar(attrs.findState);
        } else {
            this.setButtons(null);
            this.setFindBar(null);
        }
    }

    protected static final class Attributes {
        public IOContainer.CallBacks cb;
        public String title;
        public Action[] toolbarActions;
        public String toolTipText;
        public Icon icon;
        public FindState findState;

        protected Attributes() {
        }
    }
}

