/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.identity.requests;

import com.oracle.bmc.http.client.RequestInterceptor;
import com.oracle.bmc.requests.BmcRequest;
import com.oracle.bmc.retrier.RetryConfiguration;
import java.util.Objects;

public class DeleteOAuthClientCredentialRequest
extends BmcRequest<Void> {
    private String userId;
    private String oauth2ClientCredentialId;
    private String ifMatch;

    public String getUserId() {
        return this.userId;
    }

    public String getOauth2ClientCredentialId() {
        return this.oauth2ClientCredentialId;
    }

    public String getIfMatch() {
        return this.ifMatch;
    }

    public Builder toBuilder() {
        return new Builder().userId(this.userId).oauth2ClientCredentialId(this.oauth2ClientCredentialId).ifMatch(this.ifMatch);
    }

    public static Builder builder() {
        return new Builder();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        sb.append("super=").append(super.toString());
        sb.append(",userId=").append(String.valueOf(this.userId));
        sb.append(",oauth2ClientCredentialId=").append(String.valueOf(this.oauth2ClientCredentialId));
        sb.append(",ifMatch=").append(String.valueOf(this.ifMatch));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DeleteOAuthClientCredentialRequest)) {
            return false;
        }
        DeleteOAuthClientCredentialRequest other = (DeleteOAuthClientCredentialRequest)((Object)o);
        return super.equals(o) && Objects.equals(this.userId, other.userId) && Objects.equals(this.oauth2ClientCredentialId, other.oauth2ClientCredentialId) && Objects.equals(this.ifMatch, other.ifMatch);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.userId == null ? 43 : this.userId.hashCode());
        result = result * 59 + (this.oauth2ClientCredentialId == null ? 43 : this.oauth2ClientCredentialId.hashCode());
        result = result * 59 + (this.ifMatch == null ? 43 : this.ifMatch.hashCode());
        return result;
    }

    public static class Builder
    implements BmcRequest.Builder<DeleteOAuthClientCredentialRequest, Void> {
        private RequestInterceptor invocationCallback = null;
        private RetryConfiguration retryConfiguration = null;
        private String userId = null;
        private String oauth2ClientCredentialId = null;
        private String ifMatch = null;

        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        public Builder oauth2ClientCredentialId(String oauth2ClientCredentialId) {
            this.oauth2ClientCredentialId = oauth2ClientCredentialId;
            return this;
        }

        public Builder ifMatch(String ifMatch) {
            this.ifMatch = ifMatch;
            return this;
        }

        public Builder invocationCallback(RequestInterceptor invocationCallback) {
            this.invocationCallback = invocationCallback;
            return this;
        }

        public Builder retryConfiguration(RetryConfiguration retryConfiguration) {
            this.retryConfiguration = retryConfiguration;
            return this;
        }

        public Builder copy(DeleteOAuthClientCredentialRequest o) {
            this.userId(o.getUserId());
            this.oauth2ClientCredentialId(o.getOauth2ClientCredentialId());
            this.ifMatch(o.getIfMatch());
            this.invocationCallback(o.getInvocationCallback());
            this.retryConfiguration(o.getRetryConfiguration());
            return this;
        }

        public DeleteOAuthClientCredentialRequest build() {
            DeleteOAuthClientCredentialRequest request = this.buildWithoutInvocationCallback();
            request.setInvocationCallback(this.invocationCallback);
            request.setRetryConfiguration(this.retryConfiguration);
            return request;
        }

        public DeleteOAuthClientCredentialRequest buildWithoutInvocationCallback() {
            DeleteOAuthClientCredentialRequest request = new DeleteOAuthClientCredentialRequest();
            request.userId = this.userId;
            request.oauth2ClientCredentialId = this.oauth2ClientCredentialId;
            request.ifMatch = this.ifMatch;
            return request;
        }
    }
}

