/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.ZonedDateTime;
import java.util.Calendar;
import java.util.TimeZone;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.internal.OracleTimestamp;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.TIMESTAMPTZ;

public class TIMESTAMP
extends Datum
implements Serializable,
OracleTimestamp {
    static final int CENTURY_DEFAULT = 119;
    static final int DECADE_DEFAULT = 100;
    static final int MONTH_DEFAULT = 1;
    static final int DAY_DEFAULT = 1;
    static final int DECADE_INIT = 170;
    static final int JAVA_YEAR = 1970;
    static final int JAVA_MONTH = 0;
    static final int JAVA_DATE = 1;
    public static final int SIZE_DATE = 7;
    public static final int SIZE_TIMESTAMP = 11;
    public static final int SIZE_TIMESTAMP_NOFRAC = 7;
    static final int SIZE_TIMESTAMPTZ = 13;
    static final int MINYEAR = -4712;
    static final int MAXYEAR = 9999;
    static final int JANMONTH = 1;
    static final int DECMONTH = 12;
    static final int MINDAYS = 1;
    static final int MAXDAYS = 31;
    static final int MINHOURS = 1;
    static final int MAXHOURS = 24;
    static final int MINMINUTES = 1;
    static final int MAXMINUTES = 60;
    static final int MINSECONDS = 1;
    static final int MAXSECONDS = 60;
    static final int[] daysInMonth = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
    static final long serialVersionUID = -7964732752952728545L;

    public TIMESTAMP() {
        super(TIMESTAMP.initTimestamp());
    }

    public TIMESTAMP(byte[] timestamp) {
        super(timestamp);
    }

    public TIMESTAMP(Time time) {
        super(TIMESTAMP.toBytes(time));
    }

    public TIMESTAMP(Date date) {
        super(TIMESTAMP.toBytes(date));
    }

    public TIMESTAMP(Timestamp timestamp) {
        super(TIMESTAMP.toBytes(timestamp));
    }

    public TIMESTAMP(Timestamp timestamp, Calendar cal) {
        super(TIMESTAMP.toBytes(timestamp, cal));
    }

    public TIMESTAMP(DATE date) {
        super(TIMESTAMP.toBytes(date));
    }

    public static final int getNanos(byte[] buffer, int off) {
        int nanos = (buffer[off] & 0xFF) << 24;
        nanos |= (buffer[off + 1] & 0xFF) << 16;
        nanos |= (buffer[off + 2] & 0xFF) << 8;
        return nanos |= buffer[off + 3] & 0xFF & 0xFF;
    }

    public TIMESTAMP(String str) {
        super(TIMESTAMP.toBytes(str));
    }

    public TIMESTAMP(OffsetDateTime odt) {
        super(TIMESTAMP.toBytes(odt));
    }

    public TIMESTAMP(ZonedDateTime zdt) {
        super(TIMESTAMP.toBytes(zdt));
    }

    public TIMESTAMP(LocalDateTime ldt) {
        super(TIMESTAMP.toBytes(ldt));
    }

    public TIMESTAMP(LocalTime lt) {
        super(TIMESTAMP.toBytes(lt));
    }

    public TIMESTAMP(LocalDate ld) {
        super(TIMESTAMP.toBytes(ld));
    }

    public TIMESTAMP(OffsetTime ot) {
        super(TIMESTAMP.toBytes(ot));
    }

    public static Date toDate(byte[] timestamp) throws SQLException {
        int arrlength = timestamp.length;
        int[] result = arrlength == 11 ? new int[11] : new int[7];
        for (int i = 0; i < timestamp.length; ++i) {
            result[i] = timestamp[i] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, result[2] - 1);
        cal.set(5, result[3]);
        cal.set(11, result[4] - 1);
        cal.set(12, result[5] - 1);
        cal.set(13, result[6] - 1);
        int tsmillis = 0;
        if (arrlength == 11) {
            tsmillis = TIMESTAMP.getNanos(timestamp, 7) / 1000000;
        }
        cal.set(14, tsmillis);
        long millis = cal.getTimeInMillis();
        return new Date(millis);
    }

    public static Time toTime(byte[] timestamp) throws SQLException {
        int hour = timestamp[4] & 0xFF;
        int minute = timestamp[5] & 0xFF;
        int second = timestamp[6] & 0xFF;
        Calendar cal = Calendar.getInstance();
        cal.set(1, 1970);
        cal.set(2, 0);
        cal.set(5, 1);
        cal.set(11, hour - 1);
        cal.set(12, minute - 1);
        cal.set(13, second - 1);
        cal.set(14, 0);
        return new Time(cal.getTime().getTime());
    }

    public static Timestamp toTimestamp(byte[] timestamp) throws SQLException {
        return TIMESTAMP.toTimestamp(timestamp, null);
    }

    public static Timestamp toTimestamp(byte[] timestamp, Calendar cal) throws SQLException {
        int arrlength = timestamp.length;
        if (arrlength == 0) {
            return null;
        }
        int[] result = arrlength == 11 ? new int[11] : new int[7];
        for (int i = 0; i < timestamp.length; ++i) {
            result[i] = timestamp[i] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.clear();
        cal1.set(1, year);
        cal1.set(2, result[2] - 1);
        cal1.set(5, result[3]);
        cal1.set(11, result[4] - 1);
        cal1.set(12, result[5] - 1);
        cal1.set(13, result[6] - 1);
        cal1.set(14, 0);
        long millis = cal1.getTime().getTime();
        Timestamp ts = new Timestamp(millis);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp, 7);
        }
        ts.setNanos(nanos);
        return ts;
    }

    public static DATE toDATE(byte[] timestamp) throws SQLException {
        byte[] date = new byte[7];
        System.arraycopy(timestamp, 0, date, 0, 7);
        return new DATE(date);
    }

    @Override
    public Timestamp timestampValue() throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes());
    }

    @Override
    public Timestamp timestampValue(Calendar cal) throws SQLException {
        return TIMESTAMP.toTimestamp(this.getBytes(), cal);
    }

    public static String toString(byte[] bytes) {
        if (bytes.length == 0) {
            return null;
        }
        int[] result = new int[bytes.length];
        for (int i = 0; i < bytes.length; ++i) {
            result[i] = bytes[i] < 0 ? bytes[i] + 256 : bytes[i];
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        int month = result[2];
        int day = result[3];
        int hours = result[4] - 1;
        int minutes = result[5] - 1;
        int seconds = result[6] - 1;
        int nanos = 0;
        if (bytes.length > 7) {
            nanos = TIMESTAMP.getNanos(bytes, 7);
        }
        return TIMESTAMPTZ.toString(year, month, day, hours, minutes, seconds, nanos, null);
    }

    @Override
    public byte[] toBytes() {
        return this.getBytes();
    }

    public static byte[] toBytes(Time time) {
        if (time == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(time);
        int nanos = cal.get(14) * 1000000;
        byte[] result = new byte[nanos > 0 ? 11 : 7];
        result[0] = 119;
        result[1] = -86;
        result[2] = 1;
        result[3] = 1;
        result[4] = (byte)(cal.get(11) + 1);
        result[5] = (byte)(cal.get(12) + 1);
        result[6] = (byte)(cal.get(13) + 1);
        if (nanos > 0) {
            result[7] = (byte)(nanos >> 24);
            result[8] = (byte)(nanos >> 16 & 0xFF);
            result[9] = (byte)(nanos >> 8 & 0xFF);
            result[10] = (byte)(nanos & 0xFF);
        }
        return result;
    }

    public static byte[] toBytes(Date date) {
        if (date == null) {
            return null;
        }
        byte[] result = new byte[7];
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        int year = TIMESTAMP.getOracleYear(cal);
        result[0] = (byte)(year / 100 + 100);
        result[1] = (byte)(year % 100 + 100);
        result[2] = (byte)(cal.get(2) + 1);
        result[3] = (byte)cal.get(5);
        if (!OracleDriver.getSystemPropertyDateZeroTime()) {
            result[4] = (byte)(cal.get(11) + 1);
            result[5] = (byte)(cal.get(12) + 1);
            result[6] = (byte)(cal.get(13) + 1);
        } else {
            result[4] = 1;
            result[5] = 1;
            result[6] = 1;
        }
        return result;
    }

    public static byte[] toBytes(Timestamp timestamp) {
        return TIMESTAMP.toBytes(timestamp, null);
    }

    public static byte[] toBytes(Timestamp timestamp, Calendar cal) {
        if (timestamp == null) {
            return null;
        }
        int nanos = timestamp.getNanos();
        byte[] result = nanos == 0 ? new byte[7] : new byte[11];
        Calendar cal1 = cal == null ? Calendar.getInstance() : Calendar.getInstance(cal.getTimeZone());
        cal1.setTime(timestamp);
        int year = TIMESTAMP.getOracleYear(cal1);
        result[0] = (byte)(year / 100 + 100);
        result[1] = (byte)(year % 100 + 100);
        result[2] = (byte)(cal1.get(2) + 1);
        result[3] = (byte)cal1.get(5);
        result[4] = (byte)(cal1.get(11) + 1);
        result[5] = (byte)(cal1.get(12) + 1);
        result[6] = (byte)(cal1.get(13) + 1);
        if (nanos != 0) {
            result[7] = (byte)(nanos >> 24);
            result[8] = (byte)(nanos >> 16 & 0xFF);
            result[9] = (byte)(nanos >> 8 & 0xFF);
            result[10] = (byte)(nanos & 0xFF);
        }
        return result;
    }

    public static byte[] toBytes(DATE date) {
        if (date == null) {
            return null;
        }
        byte[] result = new byte[7];
        System.arraycopy(date.getBytes(), 0, result, 0, 7);
        return result;
    }

    public static byte[] toBytes(String str) {
        return TIMESTAMP.toBytes(Timestamp.valueOf(str));
    }

    @Override
    public Object toJdbc() throws SQLException {
        return this.timestampValue();
    }

    @Override
    public Object makeJdbcArray(int arraySize) {
        Timestamp[] ts = new Timestamp[arraySize];
        return ts;
    }

    @Override
    public boolean isConvertibleTo(Class<?> cls) {
        return cls == Date.class || cls == Time.class || cls == Timestamp.class || cls == LocalDateTime.class || cls == LocalDate.class || cls == LocalTime.class || cls == String.class;
    }

    public static TIMESTAMP TimeZoneConvert(Connection conn, TIMESTAMP tstamp, TimeZone tz1, TimeZone tz2) throws SQLException {
        byte[] timestamp = tstamp.getBytes();
        int arrlength = timestamp.length;
        int[] result = arrlength == 11 ? new int[11] : new int[7];
        for (int i = 0; i < arrlength; ++i) {
            result[i] = timestamp[i] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        int month = result[2] - 1;
        int day = result[3];
        int hours = result[4] - 1;
        int minutes = result[5] - 1;
        int seconds = result[6] - 1;
        Calendar cal1 = Calendar.getInstance(tz1);
        cal1.set(1, year);
        cal1.set(2, month);
        cal1.set(5, day);
        cal1.set(11, hours);
        cal1.set(12, minutes);
        cal1.set(13, seconds);
        cal1.set(14, 0);
        long millis = cal1.getTimeInMillis();
        Timestamp ts = new Timestamp(millis);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp, 7);
        }
        ts.setNanos(nanos);
        Calendar cal2 = Calendar.getInstance(tz2);
        return new TIMESTAMP(ts, cal2);
    }

    @Override
    public String stringValue() {
        return TIMESTAMP.toString(this.getBytes());
    }

    public String toString() {
        return this.stringValue();
    }

    public static int getOracleYear(Calendar cal) {
        int year = cal.get(1);
        if (cal.get(0) == 0) {
            year = -year;
        }
        if (year < -4712 || year > 9999) {
            throw new IllegalArgumentException("Invalid year value");
        }
        return year;
    }

    public static int getOracleYear(int jYear) {
        return jYear <= 0 ? jYear - 1 : jYear;
    }

    @Override
    public Date dateValue() throws SQLException {
        return TIMESTAMP.toDate(this.getBytes());
    }

    @Override
    public Time timeValue() throws SQLException {
        return TIMESTAMP.toTime(this.getBytes());
    }

    public static int getJavaYear(int cent, int decade) {
        int year = (cent - 100) * 100 + (decade - 100);
        if (year < 0) {
            ++year;
        }
        return year;
    }

    public static TIMESTAMP of(LocalDateTime ldt) throws SQLException {
        return new TIMESTAMP(ldt);
    }

    public LocalDateTime toLocalDateTime() throws SQLException {
        return TIMESTAMP.toLocalDateTime(this.getBytes());
    }

    public LocalDateTime localDateTimeValue() throws SQLException {
        return TIMESTAMP.toLocalDateTime(this.getBytes());
    }

    public static TIMESTAMP of(OffsetDateTime odt) {
        return new TIMESTAMP(odt);
    }

    public static LocalDateTime toLocalDateTime(byte[] timestamp) throws SQLException {
        int arrlength = timestamp.length;
        int[] result = arrlength == 11 ? new int[11] : new int[7];
        for (int i = 0; i < timestamp.length; ++i) {
            result[i] = timestamp[i] & 0xFF;
        }
        int year = TIMESTAMP.getJavaYear(result[0], result[1]);
        int nanos = 0;
        if (arrlength == 11) {
            nanos = TIMESTAMP.getNanos(timestamp, 7);
        }
        LocalDateTime ldt = LocalDateTime.of(year, result[2], result[3], result[4] - 1, result[5] - 1, result[6] - 1, nanos);
        return ldt;
    }

    public static LocalTime toLocalTime(byte[] timestamp) throws SQLException {
        return TIMESTAMP.toLocalDateTime(timestamp).toLocalTime();
    }

    public static LocalDate toLocalDate(byte[] timestamp) throws SQLException {
        return TIMESTAMP.toLocalDateTime(timestamp).toLocalDate();
    }

    public static TIMESTAMP of(ZonedDateTime zdt) {
        return new TIMESTAMP(zdt);
    }

    public static TIMESTAMP of(OffsetTime ot) {
        return new TIMESTAMP(ot);
    }

    public static TIMESTAMP of(LocalTime lt) throws SQLException {
        return new TIMESTAMP(lt);
    }

    public LocalTime toLocalTime() throws SQLException {
        return TIMESTAMP.toLocalTime(this.getBytes());
    }

    public LocalTime localTimeValue() throws SQLException {
        return TIMESTAMP.toLocalTime(this.getBytes());
    }

    public static TIMESTAMP of(LocalDate ld) throws SQLException {
        return new TIMESTAMP(ld);
    }

    public LocalDate toLocalDate() throws SQLException {
        return TIMESTAMP.toLocalDate(this.getBytes());
    }

    public LocalDate localDateValue() throws SQLException {
        return TIMESTAMP.toLocalDate(this.getBytes());
    }

    public static byte[] toBytes(OffsetDateTime odt) {
        if (odt == null) {
            return null;
        }
        return TIMESTAMP.toBytes(odt.toLocalDateTime());
    }

    public static byte[] toBytes(ZonedDateTime zdt) {
        if (zdt == null) {
            return null;
        }
        return TIMESTAMP.toBytes(zdt.toLocalDateTime());
    }

    public static byte[] toBytes(OffsetTime ot) {
        if (ot == null) {
            return null;
        }
        return TIMESTAMP.toBytes(ot.toLocalTime().atDate(LocalDate.of(1970, 1, 1)));
    }

    public static byte[] toBytes(LocalDate ld) {
        if (ld == null) {
            return null;
        }
        return TIMESTAMP.toBytes(ld.atTime(0, 0, 0));
    }

    public static byte[] toBytes(LocalDateTime ldt) {
        byte[] result;
        if (ldt == null) {
            return null;
        }
        int year = TIMESTAMP.getOracleYear(ldt.getYear());
        int month = ldt.getMonthValue();
        int date = ldt.getDayOfMonth();
        int hour = ldt.getHour();
        int minute = ldt.getMinute();
        int second = ldt.getSecond();
        int nanos = ldt.getNano();
        if (nanos != 0) {
            result = new byte[11];
            result[7] = (byte)(nanos >> 24);
            result[8] = (byte)(nanos >> 16 & 0xFF);
            result[9] = (byte)(nanos >> 8 & 0xFF);
            result[10] = (byte)(nanos & 0xFF);
        } else {
            result = new byte[]{(byte)(year / 100 + 100), (byte)(year % 100 + 100), (byte)month, (byte)date, (byte)(hour + 1), (byte)(minute + 1), (byte)(second + 1)};
        }
        return result;
    }

    public static byte[] toBytes(LocalTime lt) {
        if (lt == null) {
            return null;
        }
        return TIMESTAMP.toBytes(lt.atDate(LocalDate.of(1970, 1, 1)));
    }

    private static byte[] initTimestamp() {
        byte[] tmp = new byte[11];
        tmp[0] = 119;
        tmp[1] = -86;
        tmp[2] = 1;
        tmp[3] = 1;
        tmp[4] = 1;
        tmp[5] = 1;
        tmp[6] = 1;
        return tmp;
    }

    private boolean isLeapYear(int y) {
        return y % 4 == 0 && (y <= 1582 ? y != -4712 : y % 100 != 0 || y % 400 == 0);
    }

    private boolean isValid() {
        byte[] ts = this.getBytes();
        if (ts.length != 11 && ts.length != 7) {
            return false;
        }
        int year = ((ts[0] & 0xFF) - 100) * 100 + ((ts[1] & 0xFF) - 100);
        if (year < -4712 || year > 9999) {
            return false;
        }
        if (year == 0) {
            return false;
        }
        int month = ts[2] & 0xFF;
        if (month < 1 || month > 12) {
            return false;
        }
        int day = ts[3] & 0xFF;
        if (day < 1 || day > 31) {
            return false;
        }
        if (!(day <= daysInMonth[month - 1] || this.isLeapYear(year) && month == 2 && day == 29)) {
            return false;
        }
        if (year == 1582 && month == 10 && day >= 5 && day < 15) {
            return false;
        }
        int hour = ts[4] & 0xFF;
        if (hour < 1 || hour > 24) {
            return false;
        }
        int minutes = ts[5] & 0xFF;
        if (minutes < 1 || minutes > 60) {
            return false;
        }
        int seconds = ts[6] & 0xFF;
        return seconds >= 1 && seconds <= 60;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (!this.isValid()) {
            throw new IOException("Invalid TIMESTAMP");
        }
    }
}

