/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.python.builtins.objects.contextvars;

import com.oracle.graal.python.PythonLanguage;
import com.oracle.graal.python.annotations.HashNotImplemented;
import com.oracle.graal.python.annotations.Slot;
import com.oracle.graal.python.builtins.Builtin;
import com.oracle.graal.python.builtins.CoreFunctions;
import com.oracle.graal.python.builtins.Python3Core;
import com.oracle.graal.python.builtins.PythonBuiltinClassType;
import com.oracle.graal.python.builtins.PythonBuiltins;
import com.oracle.graal.python.builtins.objects.contextvars.PContextVarsToken;
import com.oracle.graal.python.builtins.objects.contextvars.TokenBuiltinsFactory;
import com.oracle.graal.python.builtins.objects.contextvars.TokenBuiltinsSlotsGen;
import com.oracle.graal.python.builtins.objects.type.TpSlots;
import com.oracle.graal.python.nodes.ErrorMessages;
import com.oracle.graal.python.nodes.PRaiseNode;
import com.oracle.graal.python.nodes.attributes.WriteAttributeToPythonObjectNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinBaseNode;
import com.oracle.graal.python.nodes.function.PythonBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonBinaryBuiltinNode;
import com.oracle.graal.python.nodes.function.builtins.PythonUnaryBuiltinNode;
import com.oracle.graal.python.runtime.object.PFactory;
import com.oracle.graal.python.util.PythonUtils;
import com.oracle.truffle.api.dsl.Bind;
import com.oracle.truffle.api.dsl.GenerateNodeFactory;
import com.oracle.truffle.api.dsl.NodeFactory;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.strings.TruffleString;
import java.util.List;

@CoreFunctions(extendClasses={PythonBuiltinClassType.ContextVarsToken})
@HashNotImplemented
public final class TokenBuiltins
extends PythonBuiltins {
    public static final TpSlots SLOTS = TokenBuiltinsSlotsGen.SLOTS;
    private static final TruffleString MISSING_NAME = PythonUtils.tsLiteral("MISSING");

    @Override
    protected List<? extends NodeFactory<? extends PythonBuiltinBaseNode>> getNodeFactories() {
        return TokenBuiltinsFactory.getFactories();
    }

    @Override
    public void postInitialize(Python3Core core) {
        super.postInitialize(core);
        WriteAttributeToPythonObjectNode.executeUncached(core.lookupType(PythonBuiltinClassType.ContextVarsToken), MISSING_NAME, PContextVarsToken.MISSING);
    }

    @Builtin(name="__class_getitem__", minNumOfPositionalArgs=2, isClassmethod=true)
    @GenerateNodeFactory
    public static abstract class ClassGetItemNode
    extends PythonBinaryBuiltinNode {
        @Specialization
        static Object classGetItem(Object cls, Object key, @Bind PythonLanguage language) {
            return PFactory.createGenericAlias(language, cls, key);
        }
    }

    @Builtin(name="old_value", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class OldValueAttr
    extends PythonBuiltinNode {
        @Specialization
        public Object doOld(PContextVarsToken self) {
            Object oldValue = self.getOldValue();
            return oldValue == null ? PContextVarsToken.MISSING : oldValue;
        }
    }

    @Builtin(name="var", isGetter=true, minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class VarAttr
    extends PythonBuiltinNode {
        @Specialization
        public Object doVar(PContextVarsToken self) {
            return self.getVar();
        }
    }

    @Slot(value=Slot.SlotKind.tp_new, isComplex=true)
    @Slot.SlotSignature(name="Token", minNumOfPositionalArgs=1)
    @GenerateNodeFactory
    public static abstract class TokenNode
    extends PythonUnaryBuiltinNode {
        @Specialization
        Object construct(Object cls, @Bind Node inliningTarget) {
            throw PRaiseNode.raiseStatic(inliningTarget, PythonBuiltinClassType.RuntimeError, ErrorMessages.TOKEN_ONLY_BY_CONTEXTVAR);
        }
    }
}

