/*
 * Decompiled with CFR 0.152.
 */
package org.firebirdsql.gds.impl;

import java.sql.SQLException;
import org.firebirdsql.gds.ng.FbExceptionBuilder;
import org.firebirdsql.gds.ng.IAttachProperties;
import org.firebirdsql.jaybird.props.AttachmentProperties;

public class DbAttachInfo {
    private final String serverName;
    private final int portNumber;
    private final String attachObjectName;

    public DbAttachInfo(String serverName, Integer portNumber, String attachObjectName) {
        this(serverName, portNumber != null ? portNumber : 3050, attachObjectName);
    }

    public DbAttachInfo(String serverName, int portNumber, String attachObjectName) {
        this.serverName = serverName == null || serverName.isEmpty() ? null : serverName;
        this.portNumber = portNumber;
        this.attachObjectName = attachObjectName == null || attachObjectName.isEmpty() ? null : attachObjectName;
    }

    public static DbAttachInfo of(AttachmentProperties attachmentProperties) {
        return new DbAttachInfo(attachmentProperties.getServerName(), attachmentProperties.getPortNumber(), attachmentProperties.getProperty("attachObjectName"));
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean hasServerName() {
        return this.serverName != null;
    }

    public int getPortNumber() {
        return this.portNumber;
    }

    public String getAttachObjectName() {
        return this.attachObjectName;
    }

    public boolean hasAttachObjectName() {
        return this.attachObjectName != null;
    }

    public DbAttachInfo withServerName(String serverName) {
        return new DbAttachInfo(serverName, this.portNumber, this.attachObjectName);
    }

    public DbAttachInfo withAttachObjectName(String attachObjectName) {
        return new DbAttachInfo(this.serverName, this.portNumber, attachObjectName);
    }

    public <T extends IAttachProperties<T>> void copyTo(T attachProperties) {
        attachProperties.setServerName(this.serverName);
        attachProperties.setPortNumber(this.portNumber);
        attachProperties.setAttachObjectName(this.attachObjectName);
    }

    public static DbAttachInfo parseConnectString(String connectString) throws SQLException {
        if (connectString == null) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter("(null)").messageParameter("Connection string is missing").toSQLException();
        }
        if ((connectString = connectString.trim()).startsWith("//")) {
            return DbAttachInfo.parseUrlConnectString(connectString.substring(2), connectString);
        }
        return DbAttachInfo.parseLegacyConnectString(connectString);
    }

    private static DbAttachInfo parseUrlConnectString(String connectString, String originalConnectString) throws SQLException {
        int portSep;
        int pathSep;
        String server;
        if (connectString.isEmpty()) {
            return new DbAttachInfo(null, null, null);
        }
        Integer port = null;
        int connectStringLength = connectString.length();
        if (connectString.charAt(0) == '[') {
            int endIpv6Address = connectString.indexOf(93);
            if (endIpv6Address == -1) {
                throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(originalConnectString).messageParameter("IPv6 address expected, missing closing ']'").toSQLException();
            }
            server = connectString.substring(1, endIpv6Address);
            int afterEndIpv6Address = endIpv6Address + 1;
            pathSep = connectString.indexOf(47, afterEndIpv6Address);
            if (pathSep == -1) {
                pathSep = connectStringLength;
            }
            if ((portSep = connectString.indexOf(58, afterEndIpv6Address)) > pathSep) {
                portSep = -1;
            }
            if (portSep != afterEndIpv6Address && pathSep != afterEndIpv6Address) {
                throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(originalConnectString).messageParameter("Unexpected tokens '" + connectString.substring(afterEndIpv6Address) + "' after IPv6 address").toSQLException();
            }
        } else {
            pathSep = connectString.indexOf(47);
            if (pathSep == -1) {
                pathSep = connectStringLength;
            }
            if (pathSep == 0) {
                portSep = -1;
                server = null;
            } else {
                portSep = connectString.indexOf(58);
                if (portSep > pathSep) {
                    portSep = -1;
                }
                int endServer = portSep != -1 ? portSep : pathSep;
                server = connectString.substring(0, endServer);
            }
        }
        if (portSep == 0 || portSep == connectStringLength - 1) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(originalConnectString).messageParameter("Port separator ':' at beginning or end").toSQLException();
        }
        if (portSep > 0) {
            port = DbAttachInfo.parsePortNumber(originalConnectString, connectString.substring(portSep + 1, pathSep));
        }
        String fileName = pathSep < connectStringLength - 1 ? connectString.substring(pathSep + 1) : null;
        return new DbAttachInfo(server, port, fileName);
    }

    private static DbAttachInfo parseLegacyConnectString(String connectString) throws SQLException {
        String fileName;
        String server = null;
        Integer port = null;
        int sep = connectString.indexOf(58);
        if (sep == 0) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Path separator ':' at beginning").toSQLException();
        }
        if (sep == 1 && !DbAttachInfo.isLikelyWindowsAbsolutePath(connectString) || sep > 1) {
            server = connectString.substring(0, sep);
            fileName = connectString.substring(sep + 1);
            int portSep = server.indexOf(47);
            if (portSep == 0 || portSep == server.length() - 1) {
                throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Port separator '/' at beginning or end").toSQLException();
            }
            if (portSep > 0) {
                String portString = server.substring(portSep + 1);
                port = DbAttachInfo.parsePortNumber(connectString, portString);
                server = server.substring(0, portSep);
            }
        } else {
            fileName = connectString;
        }
        return new DbAttachInfo(server, port, fileName);
    }

    private static boolean isLikelyWindowsAbsolutePath(String connectString) {
        if (connectString.length() < 4 || connectString.charAt(1) != ':') {
            return false;
        }
        char possiblyPathSeparator = connectString.charAt(2);
        if (possiblyPathSeparator == '\\' || possiblyPathSeparator == '/') {
            char possiblyDriveLetter = connectString.charAt(0);
            return 'C' <= possiblyDriveLetter && possiblyDriveLetter <= 'Z' || 'c' <= possiblyDriveLetter && possiblyDriveLetter <= 'z';
        }
        return false;
    }

    private static Integer parsePortNumber(String connectString, String portString) throws SQLException {
        try {
            return Integer.valueOf(portString);
        }
        catch (NumberFormatException e) {
            throw new FbExceptionBuilder().nonTransientConnectionException(337248263).messageParameter(connectString).messageParameter("Bad port: '" + portString + "' is not a number").cause(e).toSQLException();
        }
    }
}

