"""A list of all SQL key words."""

RESERVED_KEYWORDS = [
    "ABSOLUTE",
    "ACTION",
    "ADD",
    "AFTER",
    "ALL",
    "ALLOCATE",
    "ALTER",
    "AND",
    "ANY",
    "APPEND",
    "ARE",
    "ARRAY",
    "AS",
    "ASC",
    "ASENSITIVE",
    "ASSERTION",
    "AT",
    "ATTRIBUTE",
    "AUTHID",
    "AUTHORIZATION",
    "BEFORE",
    "BEGIN",
    "BETWEEN",
    "BIGINT",
    "BINARY",
    "BIT",
    "BLOB",
    "BLOCKED",
    "BOOL",
    "BOOLEAN",
    "BOTH",
    "BY",
    "BYTE",
    "CALL",
    "CALLED",
    "CARDINALITY",
    "CASCADE",
    "CASCADED",
    "CASE",
    "CASESPECIFIC",
    "CAST",
    "CATALOG",
    "CHAIN",
    "CHAR",
    "CHARACTER",
    "CHARACTERISTICS",
    "CHARACTER_SET_CATALOG",
    "CHARACTER_SET_NAME",
    "CHARACTER_SET_SCHEMA",
    "CHECK",
    "CHECKED",
    "CLOB",
    "CLOSE",
    "COALESCE",
    "COLLATE",
    "COLLATION",
    "COLLATION_CATALOG",
    "COLLATION_NAME",
    "COLLATION_SCHEMA",
    "COLUMN",
    "COMMIT",
    "CONDITION",
    "CONNECTION",
    "CONNECT_BY_ISCYCLE",
    "CONNECT_BY_ISLEAF",
    "CONNECT_BY_ROOT",
    "CONSTANT",
    "CONSTRAINT",
    "CONSTRAINTS",
    "CONSTRAINT_STATE_DEFAULT",
    "CONSTRUCTOR",
    "CONTAINS",
    "CONTINUE",
    "CONTROL",
    "CONVERT",
    "CORRESPONDING",
    "CREATE",
    "CROSS",  # a unreserved keyword but needed to be reserved to make join clause work
    "CS",
    "CSV",
    "CUBE",
    "CURRENT",
    "CURRENT_DATE",
    "CURRENT_PATH",
    "CURRENT_ROLE",
    "CURRENT_SCHEMA",
    "CURRENT_SESSION",
    "CURRENT_STATEMENT",
    "CURRENT_TIME",
    "CURRENT_TIMESTAMP",
    "CURRENT_USER",
    "CURSOR",
    "CYCLE",
    "DATA",
    "DATALINK",
    "DATE",
    "DATETIME_INTERVAL_CODE",
    "DATETIME_INTERVAL_PRECISION",
    "DAY",
    "DBTIMEZONE",
    "DEALLOCATE",
    "DEC",
    "DECIMAL",
    "DECLARE",
    "DEFAULT",
    "DEFAULT_LIKE_ESCAPE_CHARACTER",
    "DEFERRABLE",
    "DEFERRED",
    "DEFINED",
    "DEFINER",
    "DELETE",
    "DEREF",
    "DERIVED",
    "DESC",
    "DESCRIBE",
    "DESCRIPTOR",
    "DETERMINISTIC",
    "DISABLE",
    "DISABLED",
    "DISCONNECT",
    "DISPATCH",
    "DISTINCT",
    "DLURLCOMPLETE",
    "DLURLPATH",
    "DLURLPATHONLY",
    "DLURLSCHEME",
    "DLURLSERVER",
    "DLVALUE",
    "DO",
    "DOMAIN",
    "DOUBLE",
    "DROP",
    "DYNAMIC",
    "DYNAMIC_FUNCTION",
    "DYNAMIC_FUNCTION_CODE",
    "EACH",
    "ELSE",
    "ELSEIF",
    "ELSIF",
    "EMITS",
    "ENABLE",
    "ENABLED",
    "END",
    "END-EXEC",
    "ENDIF",
    "ENFORCE",
    "EQUALS",
    "ERRORS",
    "ESCAPE",
    "EXCEPT",
    "EXCEPTION",
    "EXEC",
    "EXECUTE",
    "EXISTS",
    "EXIT",
    "EXPORT",
    "EXTERNAL",
    "EXTRACT",
    "FALSE",
    "FBV",
    "FETCH",
    "FILE",
    "FINAL",
    "FIRST",
    "FLOAT",
    "FOLLOWING",
    "FOR",
    "FORALL",
    "FORCE",
    "FORMAT",
    "FOUND",
    "FREE",
    "FROM",
    "FS",
    "FULL",
    "FUNCTION",
    "GENERAL",
    "GENERATED",
    "GEOMETRY",
    "GET",
    "GLOBAL",
    "GO",
    "GOTO",
    "GRANT",
    "GRANTED",
    "GROUP",
    "GROUPING",
    "GROUPS",
    "GROUP_CONCAT",
    "HASHTYPE",
    "HASHTYPE_FORMAT",
    "HAVING",
    "HIGH",
    "HOLD",
    "HOUR",
    "IDENTITY",
    "IF",
    "IFNULL",
    "IMMEDIATE",
    "IMPERSONATE",
    "IMPLEMENTATION",
    "IMPORT",
    "IN",
    "INDEX",
    "INDICATOR",
    "INNER",
    "INOUT",
    "INPUT",
    "INSENSITIVE",
    "INSERT",
    "INSTANCE",
    "INSTANTIABLE",
    "INT",
    "INTEGER",
    "INTEGRITY",
    "INTERSECT",
    "INTERVAL",
    "INTO",
    "INVERSE",
    "INVOKER",
    "IS",
    "ITERATE",
    "JOIN",
    "KEY_MEMBER",
    "KEY_TYPE",
    "LARGE",
    "LAST",
    "LATERAL",
    "LDAP",
    "LEADING",
    "LEAVE",
    "LEFT",
    "LEVEL",
    "LIKE",
    "LIMIT",
    "LISTAGG",
    "LOCAL",
    "LOCALTIME",
    "LOCALTIMESTAMP",
    "LOCATOR",
    "LOG",
    "LONGVARCHAR",
    "LOOP",
    "LOW",
    "MAP",
    "MATCH",
    "MATCHED",
    "MERGE",
    "METHOD",
    "MINUS",
    "MINUTE",
    "MOD",
    "MODIFIES",
    "MODIFY",
    "MODULE",
    "MONTH",
    "NAMES",
    "NATIONAL",
    "NATURAL",
    "NCHAR",
    "NCLOB",
    "NEW",
    "NEXT",
    "NLS_DATE_FORMAT",
    "NLS_DATE_LANGUAGE",
    "NLS_FIRST_DAY_OF_WEEK",
    "NLS_NUMERIC_CHARACTERS",
    "NLS_TIMESTAMP_FORMAT",
    "NO",
    "NOCYCLE",
    "NOLOGGING",
    "NONE",
    "NOT",
    "NULL",
    "NULLIF",
    "NUMBER",
    "NUMERIC",
    "NVARCHAR",
    "NVARCHAR2",
    "OBJECT",
    "OF",
    "OFF",
    "OLD",
    "ON",
    "ONLY",
    "OPEN",
    "OPTION",
    "OPTIONS",
    "OR",
    "ORDER",
    "ORDERING",
    "ORDINALITY",
    "OTHERS",
    "OUT",
    "OUTER",
    "OUTPUT",
    "OVER",
    "OVERLAPS",
    "OVERLAY",
    "OVERRIDING",
    "PAD",
    "PARALLEL_ENABLE",
    "PARAMETER",
    "PARAMETER_SPECIFIC_CATALOG",
    "PARAMETER_SPECIFIC_NAME",
    "PARAMETER_SPECIFIC_SCHEMA",
    "PARTIAL",
    "PARTITION",  # Should really be an unreserved keyword but need for Window clauses
    "PATH",
    "PERMISSION",
    "PLACING",
    "PLUS",
    "POSITION",
    "PRECEDING",
    "PREFERRING",
    "PREPARE",
    "PRESERVE",
    "PRIOR",
    "PRIVILEGES",
    "PROCEDURE",
    "PROFILE",
    "QUALIFY",
    "RANDOM",
    "RANGE",
    "READ",
    "READS",
    "REAL",
    "RECOVERY",
    "RECURSIVE",
    "REF",
    "REFERENCES",
    "REFERENCING",
    "REFRESH",
    "REGEXP_LIKE",
    "RELATIVE",
    "RELEASE",
    "RENAME",
    "REPEAT",
    "REPLACE",
    "RESTORE",
    "RESTRICT",
    "RESULT",
    "RETURN",
    "RETURNED_LENGTH",
    "RETURNED_OCTET_LENGTH",
    "RETURNS",
    "REVOKE",
    "RIGHT",
    "ROLLBACK",
    "ROLLUP",
    "ROUTINE",
    "ROW",
    "ROWS",
    "ROWTYPE",
    "SAVEPOINT",
    "SCHEMA",
    "SCOPE",
    "SCOPE_USER",
    "SCRIPT",
    "SCROLL",
    "SEARCH",
    "SECOND",
    "SECTION",
    "SECURITY",
    "SELECT",
    "SELECTIVE",
    "SELF",
    "SENSITIVE",
    "SEPARATOR",
    "SEQUENCE",
    "SESSION",
    "SESSIONTIMEZONE",
    "SESSION_USER",
    "SET",
    "SETS",
    "SHORTINT",
    "SIMILAR",
    "SMALLINT",
    "SOME",
    "SOURCE",
    "SPACE",
    "SPECIFIC",
    "SPECIFICTYPE",
    "SQL",
    "SQLEXCEPTION",
    "SQLSTATE",
    "SQLWARNING",
    "SQL_BIGINT",
    "SQL_BIT",
    "SQL_CHAR",
    "SQL_DATE",
    "SQL_DECIMAL",
    "SQL_DOUBLE",
    "SQL_FLOAT",
    "SQL_INTEGER",
    "SQL_LONGVARCHAR",
    "SQL_NUMERIC",
    "SQL_PREPROCESSOR_SCRIPT",
    "SQL_REAL",
    "SQL_SMALLINT",
    "SQL_TIMESTAMP",
    "SQL_TINYINT",
    "SQL_TYPE_DATE",
    "SQL_TYPE_TIMESTAMP",
    "SQL_VARCHAR",
    "START",
    "STATE",
    "STATEMENT",
    "STATIC",
    "STRUCTURE",
    "STYLE",
    "SUBSTRING",
    "SUBTYPE",
    "SYSDATE",
    "SYSTEM",
    "SYSTEM_USER",
    "SYSTIMESTAMP",
    "TABLE",
    "TEMPORARY",
    "TEXT",
    "THEN",
    "TIME",
    "TIMESTAMP",
    "TIMEZONE_HOUR",
    "TIMEZONE_MINUTE",
    "TINYINT",
    "TO",
    "TRAILING",
    "TRANSACTION",
    "TRANSFORM",
    "TRANSFORMS",
    "TRANSLATION",
    "TREAT",
    "TRIGGER",
    "TRIM",
    "TRUE",
    "TRUNCATE",
    "UNDER",
    "UNION",
    "UNIQUE",
    "UNKNOWN",
    "UNLINK",
    "UNNEST",
    "UNTIL",
    "UPDATE",
    "USAGE",
    "USER",
    "USING",
    "VALUE",
    "VALUES",
    "VARCHAR",
    "VARCHAR2",
    "VARRAY",
    "VERIFY",
    "VIEW",
    "WHEN",
    "WHENEVER",
    "WHERE",
    "WHILE",
    "WINDOW",
    "WITH",
    "WITHIN",
    "WITHOUT",
    "WORK",
    "YEAR",
    "YES",
    "ZONE",
]

UNRESERVED_KEYWORDS = [
    "ABS",
    "ACCESS",
    "ACOS",
    "ADAPTER",
    "ADD_DAYS",
    "ADD_HOURS",
    "ADD_MINUTES",
    "ADD_MONTHS",
    "ADD_SECONDS",
    "ADD_WEEKS",
    "ADD_YEARS",
    "ADMIN",
    "ALIGN",
    "ALWAYS",
    "ANALYZE",
    "ANSI",
    "APPROXIMATE_COUNT_DISTINCT",
    "ASCII",
    "ASIN",
    "ASSIGNMENT",
    "ASYMMETRIC",
    "ATAN",
    "ATAN2",
    "ATOMIC",
    "ATTEMPTS",
    "AUDIT",
    "AUTHENTICATED",
    "AUTO",
    "AVG",
    "BACKUP",
    "BERNOULLI",
    "BIT_AND",
    "BIT_CHECK",
    "BIT_LENGTH",
    "BIT_LROTATE",
    "BIT_LSHIFT",
    "BIT_NOT",
    "BIT_OR",
    "BIT_RROTATE",
    "BIT_RSHIFT",
    "BIT_SET",
    "BIT_TO_NUM",
    "BIT_XOR",
    "BREADTH",
    "CEIL",
    "CEILING",
    "CHANGE",
    "CHARACTERS",
    "CHARACTER_LENGTH",
    "CHR",
    "CLEAR",
    "COBOL",
    "COLOGNE_PHONETIC",
    "COMMENT",
    "COMMENTS",
    "COMMITTED",
    "CONCAT",
    "CONNECT",
    "CONVERT_TZ",
    "CORR",
    "COS",
    "COSH",
    "COT",
    "COUNT",
    "COVAR_POP",
    "COVAR_SAMP",
    "CREATED",
    "CURDATE",
    "DATABASE",
    "DATE_TRUNC",
    "DAYS_BETWEEN",
    "DEBUG",
    "DECODE",
    "DEFAULTS",
    "DEFAULT_CONSUMER_GROUP",
    "DEGREES",
    "DELIMIT",
    "DELIMITER",
    "DENSE_RANK",
    "DEPTH",
    "DIAGNOSTICS",
    "DICTIONARY",
    "DISTRIBUTE",
    "DISTRIBUTION",
    "DIV",
    "DOWN",
    "DUMP",
    "EDIT_DISTANCE",
    "EMPTY",
    "ENCODING",
    "ERROR",
    "ESTIMATE",
    "EVALUATE",
    "EVERY",
    "EXA",
    "EXCLUDE",
    "EXCLUDING",
    "EXP",
    "EXPERIMENTAL",
    "EXPIRE",
    "EXPLAIN",
    "EXPRESSION",
    "FAILED",
    "FILES",
    "FIRST_VALUE",
    "FLOOR",
    "FLUSH",
    "FOREIGN",
    "FORTRAN",
    "FROM_POSIX_TIME",
    "GRAPH",
    "GREATEST",
    "GROUPING_ID",
    "HANDLER",
    "HAS",
    "HASH",
    "HASHTYPE_MD5",
    "HASHTYPE_SHA",
    "HASHTYPE_SHA1",
    "HASHTYPE_SHA256",
    "HASHTYPE_SHA512",
    "HASHTYPE_TIGER",
    "HASH_MD5",
    "HASH_SHA",
    "HASH_SHA1",
    "HASH_SHA256",
    "HASH_SHA512",
    "HASH_TIGER",
    "HIERARCHY",
    "HOURS_BETWEEN",
    "IDENTIFIED",
    "IDLE_TIMEOUT",
    "IGNORE",
    "IMPERSONATION",
    "INCLUDING",
    "INITCAP",
    "INITIALLY",
    "INSTR",
    "INVALID",
    "IPROC",
    "ISOLATION",
    "IS_BOOLEAN",
    "IS_DATE",
    "IS_DSINTERVAL",
    "IS_NUMBER",
    "IS_TIMESTAMP",
    "IS_YMINTERVAL",
    "JAVA",
    "JAVASCRIPT",
    "JSON",
    "JSON_EXTRACT",
    "JSON_VALUE",
    "KEEP",
    "KERBEROS",
    "KEY",
    "KEYS",
    "KILL",
    "LAG",
    "LANGUAGE",
    "LAST_VALUE",
    "LCASE",
    "LEAD",
    "LEAST",
    "LENGTH",
    "LINK",
    "LN",
    "LOCATE",
    "LOCK",
    "LOG10",
    "LOG2",
    "LOGIN",
    "LOGS",
    "LONG",
    "LOWER",
    "LPAD",
    "LTRIM",
    "LUA",
    "MANAGE",
    "MAX",
    "MAXIMAL",
    "MEDIAN",
    "MESSAGE",
    "MID",
    "MIN",
    "MINUTES_BETWEEN",
    "MIN_SCALE",
    "MONTHS_BETWEEN",
    "MUL",
    "MULTIPLE",
    "MUMPS",
    "NEVER",
    "NICE",
    "NORMALIZED",
    "NOTICE",
    "NOW",
    "NPROC",
    "NULLIFZERO",
    "NULLS",
    "NUMTODSINTERVAL",
    "NUMTOYMINTERVAL",
    "NVL",
    "NVL2",
    "OBJECTS",
    "OCTETS",
    "OCTET_LENGTH",
    "OFFSET",
    "OPENID",
    "OPTIMIZE",
    "OPTIMIZER",
    "ORA",
    "OVERFLOW",
    "OWNER",
    "PADDING",
    "PASCAL",
    "PASSWORD",
    "PASSWORD_EXPIRY_POLICY",
    "PASSWORD_SECURITY_POLICY",
    "PERCENTILE_CONT",
    "PERCENTILE_DISC",
    "PI",
    "PLI",
    "POSIX_TIME",
    "POWER",
    "PRECISION",
    "PRELOAD",
    "PRIMARY",
    "PRINCIPAL",
    "PRIVILEGE",
    "PYTHON",
    "QUERY",
    "QUERY_CACHE",
    "QUERY_TIMEOUT",
    "QUIET",
    "R",
    "RADIANS",
    "RAND",
    "RANK",
    "RATIO_TO_REPORT",
    "RAW_SIZE_LIMIT",
    "RECOMPRESS",
    "RECORD",
    "REGEXP_INSTR",
    "REGEXP_REPLACE",
    "REGEXP_SUBSTR",
    "REGR_AVGX",
    "REGR_AVGY",
    "REGR_COUNT",
    "REGR_INTERCEPT",
    "REGR_R2",
    "REGR_SLOPE",
    "REGR_SXX",
    "REGR_SXY",
    "REGR_SYY",
    "REJECT",
    "REORGANIZE",
    "REPEATABLE",
    "RESET",
    "RESPECT",
    "RETURNING",
    "REVERSE",
    "ROLE",
    "ROLES",
    "ROUND",
    "ROWID",
    "ROW_NUMBER",
    "RPAD",
    "RTRIM",
    "SCALAR",
    "SCHEMAS",
    "SCHEME",
    "SCRIPT_LANGUAGES",
    "SCRIPT_OUTPUT_ADDRESS",
    "SECONDS_BETWEEN",
    "SECURE",
    "SERIALIZABLE",
    "SESSION_PARAMETER",
    "SESSION_TEMP_DB_RAM_LIMIT",
    "SHUT",
    "SIGN",
    "SIMPLE",
    "SIN",
    "SINH",
    "SIZE",
    "SKIP",
    "SNAPSHOT_MODE",
    "SOUNDEX",
    "SQRT",
    "STATISTICS",
    "STDDEV",
    "STDDEV_POP",
    "STDDEV_SAMP",
    "STEP",
    "ST_AREA",
    "ST_BOUNDARY",
    "ST_BUFFER",
    "ST_CENTROID",
    "ST_CONTAINS",
    "ST_CONVEXHULL",
    "ST_CROSSES",
    "ST_DIFFERENCE",
    "ST_DIMENSION",
    "ST_DISJOINT",
    "ST_DISTANCE",
    "ST_ENDPOINT",
    "ST_ENVELOPE",
    "ST_EQUALS",
    "ST_EXTERIORRING",
    "ST_FORCE2D",
    "ST_GEOMETRYN",
    "ST_GEOMETRYTYPE",
    "ST_INTERIORRINGN",
    "ST_INTERSECTION",
    "ST_INTERSECTS",
    "ST_ISCLOSED",
    "ST_ISEMPTY",
    "ST_ISRING",
    "ST_ISSIMPLE",
    "ST_LENGTH",
    "ST_MAX_DECIMAL_DIGITS",
    "ST_NUMGEOMETRIES",
    "ST_NUMINTERIORRINGS",
    "ST_NUMPOINTS",
    "ST_OVERLAPS",
    "ST_POINTN",
    "ST_SETSRID",
    "ST_STARTPOINT",
    "ST_SYMDIFFERENCE",
    "ST_TOUCHES",
    "ST_TRANSFORM",
    "ST_UNION",
    "ST_WITHIN",
    "ST_X",
    "ST_Y",
    "SUBSTR",
    "SUM",
    "SYMMETRIC",
    "SYS_CONNECT_BY_PATH",
    "SYS_GUID",
    "TABLES",
    "TABLESAMPLE",
    "TAN",
    "TANH",
    "TASKS",
    "TEMP_DB_RAM_LIMIT",
    "TIES",
    "TIMESTAMP_ARITHMETIC_BEHAVIOR",
    "TIME_ZONE",
    "TIME_ZONE_BEHAVIOR",
    "TO_CHAR",
    "TO_DATE",
    "TO_DSINTERVAL",
    "TO_NUMBER",
    "TO_TIMESTAMP",
    "TO_YMINTERVAL",
    "TRACE",
    "TRANSLATE",
    "TRUNC",
    "TYPE",
    "TYPEOF",
    "UCASE",
    "UNBOUNDED",
    "UNCOMMITTED",
    "UNDO",
    "UNICODE",
    "UNICODECHR",
    "UNLIMITED",
    "UPPER",
    "USE",
    "USER_TEMP_DB_RAM_LIMIT",
    "UTF8",
    "VALUE2PROC",
    "VARIANCE",
    "VARYING",
    "VAR_POP",
    "VAR_SAMP",
    "VIRTUAL",
    "WEEK",
    "WRITE",
    "YEARS_BETWEEN",
    "ZEROIFNULL",
    # Additional unreserved keywords not defined in EXA_SQL_KEYWORDS
    "CONSUMER",
    "CONSUMER_GROUP",
    "CPU_WEIGHT",
    "DRIVER",
    "GROUP_TEMP_DB_RAM_LIMIT",
    "JDBC",
    "PRECEDENCE",
    "ROWCOUNT",
    "SUBJECT",
]

BARE_FUNCTIONS = [
    "CONNECT_BY_ISCYCLE",
    "CONNECT_BY_ISLEAF",
    "CONNECT_BY_ROOT",
    "CURDATE",
    "CURRENT_DATE",
    "CURRENT_SCHEMA",
    "CURRENT_SESSION",
    "CURRENT_STATEMENT",
    "CURRENT_TIMESTAMP",
    "CURRENT_USER",
    "DBTIMEZONE",
    "LEVEL",
    "LOCALTIMESTAMP",
    "NOW",
    "ROWID",
    "ROWNUM",
    "SESSIONTIMEZONE",
    "SYSDATE",
    "SYSTIMESTAMP",
    "USER",
]

SYSTEM_PARAMETERS = [
    "CONSTRAINT_STATE_DEFAULT",
    "DEFAULT_CONSUMER_GROUP",
    "DEFAULT_LIKE_ESCAPE_CHARACTER",
    "HASHTYPE_FORMAT",
    "IDLE_TIMEOUT",
    "NLS_DATE_FORMAT",
    "NLS_DATE_LANGUAGE",
    "NLS_FIRST_DAY_OF_WEEK",
    "NLS_NUMERIC_CHARACTERS",
    "NLS_TIMESTAMP_FORMAT",
    "PASSWORD_SECURITY_POLICY",
    "PASSWORD_EXPIRY_POLICY",
    "PROFILE",
    "QUERY_CACHE",
    "QUERY_TIMEOUT",
    "SCRIPT_OUTPUT_ADDRESS",
    "SCRIPT_LANGUAGES",
    "SESSION_TEMP_DB_RAM_LIMIT",
    "SNAPSHOT_MODE",
    "SQL_PREPROCESSOR_SCRIPT",
    "ST_MAX_DECIMAL_DIGITS",
    "TEMP_DB_RAM_LIMIT",
    "TIME_ZONE",
    "TIME_ZONE_BEHAVIOR",
    "TIMESTAMP_ARITHMETIC_BEHAVIOR",
    "USER_TEMP_DB_RAM_LIMIT",
]

SESSION_PARAMETERS = [
    "CONSTRAINT_STATE_DEFAULT",
    "DEFAULT_LIKE_ESCAPE_CHARACTER",
    "HASHTYPE_FORMAT",
    "IDLE_TIMEOUT",
    "NICE",
    "NLS_DATE_LANGUAGE",
    "NLS_DATE_FORMAT",
    "NLS_FIRST_DAY_OF_WEEK",
    "NLS_NUMERIC_CHARACTERS",
    "NLS_TIMESTAMP_FORMAT",
    "PROFILE",
    "QUERY_CACHE",
    "QUERY_TIMEOUT",
    "SCRIPT_LANGUAGES",
    "SCRIPT_OUTPUT_ADDRESS",
    "SESSION_TEMP_DB_RAM_LIMIT",
    "SNAPSHOT_MODE",
    "SQL_PREPROCESSOR_SCRIPT",
    "ST_MAX_DECIMAL_DIGITS",
    "TIME_ZONE",
    "TIME_ZONE_BEHAVIOR",
    "TIMESTAMP_ARITHMETIC_BEHAVIOR",
]
