/**
 * @file
 * @author Jason Luu
 * @date   May 2009
 *
 * @brief Read a circuit netlist in XML format and populate
 *        the netlist data structures for VPR
 */

#ifndef READ_NETLIST_H
#define READ_NETLIST_H

#include "vpr_types.h"

ClusteredNetlist read_netlist(const char* net_file,
                              const t_arch* arch,
                              bool verify_file_digests,
                              int verbosity);

void set_atom_pin_mapping(const ClusteredNetlist& clb_nlist,
                          const AtomBlockId atom_blk,
                          const AtomPortId atom_port,
                          const t_pb_graph_pin* gpin);

#endif
