/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.internal;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableList;
import com.google.common.reflect.TypeToken;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.goodies.packageurl.PackageUrl;
import org.sonatype.ossindex.service.api.componentreport.ComponentReport;
import org.sonatype.ossindex.service.api.componentreport.ComponentReportRequest;
import org.sonatype.ossindex.service.client.OssindexClient;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.cache.Cache;
import org.sonatype.ossindex.service.client.cache.CacheConfiguration;
import org.sonatype.ossindex.service.client.cache.MemoryCache;
import org.sonatype.ossindex.service.client.marshal.Marshaller;
import org.sonatype.ossindex.service.client.transport.Transport;

public class OssindexClientImpl
implements OssindexClient {
    private static final Logger log = LoggerFactory.getLogger(OssindexClientImpl.class);
    private final Transport transport;
    private final Marshaller marshaller;
    private final Cache reportCache;
    private final URI baseUrl;
    private final int batchSize;
    private static final TypeToken<List<ComponentReport>> LIST_COMPONENT_REPORT = new TypeToken<List<ComponentReport>>(){};

    public OssindexClientImpl(OssindexClientConfiguration config, Transport transport, Marshaller marshaller) {
        Preconditions.checkNotNull((Object)config);
        this.transport = (Transport)Preconditions.checkNotNull((Object)transport);
        log.debug("Transport: {}", (Object)transport);
        this.marshaller = (Marshaller)Preconditions.checkNotNull((Object)marshaller);
        log.debug("Marshaller: {}", (Object)marshaller);
        Preconditions.checkState((config.getBaseUrl() != null ? 1 : 0) != 0, (Object)"Base-URL required");
        this.baseUrl = OssindexClientImpl.normalize(config.getBaseUrl());
        log.debug("Base URL: {}", (Object)this.baseUrl);
        Preconditions.checkState((config.getBatchSize() > 0 && config.getBatchSize() <= 1024 ? 1 : 0) != 0, (Object)"Batch-size out of range");
        this.batchSize = config.getBatchSize();
        log.debug("Batch size: {}", (Object)this.batchSize);
        try {
            CacheConfiguration cacheConfiguration = config.getCacheConfiguration();
            if (cacheConfiguration == null) {
                cacheConfiguration = new MemoryCache.Configuration();
            }
            this.reportCache = cacheConfiguration.create();
            log.debug("Report cache: {}", (Object)this.reportCache);
            transport.init(config);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws Exception {
        try {
            this.transport.close();
        }
        catch (Exception e) {
            log.error("Failed to close transport", (Throwable)e);
        }
        try {
            this.reportCache.close();
        }
        catch (Exception e) {
            log.error("Failed to close report-cache", (Throwable)e);
        }
    }

    private static URI normalize(URI baseUrl) {
        if (!baseUrl.toString().endsWith("/")) {
            return URI.create(baseUrl + "/");
        }
        return baseUrl;
    }

    @Override
    public Map<PackageUrl, ComponentReport> requestComponentReports(List<PackageUrl> coordinates) throws Exception {
        Preconditions.checkNotNull(coordinates);
        Preconditions.checkArgument((!coordinates.isEmpty() ? 1 : 0) != 0, (Object)"One or more coordinates required");
        log.debug("Requesting {} component-reports", (Object)coordinates.size());
        Stopwatch watch = Stopwatch.createStarted();
        HashMap<PackageUrl, ComponentReport> purlReports = new HashMap<PackageUrl, ComponentReport>(coordinates.size());
        LinkedList<PackageUrl> uncached = new LinkedList<PackageUrl>();
        for (PackageUrl purl : coordinates) {
            ComponentReport report = this.reportCache.getIfPresent(purl);
            if (report != null) {
                log.debug("Found cached report for: {}", (Object)purl);
                purlReports.put(purl, report);
                continue;
            }
            uncached.add(purl);
        }
        if (!uncached.isEmpty()) {
            HashSet<PackageUrl> batch = new HashSet<PackageUrl>(this.batchSize);
            Iterator iter = uncached.iterator();
            while (iter.hasNext()) {
                batch.add((PackageUrl)iter.next());
                if (batch.size() != this.batchSize && iter.hasNext()) continue;
                Map<PackageUrl, ComponentReport> reports = this.doRequestComponentReports(batch);
                this.reportCache.putAll(reports);
                purlReports.putAll(reports);
                batch.clear();
            }
        }
        LinkedHashMap<PackageUrl, ComponentReport> results = new LinkedHashMap<PackageUrl, ComponentReport>(coordinates.size());
        for (PackageUrl purl : coordinates) {
            results.put(purl, (ComponentReport)purlReports.get(purl));
        }
        log.debug("{} component-reports; {}", (Object)results.size(), (Object)watch);
        return results;
    }

    private Map<PackageUrl, ComponentReport> doRequestComponentReports(Set<PackageUrl> coordinates) throws Exception {
        log.debug("Requesting {} un-cached component-reports", (Object)coordinates.size());
        ComponentReportRequest request = new ComponentReportRequest();
        request.setCoordinates((List)ImmutableList.copyOf(coordinates));
        URI url = this.baseUrl.resolve("api/v3/component-report");
        String response = this.transport.post(url, "application/vnd.ossindex.component-report-request.v1+json", this.marshaller.marshal(request), "application/vnd.ossindex.component-report.v1+json");
        List<ComponentReport> reports = this.marshaller.unmarshal(response, LIST_COMPONENT_REPORT);
        Preconditions.checkState((reports.size() == coordinates.size() ? 1 : 0) != 0, (String)"Result size mismatch; expected: %s, have: %s", (int)coordinates.size(), (int)reports.size());
        HashMap<PackageUrl, ComponentReport> results = new HashMap<PackageUrl, ComponentReport>(coordinates.size());
        for (ComponentReport report : reports) {
            results.put(report.getCoordinates(), report);
        }
        return results;
    }

    @Override
    public ComponentReport requestComponentReport(PackageUrl coordinates) throws Exception {
        Preconditions.checkNotNull((Object)coordinates);
        Map<PackageUrl, ComponentReport> reports = this.requestComponentReports(Collections.singletonList(coordinates));
        ComponentReport result = reports.get(coordinates);
        Preconditions.checkState((result != null ? 1 : 0) != 0, (Object)"Missing component-report for singleton request");
        return result;
    }
}

