/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.client.transport;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.net.URI;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.ossindex.service.client.OssindexClientConfiguration;
import org.sonatype.ossindex.service.client.transport.AuthConfiguration;
import org.sonatype.ossindex.service.client.transport.BasicAuthHelper;
import org.sonatype.ossindex.service.client.transport.ProxyConfiguration;
import org.sonatype.ossindex.service.client.transport.TimeoutConfiguration;
import org.sonatype.ossindex.service.client.transport.Transport;
import org.sonatype.ossindex.service.client.transport.UserAgentSupplier;

public class HttpClientTransport
implements Transport {
    private static final Logger log = LoggerFactory.getLogger(HttpClientTransport.class);
    private final UserAgentSupplier userAgent;
    private OssindexClientConfiguration configuration;

    public HttpClientTransport(UserAgentSupplier userAgent) {
        this.userAgent = (UserAgentSupplier)Preconditions.checkNotNull((Object)userAgent);
    }

    @Override
    public void init(OssindexClientConfiguration configuration) {
        this.configuration = (OssindexClientConfiguration)Preconditions.checkNotNull((Object)configuration);
    }

    @Override
    public void close() throws Exception {
    }

    /*
     * Exception decompiling
     */
    @Override
    public String post(URI url, String payloadType, String payload, String acceptType) throws Transport.TransportException, IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected CloseableHttpClient createClient() {
        TimeoutConfiguration timeoutConfiguration;
        HttpClientBuilder builder = HttpClientBuilder.create();
        builder.disableCookieManagement();
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        builder.setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider);
        ProxyConfiguration proxyConfiguration = this.configuration.getProxyConfiguration();
        if (proxyConfiguration != null) {
            HttpHost proxy = new HttpHost(proxyConfiguration.getHost(), proxyConfiguration.getPort(), proxyConfiguration.getProtocol());
            builder.setProxy(proxy);
            log.debug("Configured http-proxy: {}", (Object)proxy);
            AuthConfiguration auth = proxyConfiguration.getAuthConfiguration();
            if (auth != null) {
                credentialsProvider.setCredentials(new AuthScope(proxy), (Credentials)new UsernamePasswordCredentials(auth.getUsername(), auth.getPassword()));
                log.debug("Configured http-proxy authentication");
            }
        }
        if ((timeoutConfiguration = this.configuration.getTimeoutConfiguration()) != null) {
            RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(timeoutConfiguration.getConnectTimeout()).setConnectionRequestTimeout(timeoutConfiguration.getConnectionRequestTimeout()).setSocketTimeout(timeoutConfiguration.getSocketTimeout()).build();
            builder.setDefaultRequestConfig(requestConfig);
        }
        return builder.build();
    }

    protected void customize(HttpPost request) {
        request.setHeader("User-Agent", this.userAgent.get());
        String authorization = BasicAuthHelper.authorizationHeader(this.configuration.getAuthConfiguration());
        if (authorization != null) {
            request.setHeader("Authorization", authorization);
        }
    }
}

