/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.ossindex.service.api.cvss;

import com.google.common.base.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonatype.ossindex.service.api.cvss.Cvss2Vector;
import org.sonatype.ossindex.service.api.cvss.Cvss3Vector;
import org.sonatype.ossindex.service.api.cvss.CvssVector;

public class CvssVectorFactory {
    private static final Logger log = LoggerFactory.getLogger(CvssVectorFactory.class);

    public static CvssVector create(String value) {
        Preconditions.checkNotNull((Object)value);
        log.trace("Create: {}", (Object)value);
        if (value.startsWith("CVSS:3.0")) {
            return new Cvss3Vector(value);
        }
        return new Cvss2Vector(value);
    }
}

