/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.io.File;
import java.util.LinkedHashMap;
import java.util.List;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.FileQuery;
import org.anarres.jdiagnostics.JarQuery;
import org.anarres.jdiagnostics.Result;

public class ClassPathQuery
extends AbstractQuery {
    public String getName() {
        return "classpath";
    }

    private void path(Result result, String prefix, String pathName) {
        List<String> path = JarQuery.get_path(result, prefix, pathName);
        if (path == null) {
            result.put(prefix + "error", "Not a classpath: " + pathName);
            return;
        }
        Result out = new Result(new LinkedHashMap<String, Object>());
        int i = 0;
        for (String element : path) {
            out.put(i + ": " + element, new FileQuery(new File(element)).call());
            ++i;
        }
        result.put(prefix + pathName, out);
    }

    private void dir(Result result, String prefix, File dir) {
        File[] files = dir.listFiles();
        if (files == null) {
            result.put(prefix + "error", "Not a directory: " + dir);
            return;
        }
        Result out = new Result(new LinkedHashMap<String, Object>());
        int i = 0;
        for (File file : files) {
            out.put(i + ":" + file, new FileQuery(file).call());
            ++i;
        }
        result.put(prefix + "path", out);
    }

    private void dirs(Result result, String prefix, String dirsName) {
        List<String> path = JarQuery.get_path(result, prefix, dirsName);
        if (path == null) {
            result.put(prefix + "error", "Not a dirpath: " + dirsName);
            return;
        }
        Result out = new Result(new LinkedHashMap<String, Object>());
        int i = 0;
        for (String element : path) {
            this.dir(out, prefix + i + ": " + element, new File(element));
            ++i;
        }
        result.put(prefix + dirsName, out);
    }

    public void call(Result result, String prefix) {
        this.path(result, prefix, "java.class.path");
        this.path(result, prefix, "sun.boot.class.path");
        this.dirs(result, prefix, "java.ext.dirs");
    }
}

