/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.FileQuery;
import org.anarres.jdiagnostics.Result;

public class DirectoryQuery
extends AbstractQuery {
    private final File directory;
    private final boolean writable;

    public DirectoryQuery(File directory, boolean writable) {
        this.directory = directory;
        this.writable = writable;
    }

    public String getName() {
        return "directory/" + this.directory + "[writable=" + this.writable + "]";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(Result result, String prefix) {
        new FileQuery(this.directory).call(result, prefix);
        if (!this.directory.isDirectory()) {
            return;
        }
        if (!this.writable) {
            return;
        }
        if (!this.directory.canWrite()) {
            return;
        }
        try {
            long now = System.currentTimeMillis();
            int outSize = 1024;
            byte[] buf = new byte[outSize];
            File file = File.createTempFile("jdiagnostics", "testfile", this.directory);
            try {
                FileOutputStream out = new FileOutputStream(file);
                try {
                    ((OutputStream)out).write(buf);
                }
                finally {
                    ((OutputStream)out).close();
                }
                result.put(prefix + "drift", file.lastModified() - now);
                long inSize = 0L;
                FileInputStream in = new FileInputStream(file);
                try {
                    int read;
                    while ((read = ((InputStream)in).read(buf)) > 0) {
                        inSize += (long)read;
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
                if (inSize != (long)outSize) {
                    result.put(prefix + "sizemismatch", "outSize=" + outSize + ", inSize=" + inSize);
                }
            }
            finally {
                if (!file.delete()) {
                    result.put(prefix + "deletefailed", "true");
                }
            }
        }
        catch (IOException e) {
            this.thrown(result, prefix, e);
        }
    }
}

