/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.lang.reflect.Field;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FieldExistsQuery
extends AbstractQuery {
    public final Class<?> type;
    public final String fieldName;

    public FieldExistsQuery(Class<?> type, String fieldName) {
        this.type = type;
        this.fieldName = fieldName;
    }

    @Override
    public String getName() {
        return "fieldExists/" + this.type.getName() + "." + this.fieldName;
    }

    public Field findField(Result result, String prefix) {
        try {
            Field field = this.type.getDeclaredField(this.fieldName);
            result.put(prefix + "field", field);
            return field;
        }
        catch (NoSuchFieldException e) {
            this.thrown(result, prefix, e);
        }
        catch (SecurityException e) {
            this.thrown(result, prefix, e);
        }
        return null;
    }

    @Override
    public void call(Result result, String prefix) {
        Field field = this.findField(result, prefix);
        result.put(prefix + "exists", field != null);
    }
}

