/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.Result;

public class FileQuery
extends AbstractQuery {
    private final File file;

    public FileQuery(File file) {
        this.file = file;
    }

    public String getName() {
        return "file/" + this.file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void call(Result result, String prefix) {
        result.put(prefix + "path", this.file.getPath());
        try {
            String canonicalPath = this.file.getCanonicalPath();
            if (!canonicalPath.equals(this.file.getPath())) {
                result.put(prefix + "canonicalPath", canonicalPath);
            }
        }
        catch (IOException e) {
            this.thrown(result, prefix + "canonicalPath/", e);
        }
        result.put(prefix + "stat", "size=" + this.file.length() + ", exists=" + this.file.exists() + ", isFile=" + this.file.isFile() + ", isDirectory=" + this.file.isDirectory() + ", canRead=" + this.file.canRead() + ", canWrite=" + this.file.canWrite());
        if (this.file.isFile() && this.file.canRead()) {
            try {
                MessageDigest digest = MessageDigest.getInstance("MD5");
                FileInputStream in = new FileInputStream(this.file);
                try {
                    int len;
                    byte[] block = new byte[4096];
                    while ((len = ((InputStream)in).read(block)) >= 0) {
                        digest.update(block, 0, len);
                    }
                }
                catch (EOFException block) {
                }
                finally {
                    ((InputStream)in).close();
                }
                StringBuilder buf = new StringBuilder();
                for (byte b : digest.digest()) {
                    buf.append(Integer.toHexString(b & 0xFF));
                }
                result.put(prefix + "md5sum", buf.toString());
            }
            catch (IOException e) {
                this.thrown(result, prefix + "md5sum/", e);
            }
            catch (NoSuchAlgorithmException e) {
                this.thrown(result, prefix + "md5sum/", e);
            }
        }
    }
}

