/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.Result;

public class MethodCallQuery
extends AbstractQuery {
    private final Object target;
    private final Method method;
    private final Object[] arguments;

    public MethodCallQuery(Object target, Method method, Object[] arguments) {
        this.target = target;
        this.method = method;
        this.arguments = arguments;
    }

    public String getName() {
        return "method/" + this.method.getDeclaringClass().getName() + "." + this.method.getName();
    }

    public Object invoke(Result result, String prefix) {
        try {
            Object value = this.method.invoke(this.target, this.arguments);
            result.put(prefix + "value", value);
            return value;
        }
        catch (InvocationTargetException e) {
            this.thrown(result, prefix, e);
        }
        catch (IllegalArgumentException e) {
            this.thrown(result, prefix, e);
        }
        catch (IllegalAccessException e) {
            this.thrown(result, prefix, e);
        }
        return null;
    }

    public void call(Result result, String prefix) {
        this.invoke(result, prefix);
    }
}

