/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Documented;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProductMetadata {
    private final ClassLoader loader;
    private final Map<String, ModuleMetadata> modules = new TreeMap<String, ModuleMetadata>();

    @Nonnull
    private static Logger getLogger() {
        return Logger.getLogger(ProductMetadata.class.getName());
    }

    @Nonnull
    private static ClassLoader getDefaultClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader != null) {
            return loader;
        }
        return ProductMetadata.class.getClassLoader();
    }

    @CheckForNull
    private static Manifest newManifest(@Nonnull URL resource) {
        Manifest manifest;
        InputStream in = resource.openStream();
        try {
            manifest = new Manifest(in);
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (Exception e) {
                ProductMetadata.getLogger().log(Level.WARNING, "Failed to load Manifest from " + resource, e);
                return null;
            }
        }
        in.close();
        return manifest;
    }

    public ProductMetadata(@Nonnull ClassLoader loader) throws IOException {
        this.loader = loader;
        this.load();
    }

    public ProductMetadata() throws IOException {
        this(ProductMetadata.getDefaultClassLoader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @CheckForNull
    private ModuleMetadata newModule(@Nonnull URL manifestUrl, @Nonnull Manifest manifest, @Nonnull ModuleVersion version) {
        ModuleMetadata module = new ModuleMetadata(this, version, manifestUrl, manifest);
        String spec = "/META-INF/" + version.getName() + ".properties";
        try {
            URL propertiesUrl = new URL(manifestUrl, spec);
            try {
                InputStream in = propertiesUrl.openStream();
                try {
                    module.properties.load(in);
                }
                finally {
                    in.close();
                }
            }
            catch (FileNotFoundException fileNotFoundException) {}
        }
        catch (Exception e) {
            ProductMetadata.getLogger().log(Level.WARNING, "Failed to load ModuleMetadata for " + version + " from " + spec, e);
        }
        return module;
    }

    private void load() throws IOException {
        Enumeration<URL> manifestUrls = this.loader.getResources("META-INF/MANIFEST.MF");
        for (URL manifestUrl : Collections.list(manifestUrls)) {
            ModuleMetadata moduleMetadata;
            ModuleVersion moduleVersion;
            Attributes attributes;
            Manifest manifest = ProductMetadata.newManifest(manifestUrl);
            if (manifest == null || (attributes = manifest.getMainAttributes()) == null || (moduleVersion = ModuleVersion.forAttributes(attributes)) == null || (moduleMetadata = this.newModule(manifestUrl, manifest, moduleVersion)) == null) continue;
            this.modules.put(moduleMetadata.getName(), moduleMetadata);
        }
    }

    @Nonnull
    public Collection<ModuleMetadata> getModules() {
        return new ArrayList<ModuleMetadata>(this.modules.values());
    }

    @CheckForNull
    public ModuleMetadata getModule(@Nonnull String name) {
        return this.modules.get(name);
    }

    @Nonnull
    public String toString(String namePrefix) {
        StringBuilder buf = new StringBuilder();
        for (ModuleMetadata module : this.getModules()) {
            if (!module.getName().startsWith(namePrefix)) continue;
            buf.append(module).append("\n");
        }
        return buf.toString();
    }

    public String toString() {
        return this.toString("");
    }

    public static class ModuleMetadata {
        private final ProductMetadata productMetadata;
        private final ModuleVersion moduleVersion;
        private final URL manifestUrl;
        private final Manifest manifest;
        private final Properties properties = new Properties();

        public ModuleMetadata(@Nonnull ProductMetadata productMetadata, @Nonnull ModuleVersion moduleVersion, @CheckForNull URL manifestUrl, @Nonnull Manifest manifest) {
            this.productMetadata = productMetadata;
            this.moduleVersion = moduleVersion;
            this.manifestUrl = manifestUrl;
            this.manifest = manifest;
        }

        @Nonnull
        public ProductMetadata getProductMetadata() {
            return this.productMetadata;
        }

        @Nonnull
        public ModuleVersion getModuleVersion() {
            return this.moduleVersion;
        }

        @Nonnull
        public String getName() {
            return this.getModuleVersion().toName();
        }

        @Nonnull
        public String getVersion() {
            return this.getModuleVersion().getVersion();
        }

        @Nonnull
        public Manifest getManifest() {
            return this.manifest;
        }

        @Nonnull
        public Properties getProperties() {
            return this.properties;
        }

        @CheckForNull
        public File getJar() {
            if (this.manifestUrl == null) {
                return null;
            }
            String resourcePath = this.manifestUrl.toString();
            if (!resourcePath.startsWith("jar:file:")) {
                return null;
            }
            int idx = (resourcePath = resourcePath.substring(9)).indexOf(33);
            if (idx > 0) {
                resourcePath = resourcePath.substring(0, idx);
            }
            return new File(resourcePath.replace('/', File.separatorChar));
        }

        @CheckForNull
        public String getMetadataProperty(@Nonnull String key) {
            String value = this.properties.getProperty(key);
            if (value == null) {
                value = this.manifest.getMainAttributes().getValue(key);
            }
            return value;
        }

        @CheckForNull
        public String getMetadataProperty(@Nonnull MetadataProperty key) {
            return this.getMetadataProperty(key.key);
        }

        @CheckForNull
        public String getRevision() {
            return this.getMetadataProperty(MetadataProperty.Change);
        }

        @CheckForNull
        public String getBuildBranch() {
            return this.getMetadataProperty(MetadataProperty.Branch);
        }

        @CheckForNull
        public String getBuildDate() {
            return this.getMetadataProperty(MetadataProperty.Build_Date);
        }

        @Nonnull
        public String getSummary() {
            String buildDate;
            String revision;
            StringBuilder buf = new StringBuilder();
            buf.append(this.getModuleVersion());
            String branch = this.getBuildBranch();
            if (branch != null && !"master".equals(branch)) {
                buf.append(" (branch ").append(branch).append(")");
            }
            if ((revision = this.getRevision()) != null) {
                buf.append(" (rev ").append(revision).append(")");
            }
            if ((buildDate = this.getBuildDate()) != null) {
                buf.append(" built on ").append(buildDate);
            }
            return buf.toString();
        }

        @CheckForNull
        public String getBuildHost() {
            return this.getMetadataProperty(MetadataProperty.Build_Host);
        }

        @CheckForNull
        public String getBuildJob() {
            return this.getMetadataProperty(MetadataProperty.Build_Job);
        }

        @CheckForNull
        public String getBuildNumber() {
            return this.getMetadataProperty(MetadataProperty.Build_Number);
        }

        @Nonnull
        public String getBuildSummary() {
            String buildNumber;
            String buildJob;
            StringBuilder buf = new StringBuilder();
            buf.append("Built by ");
            String buildHost = this.getBuildHost();
            if (buildHost != null) {
                buf.append(buildHost);
            }
            if ((buildJob = this.getBuildJob()) != null) {
                buf.append(":").append(buildJob);
            }
            if ((buildNumber = this.getBuildNumber()) != null) {
                buf.append("#").append(buildNumber);
            }
            return buf.toString();
        }

        public String toString() {
            return this.getSummary();
        }
    }

    public static class ModuleVersion {
        private final String group;
        private final String name;
        private final String version;

        public ModuleVersion(@CheckForNull String group, @Nonnull String name, @Nonnull String version) {
            this.group = group;
            this.name = name;
            this.version = version;
        }

        @CheckForNull
        public String getGroup() {
            return this.group;
        }

        @Nonnull
        public String getName() {
            return this.name;
        }

        @Nonnull
        public String getVersion() {
            return this.version;
        }

        private void toName(@Nonnull StringBuilder buf) {
            if (this.group != null) {
                buf.append(this.group).append(':');
            }
            buf.append(this.name);
        }

        public String toName() {
            StringBuilder buf = new StringBuilder();
            this.toName(buf);
            return buf.toString();
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            this.toName(buf);
            buf.append(':').append(this.version);
            return buf.toString();
        }

        @CheckForNull
        public static ModuleVersion forGradleInfo(@Nonnull Attributes attributes) {
            String implementationTitle = attributes.getValue(MetadataProperty.Implementation_Title.key);
            if (implementationTitle == null) {
                return null;
            }
            int hashIdx = implementationTitle.indexOf(35);
            if (hashIdx == -1) {
                return null;
            }
            String group = implementationTitle.substring(0, hashIdx);
            int semiIdx = (implementationTitle = implementationTitle.substring(hashIdx + 1)).indexOf(59);
            if (semiIdx == -1) {
                return null;
            }
            String version = implementationTitle.substring(semiIdx + 1);
            implementationTitle = implementationTitle.substring(0, semiIdx);
            return new ModuleVersion(group, implementationTitle, version);
        }

        @CheckForNull
        public static ModuleVersion forMavenPlexus(@Nonnull Attributes attributes) {
            String implementationTitle = attributes.getValue(MetadataProperty.Implementation_Title.key);
            if (implementationTitle == null) {
                return null;
            }
            String implementationVersion = attributes.getValue(MetadataProperty.Implementation_Version.key);
            if (implementationVersion == null) {
                return null;
            }
            String implementationVendor = attributes.getValue(MetadataProperty.Implementation_Vendor_Id.key);
            return new ModuleVersion(implementationVendor, implementationTitle, implementationVersion);
        }

        @CheckForNull
        public static ModuleVersion forMavenBundle(@Nonnull Attributes attributes) {
            String bundleSymbolicName = attributes.getValue(MetadataProperty.Bundle_SymbolicName.key);
            if (bundleSymbolicName == null) {
                return null;
            }
            String bundleVersion = attributes.getValue(MetadataProperty.Bundle_Version.key);
            if (bundleVersion == null) {
                return null;
            }
            return new ModuleVersion(null, bundleSymbolicName, bundleVersion);
        }

        @CheckForNull
        public static ModuleVersion forAttributes(@Nonnull Attributes attributes) {
            ModuleVersion moduleVersion = ModuleVersion.forGradleInfo(attributes);
            if (moduleVersion != null) {
                return moduleVersion;
            }
            moduleVersion = ModuleVersion.forMavenPlexus(attributes);
            if (moduleVersion != null) {
                return moduleVersion;
            }
            moduleVersion = ModuleVersion.forMavenBundle(attributes);
            if (moduleVersion != null) {
                return moduleVersion;
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MetadataProperty {
        Archiver_Version("Archiver-Version"),
        Bnd_LastModified("Bnd-LastModified"),
        Branch("Branch"),
        Build_Date("Build-Date"),
        Build_Host("Build-Host"),
        Build_Id("Build-Id"),
        Build_Java_Version("Build-Java-Version"),
        Build_Jdk("Build-Jdk"),
        Build_Job("Build-Job"),
        Build_Number("Build-Number"),
        Built_By("Built-By"),
        Built_OS("Built-OS"),
        Built_Status("Built-Status"),
        Bundle_Description("Bundle-Description"),
        Bundle_DocURL("Bundle-DocURL"),
        Bundle_License("Bundle-License"),
        Bundle_ManifestVersion("Bundle-ManifestVersion"),
        Bundle_Name("Bundle-Name"),
        Bundle_RequiredExecutionEnvironment("Bundle-RequiredExecutionEnvironment"),
        Bundle_SymbolicName("Bundle-SymbolicName"),
        Bundle_Vendor("Bundle-Vendor"),
        Bundle_Version("Bundle-Version"),
        Change("Change"),
        Created_By("Created-By"),
        Gradle_Version("Gradle-Version"),
        Implementation_Title("Implementation-Title"),
        Implementation_Vendor("Implementation-Vendor"),
        Implementation_Vendor_Id("Implementation-Vendor-Id"),
        Implementation_Version("Implementation-Version"),
        Manifest_Version("Manifest-Version"),
        Module_Origin("Module-Origin"),
        Module_Source("Module-Source"),
        X_Compile_Source_JDK("X-Compile-Source-JDK"),
        X_Compile_Target_JDK("X-Compile-Target-JDK");

        private final String key;

        private MetadataProperty(String key) {
            this.key = key;
        }

        @Nonnull
        public String getKey() {
            return this.key;
        }

        public String toString() {
            return this.getKey();
        }
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    private static @interface CheckForNull {
    }

    @Documented
    @Retention(value=RetentionPolicy.CLASS)
    private static @interface Nonnull {
    }
}

