/*
 * Decompiled with CFR 0.152.
 */
package org.anarres.jdiagnostics;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.anarres.jdiagnostics.AbstractQuery;
import org.anarres.jdiagnostics.Result;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceQuery
extends AbstractQuery {
    private final String resourceName;

    public ResourceQuery(String resourceName) {
        this.resourceName = resourceName;
    }

    @Override
    public String getName() {
        return "resource";
    }

    public List<URL> findResources(Result result, String prefix) {
        try {
            Enumeration<URL> resourcesUrls = this.getClass().getClassLoader().getResources(this.resourceName);
            ArrayList<URL> resources = Collections.list(resourcesUrls);
            result.put(prefix + "resources", "(" + resources.size() + ") " + resources);
            return resources;
        }
        catch (IOException t) {
            this.thrown(result, prefix, t);
            return null;
        }
    }

    @Override
    public void call(Result result, String prefix) {
        this.findResources(result, prefix);
    }
}

