/*
 * Decompiled with CFR 0.152.
 */
package org.owasp.dependencycheck.utils;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SeverityUtil {
    private static final Double HIGH = 10.0;
    private static final Double MEDIUM = 6.9;
    private static final Double LOW = 3.9;
    private static final Double NONE = 0.0;
    private static final Logger LOGGER = LoggerFactory.getLogger(SeverityUtil.class);

    private SeverityUtil() {
    }

    public static Double estimateCvssV2(String severity) {
        switch (severity == null ? "none" : severity.toLowerCase()) {
            case "critical": 
            case "high": {
                return HIGH;
            }
            case "moderate": 
            case "medium": {
                return MEDIUM;
            }
            case "info": 
            case "none": 
            case "informational": {
                return NONE;
            }
        }
        return LOW;
    }

    public static String unscoredToSeveritytext(String severity) {
        switch (Severity.forUnscored(severity)) {
            case CRITICAL: 
            case HIGH: 
            case MEDIUM: 
            case LOW: 
            case INFO: {
                return severity;
            }
        }
        String sevText = "0.0".equals(severity) ? "Unknown" : severity;
        return sevText + " (not recognized; assumed to be critical)";
    }

    public static Double estimatedSortAdjustedCVSSv3(String severity) {
        switch (Severity.forUnscored(severity)) {
            case CRITICAL: {
                return 10.2;
            }
            case HIGH: {
                return 7.0;
            }
            case MEDIUM: {
                return 4.0;
            }
            case LOW: {
                return 0.1;
            }
            case INFO: {
                return 0.0;
            }
        }
        LOGGER.debug("Unrecognized unscored textual severity: {}, assuming critical score as worst-case estimate for sorting", (Object)severity);
        return 10.1;
    }

    public static Double sortAdjustedCVSSv3BaseScore(Double cvssV3BaseScore) {
        if (cvssV3BaseScore.floatValue() >= 9.0f) {
            return cvssV3BaseScore + 1.3;
        }
        return cvssV3BaseScore;
    }

    private static enum Severity {
        CRITICAL,
        ASSUMED_CRITICAL,
        HIGH,
        MEDIUM,
        LOW,
        INFO;


        public static Severity forUnscored(String value) {
            switch (value == null ? "none" : value.toLowerCase()) {
                case "critical": {
                    return CRITICAL;
                }
                case "high": {
                    return HIGH;
                }
                case "moderate": 
                case "medium": {
                    return MEDIUM;
                }
                case "info": 
                case "informational": {
                    return INFO;
                }
                case "low": 
                case "unknown": 
                case "none": {
                    return LOW;
                }
            }
            return ASSUMED_CRITICAL;
        }
    }
}

