/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.packager.rpm.build;

import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.bouncycastle.util.encoders.Hex;
import org.eclipse.packager.rpm.RpmTag;
import org.eclipse.packager.rpm.build.DigestAlgorithm;
import org.eclipse.packager.rpm.build.PayloadProcessor;
import org.eclipse.packager.rpm.header.Header;

public class PayloadProcessors {
    private PayloadProcessors() {
    }

    public static PayloadProcessor payloadDigest(final DigestAlgorithm algorithm) throws NoSuchAlgorithmException {
        final MessageDigest digestRaw = algorithm.createDigest();
        final MessageDigest digestCompressed = algorithm.createDigest();
        return new PayloadProcessor(){

            @Override
            public void feedRawPayloadData(ByteBuffer data) {
                digestRaw.update(data);
            }

            @Override
            public void feedCompressedPayloadData(ByteBuffer data) {
                digestCompressed.update(data);
            }

            @Override
            public void finish(Header<RpmTag> header) {
                String raw = Hex.toHexString((byte[])digestRaw.digest());
                String compressed = Hex.toHexString((byte[])digestCompressed.digest());
                header.putStringArray(RpmTag.PAYLOAD_DIGEST, compressed);
                header.putStringArray(RpmTag.PAYLOAD_DIGEST_ALT, raw);
                header.putInt(RpmTag.PAYLOAD_DIGEST_ALGO, algorithm.getTag());
            }
        };
    }
}

