#!/usr/bin/env python

import re
from module import FStealerModule

class MysqlModule(FStealerModule):
	suffixes = [
				"mysql/my.cnf",
				]

	def initialize(self):
		self.pathpattern = re.compile("((/[a-zA-Z0-9_\.]+)*/etc)")

	def preGetFile(self, path):
		match = self.pathpattern.match(path)
		if match is not None:
			for suffix in self.suffixes:
				for p in match.groups():
					self.addPath("%s/%s"%(p,suffix), priority = 1)

module = MysqlModule
