#!/usr/bin/perl
use IO::Socket::INET;
use Getopt::Long qw(GetOptions);
use POSIX qw(setsid strftime);
use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;
#use Net::DNS;
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;

# ------- global variables declaration ----------------
my $Address_alive="";
my $Results = "";


my $p=Net::Ping->new("icmp");

#-------- GUI creation --------------------------------

my $subweb_mw = MainWindow->new(
						-title => 'IP Subnet DNS Resolver');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
		
$file_mb->command(
		-label=>'Launch DNS Resolver analyze',
		-command => sub{&DNSRESOLVER}
		);

$file_mb->command(
			-label=>"Save scan results",
			-command => sub {&SAVERESULTS}
			);
			
$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
		

#-------------DEFAULT WIDTH 79 --------------
my $FrameTOP = $subweb_mw -> Frame ();
$FrameTOP->Label(
	-text => 'Subnet to workout (192.168.1.0/24):'
	)->pack(-side => 'left');
my $TextLabel = $FrameTOP -> Entry(
	-textvariable => \$SubnetToScan
	)->pack(-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');

#-------------
my $FrameMIDDLE4 = $subweb_mw -> Frame (-width => 40, -height => 20);

$TextWidget = $FrameMIDDLE4->Text(); 
$TextWidget->configure(-height => 20);
my $scrollbar = $FrameMIDDLE4 ->Scrollbar(-command => ['yview', $TextWidget]);

$TextWidget->configure(-yscrollcommand => ['set', $scrollbar]);
$TextWidget->pack(-side => 'left', -fill => 'both', -expand => 1);

$scrollbar->pack(-side => 'right', -fill => 'y');

$FrameMIDDLE4 -> pack (-side => 'top', -anchor => 'w');
#-------------


#------------ LAUNCHING THE MAIN LOOP --------
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------


sub DNSRESOLVER
{
	$Results = "";
	
	#---- Creating a table with all the IP adresses -------
	my $sn = Net::Subnets->new;
   	my ( $lowipref, $highipref ) = $sn->range( \$SubnetToScan );
    my $lowIP = $$lowipref;
	my $highIP = $$highipref;
	my $listref = $sn->list( \( $lowIP, $highIP ) );

	$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
	$TextWidget->insert ("end","Starting DNS resolution\n");	
	$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
	$TextWidget->update();

	foreach my $scan_address ( @{ $listref } ) 
	{
		if ($p->ping($scan_address)) 
		{
			my $Name = gethostbyaddr(inet_aton($scan_address), AF_INET);# or die "Can't resolve $scan_address: $!\n";
            $TextWidget->insert ("end","$scan_address: $Name\n");
            $TextWidget->update();
   			$Results = $Results."$scan_address: $Name\n";
		}
#		else
#		{
#			$TextWidget->insert ("end","$scan_address: Not responding to ping\n");
#		}
		$TextWidget->update();
		$TextWidget  -> see ('end');		
	}
	$TextWidget->insert ("end","-------------------------------------------------------------------------------\n");
	$TextWidget->insert ("end","End of DNS resolution\n");	
	$TextWidget->insert ("end","-------------------------------------------------------------------------------\n"); 
	$TextWidget->update();
	$TextWidget  -> see ('end');	
	$Results = $Results."-------------------------------------------------------------------------------\n";
	$Results = $Results."End of DNS resolution\n";
	$Results = $Results."-------------------------------------------------------------------------------\n";		
}

sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}	
