# perl
# --------------------------------------------------------
# LICENCE
# This software is under GNU GENERAL PUBLIC LICENSE
# The detail could be found in the file LICENCE include
# in the same directory than isme.pl
# --------------------------------------------------------

use LWP::UserAgent; # http://search.cpan.org/~gaas/libwww-perl-6.03/lib/LWP/UserAgent.pm
use HTTP::Request::Common; #http://search.cpan.org/~gaas/HTTP-Message-6.02/lib/HTTP/Request/Common.pm
use Net::Ping; # http://search.cpan.org/~smpeters/Net-Ping-2.36/lib/Net/Ping.pm
use Net::Netmask; # http://search.cpan.org/dist/Net-Netmask/
use Net::Subnets;
use Tk; # http://search.cpan.org/~srezic/Tk/pod/UserGuide.pod
use Tk::Radiobutton;
use Tk::PNG;

#----------------------------------------------------------
# SUB FUNCTIONS LIST:
#----------------------------------------------------------
# 
# sub WEB_SELECTSCANFILE
#----------------------------------------------------------


# Variable for web brute forcer
my $Web_ScanToBruteForce = "";
my $WebScanType = "scan";
my $Web_ipaddress = "";
my $Results = "";
my $Subnet_to_scan = "";

# Declaring functions for network analyzing stuff. Thus no argument passing for function. Its all full available variable.
$p=Net::Ping->new("icmp");

my $subweb_mw = MainWindow->new(
						-title => 'Test default SNOM Login/Password');

my $menu_bar = $subweb_mw->Frame(
				-relief => 'groove',
				-borderwidth => 3,
				-width => 40,
				)-> pack(
					-side=>'top',
					-fill => 'x'
					);
my $file_mb = $menu_bar->Menubutton(
				-text => 'File',
				)->pack(-side=>'left');
	
$file_mb->command(
		-label=>'Select subnet scan to load',
		-command => sub {&WEB_SELECTSCANFILE}
		);
		
$file_mb->command(
		-label=>'Launch brute force attack',
		-command => 
			sub 
			{
				if ($WebScanType =~ /single/)
				{
					&WEBBRUTEFORCESINGLE;	
				}
				elsif ($WebScanType =~ /scan/)
				{
					&WEBBRUTEFORCESCAN;
				}
				elsif ($WebScanType =~ /subnet/)
				{
					&WEBBRUTEFORCEFULLSUBNET;
				}
			}
		);

$file_mb->command(
			-label=>"Save scan results",
			-command => sub {&SAVERESULTS}
			);

$file_mb->command(
	-label=>'Exit',
	-command => [$subweb_mw => 'destroy']
	);
		

#----------
my $FrameTOP = $subweb_mw -> Frame ();
my $rdb_scan = $FrameTOP  -> Radiobutton(-text=>"IP Phone from scanned subnet",
												-value=>"scan",
												-variable=>\$WebScanType);
$rdb_scan -> pack (-side => 'left');
$FrameTOP -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE1 = $subweb_mw -> Frame ();

$FrameMIDDLE1->Label(
	-text => 'Selected scan file (.isme):'
	)->pack(-side => 'left');
my $TextLabel = $FrameMIDDLE1 -> Entry(
	-textvariable => \$Web_ScanToBruteForce,
	- width => 59,
	)->pack(-side => 'left');
$FrameMIDDLE1 -> pack (-side => 'top', -anchor => 'w');

#----------	
my $FrameMIDDLE2 = $subweb_mw -> Frame ();
my $rdb_single = $FrameMIDDLE2 -> Radiobutton(-text=>"Single IP Phone",  
												-value=>"single",  
												-variable=>\$WebScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE2 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE3 = $subweb_mw -> Frame ();
$FrameMIDDLE3->Label(
	-text => 'IP address to scan (192.168.0.154):'
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE3 -> Entry(
	-textvariable => \$Web_ipaddress,
	- width => 51,
	)->pack(-side => 'left');
$FrameMIDDLE3 -> pack (-side => 'top', -anchor => 'w');
#-------------
my $FrameMIDDLE5 = $subweb_mw -> Frame ();
my $rdb_single = $FrameMIDDLE5 -> Radiobutton(-text=>"Scan a subnet",  
												-value=>"subnet",  
												-variable=>\$WebScanType);
$rdb_single -> pack (-side => 'left');
$FrameMIDDLE5 -> pack (-side => 'top', -anchor => 'w');
#----------	
my $FrameMIDDLE7 = $subweb_mw -> Frame ();
$FrameMIDDLE7->Label(
	-text => 'Subnet to scan (192.168.0.0/24):    '
	)->pack(-side => 'left');
my $TextLabel_single = $FrameMIDDLE7 -> Entry(
	-textvariable => \$Subnet_to_scan,
	- width => 51,
	)->pack(-side => 'left');
$FrameMIDDLE7 -> pack (-side => 'top', -anchor => 'w');

#-------------
my $FrameMIDDLE6 = $subweb_mw -> Frame (-width => 40, -height => 20);

my $TextWidget = $FrameMIDDLE6  -> Text(); 
$TextWidget->configure(-height => 20);
my $scrollbar = $FrameMIDDLE6 ->Scrollbar(-command => ['yview', $TextWidget]);
$TextWidget->configure(-yscrollcommand => ['set', $scrollbar]);

$TextWidget->pack(-side => 'left', -fill => 'both', -expand => 1);
$scrollbar->pack(-side => 'right', -fill => 'y');
$FrameMIDDLE6 -> pack (-side => 'top', -anchor => 'w');



#------------ LAUNCHING THE MAIN LOOP --------
MainLoop;
#------------ END OF THE GUI INTERFACE DEFINITION STUFF -------------------------------------


sub WEB_SELECTSCANFILE
{
                              
	my $types = [ ['isme files', '.isme']];
	my $Web_SelectScan = $subweb_mw->getOpenFile(-filetypes => $types,
	                         	  -defaultextension => '.isme',
	                              -initialdir => "scan_history"
	                              );  
	$Web_ScanToBruteForce = $Web_SelectScan;
	$TextLabel->update();
	 
}

sub WEBBRUTEFORCESINGLE
{
	$Results = "";
	
	if ($Web_ipaddress =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}/)
    {
		$TextWidget -> delete('0.0', 'end');
		$TextWidget -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget -> insert("end", "Starting to test $Web_ipaddress for default SNOM Login/Password.\n");
		$TextWidget -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
				
		$Results = $Results."-------------------------------------------------------------------------------\n";
		$Results = $Results."Starting to test $Web_ipaddress for default SNOM Login/Password.\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";
		
		my $url_SNOMPhone = "https://".$Web_ipaddress;

		my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 0 });
		my $request = HTTP::Request->new(GET => $url_SNOMPhone);
		my $answer0=$ua->request($request);	
		my $content0 = $answer0->content();
		
		#Welcome to Your Phone
	    if ($content0 =~ /Welcome/)
	    {
	    	$TextWidget -> insert ("end","$Web_ipaddress: No login/password set to access the web interface - WARNING\n");
	    	$Results = $Results."$Web_ipaddress: No login/password set to access the web interface - WARNING\n";
	    }
	    else
	    {
		    
			$request->authorization_basic('administrator', '0000');# Default SNOM login: administrator default password: 0000				
			my $answer=$ua->request($request);
			my $content = $answer->content();
	
			$request->authorization_basic('admin', '0000');# Default SNOM login: administrator default password: 0000							
			my $answer2=$ua->request($request);
			my $content2 = $answer2->content();
	
			$request->authorization_basic('admin', 'admin');# Default SNOM login: administrator default password: 0000							
			my $answer3=$ua->request($request);
			my $content3 = $answer3->content();
	
			$request->authorization_basic('', '0000');# Default SNOM login: administrator default password: 0000							
			my $answer4=$ua->request($request);
			my $content4 = $answer4->content();
	
	
		    if ($content =~ /HTTP 401 Unauthorized/)
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test administrator/0000 - not used\n");
				$Results = $Results."$Web_ipaddress: test administrator/0000 - not used\n";
		    }
			elsif ($content =~ /Welcome/)
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test administrator/0000 - WARNING => used\n");
		    	$Results = $Results."$Web_ipaddress: test administrator/0000 - WARNING => used\n";
		    }	
		    else #all the other cases.
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test administrator/0000 - not used\n");
		    	$Results = $Results."$Web_ipaddress: test administrator/0000 - not used\n";
		    }
						    
						    					    				    
		    if ($content2 =~ /HTTP 401 Unauthorized/)
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test admin/0000 - not used\n");
		    	$Results = $Results."";
		    }
			elsif ($content2 =~ /Welcome/)
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test admin/0000 - WARNING => used\n");
		    	$Results = $Results."$Web_ipaddress: test admin/0000 - not used\n";
		    }
		    else #all the other cases.
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test admin/0000 - not used\n");
		    	$Results = $Results."$Web_ipaddress: test admin/0000 - not used\n";
		    }					    
						    
						    						    
		    if ($content3 =~ /HTTP 401 Unauthorized/)
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test admin/admin - not used\n");
		    	$Results = $Results."$Web_ipaddress: test admin/admin - not used\n";
		    }
			elsif ($content3 =~ /Welcome/)
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test admin/admin - WARNING => used\n");
		    	$Results = $Results."";
		    }
		    else #all the other cases.
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress: test admin/admin - not used\n");
		    	$Results = $Results."$Web_ipaddress: test admin/admin - WARNING => used\n";
		    }					    
	
		    if ($content4 =~ /HTTP 401 Unauthorized/)
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress:  /0000 - not used\n");
		    	$Results = $Results."";
		    }
			elsif ($content4 =~ /Welcome/)
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress:   /0000 - WARNING => used\n");
		    	$Results = $Results."$Web_ipaddress:  /0000 - not used\n";
		    }						    						    
		    else #all the other cases.
		    {
		    	$TextWidget -> insert ("end","$Web_ipaddress:  /0000 - not used\n");
		    	$Results = $Results."$Web_ipaddress:  /0000 - not used\n";
		    }
	    }
   		$TextWidget -> insert ("end", "\n");					    
   		$TextWidget -> insert ("end", "------------------------ END --------------------------------------------------\n");
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');   		
   		$Results = $Results."\n";
   		$Results = $Results."------------------------ END --------------------------------------------------\n";					    

    } 
    else
	{
    	$subweb_mw->Dialog(-title => 'WARNING', 	
					-text => 'Bad IP address syntax !',
					)->Show( );		
    }   	
}

sub WEBBRUTEFORCESCAN
{
	$Results = "";
	$counter = 0;
	
	if (open (FILE, "$Web_ScanToBruteForce"))
	{
		
		$TextWidget -> delete ('0.0', 'end');
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget -> insert ("end", "Starting to test detected IP Phones for default SNOM Login/Password.\n");
		$TextWidget -> insert ("end", "File loaded: $Web_ScanToBruteForce\n");
		$TextWidget -> insert ("end", "-------------------------------------------------------------------------------\n");
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."-------------------------------------------------------------------------------\n";
		$Results = $Results."Starting to test detected IP Phones for default SNOM Login/Password.\n";
		$Results = $Results."File loaded: $Web_ScanToBruteForce\n";
		$Results = $Results."-------------------------------------------------------------------------------\n";


				
		while (<FILE>)
		{
			my $LineToAnalyze=$_;
			my $ToFind = "IP adresse:";
			my $ToFindBis = "Web server available";
			my $loc = 0;
			my $locbis=0;

			$TextWidget -> insert ("end","------- Analyzing line $counter\n");
			$Results = $Results."------- Analyzing line $counter\n";	
			$TextWidget  -> update ();	
			$TextWidget  -> see ('end');			
			
			$loc = index($LineToAnalyze, $ToFind); # if $loc = -1 the string is not found.
			$locbis = index($LineToAnalyze, $ToFindBis); # if $loc = -1 the string is not found.			
			
			if ($loc >= 0)
			{
				if ($locbis >= 0)# if there is not a web server, no interest in testing it.
				{
					my @splitAnalyze= split (/[*]/, $LineToAnalyze);
					my $loc2 = 0;
					$loc2 = index(@splitAnalyze[0], $ToFind); # if $loc = -1 the string is not found.
					{
						#if we are there, we need to scan the IP address (not a cisco IP Phone for sure). Let fetch it in the file.
						my @splitIP= split (/[ ]/, @splitAnalyze[0]);
						
						#IP address should be in @splitIP[1];
						my $url_SNOMPhone = "http://".@splitIP[2];

				    	$TextWidget -> insert ("end","   ----- Testing @splitIP[2]\n");
						$Results = $Results."   ----- Testing @splitIP[2]\n";						
						
						# Let's test the IP Phone for real now.
						my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 0 });
						$ua->timeout(3);	
						my $request = HTTP::Request->new(GET => $url_SNOMPhone);
						my $answer0=$ua->request($request);
						my $content0 = $answer0->content();

						$request->authorization_basic('administrator', '0000');# Default SNOM login: administrator default password: 0000				
						my $answer=$ua->request($request);
						my $content = $answer->content();

						$request->authorization_basic('admin', '0000');# Default SNOM login: administrator default password: 0000							
						my $answer2=$ua->request($request);
						my $content2 = $answer2->content();

						$request->authorization_basic('admin', 'admin');# Default SNOM login: administrator default password: 0000							
						my $answer3=$ua->request($request);
						my $content3 = $answer3->content();

						$request->authorization_basic('', '0000');# Default SNOM login: administrator default password: 0000							
						my $answer4=$ua->request($request);
						my $content4 = $answer4->content();

						if ($content0 =~ /Welcome/)
					    {
					    	$TextWidget -> insert ("end","@splitIP[2]: No login/password set to access the web interface - WARNING\n");
					    	$Results = $Results."@splitIP[2]: No login/password set to access the web interface - WARNING\n";
					    }
					    else
					    {
						    if ($content =~ /HTTP 401 Unauthorized/)
						    {
#						    	$TextWidget -> insert ("end","@splitIP[2]: test administrator/0000 - not used\n");
#						    	$Results = $Results."@splitIP[2]: test administrator/0000 - not used\n";
						    }
							elsif ($content =~ /snom/)
						    {
						    	$TextWidget -> insert ("end","@splitIP[2]: test administrator/0000 - WARNING => used\n");
						    	$Results = $Results."@splitIP[2]: test administrator/0000 - WARNING => used\n";
						    }	
						    else #all the other cases.
						    {
#						    	$TextWidget -> insert ("end","@splitIP[2]: test administrator/0000 - not used\n");
#						    	$Results = $Results."@splitIP[2]: test administrator/0000 - not used\n";
						    }
						    
						    					    				    
						    if ($content2 =~ /HTTP 401 Unauthorized/)
						    {
#						    	$TextWidget -> insert ("end","@splitIP[2]: test admin/0000 - not used\n");
#						    	$Results = $Results."@splitIP[2]: test admin/0000 - not used\n";
						    }
							elsif ($content2 =~ /snom/)
						    {
						    	$TextWidget -> insert ("end","@splitIP[2]: test admin/0000 - WARNING => used\n");
						    	$Results = $Results."@splitIP[2]: test admin/0000 - WARNING => used\n";
						    }
						    else #all the other cases.
						    {
#						    	$TextWidget -> insert ("end","@splitIP[2]: test admin/0000 - not used\n");
#						    	$Results = $Results."@splitIP[2]: test admin/0000 - not used\n";
						    }					    
						    
						    						    
						    if ($content3 =~ /HTTP 401 Unauthorized/)
						    {
#						    	$TextWidget -> insert ("end","@splitIP[2]: test admin/admin - not used\n");
#						    	$Results = $Results."@splitIP[2]: test admin/admin - not used\n";
						    }
							elsif ($content3 =~ /snom/)
						    {
						    	$TextWidget -> insert ("end","@splitIP[2]: test admin/admin - WARNING => used\n");
						    	$Results = $Results."@splitIP[2]: test admin/admin - WARNING => used\n";
						    }
						    else #all the other cases.
						    {
#						    	$TextWidget -> insert ("end","@splitIP[2]: test admin/admin - not used\n");
#						    	$Results = $Results."@splitIP[2]: test admin/admin - not used\n";
						    }					    
	
						    if ($content4 =~ /HTTP 401 Unauthorized/)
						    {
#						    	$TextWidget -> insert ("end","@splitIP[2]:  /0000 - not used\n");
#						    	$Results = $Results."@splitIP[2]:  /0000 - not used\n";
						    }
							elsif ($content4 =~ /snom/)
						    {
						    	$TextWidget -> insert ("end","@splitIP[2]:   /0000 - WARNING => used\n");
						    	$Results = $Results."@splitIP[2]:   /0000 - WARNING => used\n";
						    }						    						    
						    else #all the other cases.
						    {
#						    	$TextWidget -> insert ("end","@splitIP[2]:  /0000 - not used\n");
#						    	$Results = $Results."@splitIP[2]:  /0000 - not used\n";
						    }					    
						}
					}
				}
			}
			$counter=$counter+1;
		}
		$TextWidget -> insert ("end", "------------------------ END --------------------------------------------------\n");	
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		close (FILE);
		$Results = $Results."\n";
		$Results = $Results."------------------------ END --------------------------------------------------\n";  	
	}
	else
	{
    	$subweb_mw->Dialog(-title => 'WARNING', 	
					-text => 'Unable to open selected file. The scan won\'t be launch',
					)->Show( );		
	}
	
}

sub WEBBRUTEFORCEFULLSUBNET
{
	$Results = "";
	
	if ($Subnet_to_scan =~ /[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}.[0-9]{1,3}\/[0-9]{1,2}/)
	{
		$TextWidget -> delete('0.0', 'end');
		$TextWidget -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget -> insert("end", "Starting to test $Subnet_to_scan for default Aastra Login/Password\n");
		$TextWidget -> insert("end", "-------------------------------------------------------------------------------\n");
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
    	$Results = $Results."-------------------------------------------------------------------------------\n";
    	$Results = $Results."Starting to test $Subnet_to_scan for default Aastra Login/Password\n";
    	$Results = $Results."-------------------------------------------------------------------------------\n";

		#---- Creating a table with all the IP adresses -------
		my $sn = Net::Subnets->new;
	   	my ( $lowipref, $highipref ) = $sn->range( \$Subnet_to_scan );
	    my $lowIP = $$lowipref;
		my $highIP = $$highipref;
		my $listref = $sn->list( \( $lowIP, $highIP ) );

		foreach my $scan_address ( @{ $listref } ) 
		{
			if ($p->ping($scan_address))
		    {
		    	$TextWidget -> insert ("end","------- Testing $scan_address\n");
				$Results = $Results."------- Testing $scan_address\n";
	

				my $url_SNOMPhone = "https://".$scan_address;
		
				my $ua = LWP::UserAgent->new(ssl_opts => { verify_hostname => 0 });
				my $request = HTTP::Request->new(GET => $url_SNOMPhone);
				my $answer0=$ua->request($request);	
				my $content0 = $answer0->content();
				
				#Welcome to Your Phone
			    if ($content0 =~ /Welcome/)
			    {
			    	$TextWidget -> insert ("end","$scan_address: No login/password set to access the web interface - WARNING\n");
			    	$TextWidget  -> update ();	
					$TextWidget  -> see ('end');
					$Results = $Results."";
			    }
			    else
			    {
				    
					$request->authorization_basic('administrator', '0000');# Default SNOM login: administrator default password: 0000				
					my $answer=$ua->request($request);
					my $content = $answer->content();
			
					$request->authorization_basic('admin', '0000');# Default SNOM login: administrator default password: 0000							
					my $answer2=$ua->request($request);
					my $content2 = $answer2->content();
			
					$request->authorization_basic('admin', 'admin');# Default SNOM login: administrator default password: 0000							
					my $answer3=$ua->request($request);
					my $content3 = $answer3->content();
			
					$request->authorization_basic('', '0000');# Default SNOM login: administrator default password: 0000							
					my $answer4=$ua->request($request);
					my $content4 = $answer4->content();
			
			
				    if ($content =~ /HTTP 401 Unauthorized/)
				    {
#				    	$TextWidget -> insert ("end","$scan_address: test administrator/0000 - not used\n");
#				    	$Results = $Results."$scan_address: test administrator/0000 - not used\n";
				    }
					elsif ($content =~ /Welcome/)
				    {
				    	$TextWidget -> insert ("end","$scan_address: test administrator/0000 - WARNING => used\n");
				    	$Results = $Results."$scan_address: test administrator/0000 - WARNING => used\n";
				    }	
				    else #all the other cases.
				    {
#				    	$TextWidget -> insert ("end","$scan_address: test administrator/0000 - not used\n");
#				    	$Results = $Results."$scan_address: test administrator/0000 - not used\n";
				    }
								    
								    					    				    
				    if ($content2 =~ /HTTP 401 Unauthorized/)
				    {
#				    	$TextWidget -> insert ("end","$scan_address: test admin/0000 - not used\n");
#				    	$Results = $Results."$scan_address: test admin/0000 - not used\n";
				    }
					elsif ($content2 =~ /Welcome/)
				    {
				    	$TextWidget -> insert ("end","$scan_address: test admin/0000 - WARNING => used\n");
				    	$Results = $Results."$scan_address: test admin/0000 - WARNING => used\n";
				    }
				    else #all the other cases.
				    {
#				    	$TextWidget -> insert ("end","$scan_address: test admin/0000 - not used\n");
#				    	$Results = $Results."$scan_address: test admin/0000 - not used\n";
				    }					    
								    
								    						    
				    if ($content3 =~ /HTTP 401 Unauthorized/)
				    {
#				    	$TextWidget -> insert ("end","$scan_address: test admin/admin - not used\n");
#				    	$Results = $Results."$scan_address: test admin/admin - not used\n";
				    }
					elsif ($content3 =~ /Welcome/)
				    {
				    	$TextWidget -> insert ("end","$scan_address: test admin/admin - WARNING => used\n");
				    	$Results = $Results."$scan_address: test admin/admin - WARNING => used\n";
				    }
				    else #all the other cases.
				    {
#				    	$TextWidget -> insert ("end","$scan_address: test admin/admin - not used\n");
#				    	$Results = $Results."$scan_address: test admin/admin - not used\n";
				    }					    
			
				    if ($content4 =~ /HTTP 401 Unauthorized/)
				    {
#				    	$TextWidget -> insert ("end","$scan_address:  /0000 - not used\n");
#				    	$Results = $Results."$scan_address:  /0000 - not used\n";
				    }
					elsif ($content4 =~ /Welcome/)
				    {
				    	$TextWidget -> insert ("end","$scan_address:   /0000 - WARNING => used\n");
				    	$Results = $Results."$scan_address:   /0000 - WARNING => used\n";
				    }						    						    
				    else #all the other cases.
				    {
#				    	$TextWidget -> insert ("end","$scan_address:  /0000 - not used\n");
#				    	$Results = $Results."$scan_address:  /0000 - not used\n";
				    }
			    }

		    }
			else
			{
			   	$TextWidget -> insert ("end","------- Testing $scan_address\n");
			   	$Results = $Results."------- Testing $scan_address\n";
			}
   			$TextWidget  -> update ();	
			$TextWidget  -> see ('end'); 
		}
   		$TextWidget -> insert ("end", "\n");					    
   		$TextWidget -> insert ("end", "------------------------ END --------------------------------------------------\n");					    
		$TextWidget  -> update ();	
		$TextWidget  -> see ('end');
		$Results = $Results."\n";
		$Results = $Results."------------------------ END --------------------------------------------------\n";  	
	}
    else
	{
    	$subweb_mw->Dialog(-title => 'WARNING', 	
					-text => 'Bad subnet syntax !',
					)->Show( );		
    }
}





sub SAVERESULTS
{
	my $FileToSave = $subweb_mw->getSaveFile(
							-defaultextension => '.txt',
                            -initialdir => "user_data"
                              );

	open (TOSAVE, ">>$FileToSave");
	print TOSAVE $Results;
	close (TOSAVE);
	
}	
