from Malcom.model.datatypes import Hostname
from Malcom.feeds.core import Feed
import Malcom.auxiliary.toolbox as toolbox

import datetime
import md5


class MalwareDomainsDotCom(Feed):
    """
    This is a feed that will fetch data from a URL and process it
    """
    def __init__(self):
        super(MalwareDomainsDotCom, self).__init__(run_every="1h")
        self.source = "http://mirror1.malwaredomains.com/files/domains.txt"
        self.description = "Malwaredomains.com Blacklist"

    def update(self):

        for line in self.update_lines():
            self.analyze(line)

    def analyze(self, line):

        line = line.strip()
        sline = line.split()
        try:
            if line[0] != '#' and len(sline) > 2:       # ignore comments and entries with no clear reference
                if sline[0].isdigit():
                    del sline[0]                        # remove the useless first field

                _hostname = Hostname(hostname=sline[0])

                evil = {}
                evil['source'] = self.name
                evil['id'] = md5.new(sline[0] + sline[1]).hexdigest()
                evil['description'] = sline[1]              # malware, EK, etc
                evil['reference'] = sline[2]                # GG safe browsing, blog, other blacklist, etc...

                if sline[3]:                                # add the last date of inclusion in the feed
                    if sline[3] == 'relisted' and sline[4]:
                        evil['date_added'] = datetime.datetime.strptime(sline[4], "%Y%m%d")
                    else:
                        evil['date_added'] = datetime.datetime.strptime(sline[3], "%Y%m%d")

                _hostname.add_evil(evil)
                _hostname.seen(first=evil['date_added'])
                self.commit_to_db(_hostname)
        except Exception, e:
            toolbox.debug_output(str(e), type='error')
