/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.PropertyDescriptorCollection;
import java.awt.Color;
import java.util.prefs.Preferences;
import org.openide.util.Lookup;
import org.openide.util.NbPreferences;

public abstract class LinkPresenter {
    private static LinkPresenter _default;

    public static synchronized LinkPresenter getDefault() {
        if (_default == null && (_default = (LinkPresenter)Lookup.getDefault().lookup(LinkPresenter.class)) == null) {
            _default = new DefaultLinkPresenter();
        }
        return _default;
    }

    public abstract int getStyle(MaltegoLink var1);

    public abstract int getThickness(MaltegoLink var1);

    public abstract Color getColor(MaltegoLink var1);

    public static class DefaultLinkPresenter
    extends LinkPresenter {
        private static final String PREF_PROPS_FOR_APPEARANCE = "propertiesCanChangeLinkAppearance";
        private Preferences _prefs = NbPreferences.forModule(LinkPresenter.class);

        @Override
        public int getStyle(MaltegoLink link) {
            Integer style = link.getStyle();
            return style != null && style >= 0 ? style : 0;
        }

        @Override
        public int getThickness(MaltegoLink link) {
            Integer thickness = link.getThickness();
            if (thickness != null && thickness >= 0) {
                return thickness;
            }
            return MaltegoLinkSpec.getManualSpec().getTypeName().equals(link.getTypeName()) ? 2 : 1;
        }

        @Override
        public Color getColor(MaltegoLink link) {
            MaltegoLinkSpec spec;
            Color color = link.getColor();
            if (color == null && this._prefs.getBoolean(PREF_PROPS_FOR_APPEARANCE, true)) {
                color = this.getSearchEngineColor(link);
            }
            if (color == null && (spec = (MaltegoLinkSpec)LinkRegistry.getDefault().get(link.getTypeName())) != null) {
                boolean isManualLink = spec.equals((Object)MaltegoLinkSpec.getManualSpec());
                color = isManualLink ? MaltegoLinkSpec.getDefaultManualLinkColor() : MaltegoLinkSpec.getDefaultTransformLinkColor();
            }
            return color != null ? color : Color.BLACK;
        }

        private Color getSearchEngineColor(MaltegoLink link) {
            PropertyDescriptor weightPd;
            Object transformType;
            Color color = null;
            PropertyDescriptorCollection properties = link.getProperties();
            PropertyDescriptor transformTypePd = properties.get("maltego.transform.type");
            if (transformTypePd != null && "SE".equals(transformType = link.getValue(transformTypePd)) && (weightPd = properties.get("maltego.link.weight")) != null) {
                Object weightObj = link.getValue(weightPd);
                int weight = -1;
                if (weightObj instanceof Number) {
                    weight = ((Number)weightObj).intValue();
                } else if (weightObj instanceof String) {
                    try {
                        weight = Integer.decode((String)weightObj);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (weight != -1) {
                    color = this.getLinkColorFromWeight(weight);
                }
            }
            return color;
        }

        private Color getLinkColorFromWeight(int w) {
            if (w >= 100) {
                w = 100;
            }
            if (w <= 0) {
                w = 0;
            }
            int color = 25 + (int)Math.round((double)w * 1.75);
            color = Math.abs(255 - color);
            return new Color(color, color, color);
        }
    }
}

