/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.ui.graph.view2d;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.graph.selection.GraphSelection;
import com.paterva.maltego.graph.wrapper.GraphIDProvider;
import com.paterva.maltego.graph.wrapper.GraphWrapper;
import com.paterva.maltego.graph.wrapper.MaltegoGraphManager;
import com.paterva.maltego.ui.graph.actions.NodeEditor;
import com.paterva.maltego.ui.graph.actions.SelectionMode;
import com.paterva.maltego.ui.graph.view2d.BookmarkClickViewMode;
import com.paterva.maltego.ui.graph.view2d.CollectionNodeUtils;
import com.paterva.maltego.ui.graph.view2d.EditableNodeLabel;
import com.paterva.maltego.ui.graph.view2d.HitInfoCache;
import com.paterva.maltego.ui.graph.view2d.MacOSXEditMode;
import com.paterva.maltego.ui.graph.view2d.NodeEditHook;
import com.paterva.maltego.ui.graph.view2d.NotesClickViewMode;
import com.paterva.maltego.ui.graph.view2d.PinClickViewMode;
import com.paterva.maltego.ui.graph.view2d.painter.MainEntityPainter;
import java.awt.Component;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Collection;
import java.util.Collections;
import java.util.EventObject;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.openide.util.Utilities;
import yguard.A.A.D;
import yguard.A.A.H;
import yguard.A.A.Y;
import yguard.A.I.M;
import yguard.A.J.BA;
import yguard.A.J.MC;
import yguard.A.J.SA;
import yguard.A.J.U;
import yguard.A.J.X;
import yguard.A.J.gB;

public class PopupAwareEditMode
extends MacOSXEditMode {
    private static final Logger LOG = Logger.getLogger(PopupAwareEditMode.class.getName());
    private final BookmarkClickViewMode _bookmarkClickViewMode = new BookmarkClickViewMode();
    private final NotesClickViewMode _notesClickViewMode = new NotesClickViewMode();
    private final PinClickViewMode _pinClickViewMode = new PinClickViewMode();

    public PopupAwareEditMode() {
        this.allowNodeCreation(false);
        this.allowBendCreation(false);
        this.allowEdgeCreation(true);
        this.allowMovePorts(false);
        this.allowMoveLabels(false);
        this.allowMovingWithPopup(true);
        this.allowResizeNodes(false);
        this.allowLabelSelection(false);
    }

    public void setActiveView(U activeView) {
        super.setActiveView(activeView);
        activeView.getCanvasComponent().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if ("Zoom".equals(evt.getPropertyName())) {
                    PopupAwareEditMode.this.checkEditNode();
                }
            }
        });
    }

    protected void setSelected(SA graph, Y node, boolean state) {
        GraphID graphID = GraphIDProvider.forGraph((SA)graph);
        GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        selection.setViewEntitiesSelected(Collections.singleton(wrapper.entityID(node)), state);
    }

    protected void unselectAll(SA graph) {
        GraphID graphID = GraphIDProvider.forGraph((SA)graph);
        GraphSelection selection = GraphSelection.forGraph((GraphID)graphID);
        selection.clearSelection();
    }

    public void mouseMoved(double x2, double y2) {
        if (!(this._bookmarkClickViewMode.isOverLabel(this.view, x2, y2) || this._notesClickViewMode.isOverLabel(this.view, x2, y2) || this._pinClickViewMode.isOverLabel(this.view, x2, y2))) {
            super.mouseMoved(x2, y2);
        }
        this.checkEditNode();
    }

    private void checkEditNode() {
        Y node;
        MC hit = this.getLastHitInfo();
        if (hit != null && (node = hit.V()) != null && this.isEditSwingGesture(node, this.lastPressEvent, this.lastReleaseEvent, this.lastClickEvent)) {
            this.editSwing(node, this.lastMoveEvent);
        }
    }

    public void mousePressedLeft(double x2, double y2) {
        if (this._bookmarkClickViewMode.isOverLabel(this.view, x2, y2)) {
            this.setChild(this._bookmarkClickViewMode, this.lastPressEvent, null);
        } else if (this._notesClickViewMode.isOverLabel(this.view, x2, y2)) {
            this.setChild(this._notesClickViewMode, this.lastPressEvent, null);
        } else if (this._pinClickViewMode.isOverLabel(this.view, x2, y2)) {
            this.setChild(this._pinClickViewMode, this.lastPressEvent, null);
        } else {
            super.mousePressedLeft(x2, y2);
        }
    }

    public MouseEvent processModifierLeftMouseButtonClicked(MouseEvent e2) {
        if (Utilities.isMac()) {
            int onMask1 = 1344;
            if (e2.getClickCount() == 1 && (e2.getModifiersEx() & onMask1) == onMask1) {
                return new MouseEvent((Component)e2.getSource(), e2.getID(), e2.getWhen(), 1024, e2.getX(), e2.getY(), 707, false, 1);
            }
            onMask1 = 1280;
            int onMask2 = 256;
            if (e2.getClickCount() == 1 && ((e2.getModifiersEx() & onMask1) == onMask1 || e2.getButton() == 1 && (e2.getModifiersEx() & onMask2) == onMask2)) {
                return new MouseEvent((Component)e2.getSource(), e2.getID(), e2.getWhen(), 1024, e2.getX(), e2.getY(), 717, false, 1);
            }
        }
        return e2;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        H edge;
        MC hitInfo;
        mouseEvent = this.processModifierLeftMouseButtonClicked(mouseEvent);
        super.mouseReleased(mouseEvent);
        if (mouseEvent.getClickCount() == 2 && !mouseEvent.isConsumed() && SwingUtilities.isLeftMouseButton(mouseEvent) && (hitInfo = this.getHitInfo(this.view.toWorldCoordX(mouseEvent.getX()), this.view.toWorldCoordY(mouseEvent.getY()))).X() && (edge = hitInfo.T()) != null) {
            mouseEvent.consume();
            GraphID graphID = GraphIDProvider.forGraph((SA)this.getGraph2D());
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
            LinkID linkID = wrapper.linkID(edge);
            if (linkID != null) {
                NodeEditor.getDefault().edit(graphID, linkID);
            }
        }
    }

    protected void nodeClicked(SA gd, Y node, boolean bln, double d2, double d1, boolean bln1) {
        if (this.canSelectNodes() && node != null && !this.isEditing(gd, node)) {
            super.nodeClicked(gd, node, bln, d2, d1, bln1);
        }
    }

    protected void edgeClicked(SA gd, H edge, boolean bln, double d2, double d1, boolean bln1) {
        if (!this.canSelectNodes()) {
            super.edgeClicked(gd, edge, bln, d2, d1, bln1);
        }
    }

    protected MC getHitInfo(double x2, double y2) {
        MC hInfo = HitInfoCache.getDefault().getStandardHitInfo(this.view, x2, y2);
        this.setLastHitInfo(hInfo);
        return hInfo;
    }

    private boolean canSelectNodes() {
        boolean selectNodes = SelectionMode.isEntities();
        MouseEvent lastClick = this.getLastClickEvent();
        if (lastClick != null && (lastClick.isControlDown() || lastClick.isAltDown())) {
            selectNodes = !selectNodes;
        }
        return selectNodes;
    }

    private MC createNodeOnlyHitInfo(double x2, double y2) {
        return HitInfoCache.getDefault().getOrCreateHitInfo(this.view, x2, y2, true, 19);
    }

    private MC createEdgeOnlyHitInfo(double x2, double y2) {
        return HitInfoCache.getDefault().getOrCreateHitInfo(this.view, x2, y2, true, 35);
    }

    public void mousePressed(MouseEvent e2) {
        MouseEvent e1 = this.processModifierLeftMouseButtonClicked(e2);
        if (SwingUtilities.isRightMouseButton(e1) && this.getChild() != null) {
            this.getChild().reactivateParent();
        }
        super.mousePressed(e1);
    }

    protected boolean editNode(Y hitNode, EventObject e2) {
        boolean result = false;
        if (e2 instanceof MouseEvent && SwingUtilities.isLeftMouseButton((MouseEvent)e2)) {
            MC hi;
            Y node;
            double worldY;
            MouseEvent evt = (MouseEvent)e2;
            int x2 = evt.getX();
            int y2 = evt.getY();
            double worldX = this.view.toWorldCoordX(x2);
            if (this._bookmarkClickViewMode.isOverLabel(this.view, worldX, worldY = this.view.toWorldCoordY(y2)) || this._notesClickViewMode.isOverLabel(this.view, worldX, worldY) || this._pinClickViewMode.isOverLabel(this.view, worldX, worldY)) {
                result = false;
            }
            if ((node = (hi = this.getLastHitInfo()).V()) != null) {
                gB editLabel = null;
                BA realizer = this.view.getGraph2D().f(node);
                if (this.view.getZoom() >= this.view.getPaintDetailThreshold()) {
                    for (int i = 0; i < realizer.labelCount(); ++i) {
                        gB label = realizer.getLabel(i);
                        if (label == null || !label.isVisible() || !label.getBox().B(worldX, worldY)) continue;
                        editLabel = label;
                        break;
                    }
                }
                if (editLabel instanceof EditableLabel && ((EditableLabel)editLabel).isEditable()) {
                    this.editLabel(editLabel);
                } else {
                    this.editNode(node);
                }
            }
        }
        return result;
    }

    protected boolean isEditNodeGesture(Y hitNode, MouseEvent lastPressEvent, MouseEvent lastReleaseEvent, MouseEvent lastClickEvent) {
        return super.isEditNodeGesture(hitNode, lastPressEvent, lastReleaseEvent, lastClickEvent);
    }

    void editSwing(Y hitNode, EventObject e2) {
        super.editNode(hitNode, e2);
    }

    boolean isEditSwingGesture(Y hitNode, MouseEvent lastPressEvent, MouseEvent lastReleaseEvent, MouseEvent lastClickEvent) {
        U gv = this.view;
        if (MainEntityPainter.isDeepZoom(gv.getZoom())) {
            return PopupAwareEditMode.isSwingNode(gv.getGraph2D(), hitNode) && PopupAwareEditMode.isOverCollectionNodeMinusBanner(hitNode, gv, this.lastMoveEvent);
        }
        return false;
    }

    public static boolean isOverCollectionNodeMinusBanner(Y node, U gv, MouseEvent evt) {
        BA nr = ((SA)node.H()).f(node);
        return nr.contains(gv.toWorldCoordX(evt.getX()), gv.toWorldCoordY(evt.getY()) - 15.0);
    }

    static boolean isSwingNode(SA graph, Y node) {
        return CollectionNodeUtils.isCollectionNode(node);
    }

    private boolean isEditing(SA graph, Y node) {
        return graph.B((Object)"IS_EDITING_DPKEY").getBool((Object)node);
    }

    protected void editLabel(final gB label) {
        PropertyChangeListener pcl = e2 -> {
            this.reactivateParent();
            this.fireEditEvent("nodeEdited", label.getNode());
        };
        ContainerAdapter containerListener = new ContainerAdapter(){

            @Override
            public void componentRemoved(ContainerEvent e2) {
                boolean fireByCollectionNode = CollectionNodeUtils.isFiredByCollectionNode(e2);
                if (!fireByCollectionNode) {
                    SwingUtilities.invokeLater(() -> {
                        PopupAwareEditMode.this.fireEditEvent("labelEditorClosed", label.getNode());
                        if (label instanceof EditableNodeLabel) {
                            EditableNodeLabel editableLabel = (EditableNodeLabel)label;
                            editableLabel.setEditing(false);
                        }
                    });
                    PopupAwareEditMode.this.view.getCanvasComponent().removeContainerListener(this);
                }
            }
        };
        this.fireEditEvent("labelEditorOpened", label.getNode());
        this.view.getCanvasComponent().addContainerListener(containerListener);
        if (label instanceof EditableNodeLabel) {
            EditableNodeLabel editableLabel = (EditableNodeLabel)label;
            editableLabel.setEditing(true);
            this.view.repaint();
        }
        this.view.openLabelEditor((X)label, label.getTextLocation().A, label.getTextLocation().D, pcl, true, true);
    }

    protected void editNode(Y node) {
        if (CollectionNodeUtils.isCollectionNode(node)) {
            this.zoomToList(node);
        } else {
            GraphID graphID = GraphIDProvider.forGraph((SA)this.getGraph2D());
            GraphWrapper wrapper = MaltegoGraphManager.getWrapper((GraphID)graphID);
            if (NodeEditor.getDefault().edit(graphID, wrapper.entityID(node))) {
                this.fireEditEvent("nodeEdited", node);
            }
        }
    }

    private void zoomToList(Y node) {
        M center = this.view.getGraph2D().P(node);
        this.view.focusView(3.0, (Point2D)new Point2D.Double(center.A, center.D), true);
    }

    private void fireEditEvent(String id, Y node) {
        Collection<? extends NodeEditHook> hooks = NodeEditHook.getAll();
        if (hooks.isEmpty()) {
            return;
        }
        D graph = node.H();
        if (graph != null) {
            GraphID graphID = GraphIDProvider.forGraph((D)graph);
            for (NodeEditHook nodeEditHook : hooks) {
                nodeEditHook.handle(id, graphID);
            }
        }
    }

    public static interface EditableLabel {
        public boolean isEditable();
    }
}

