/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.util.ui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.JScrollPane;
import javax.swing.SwingUtilities;

public class WrapGridLayout
implements LayoutManager {
    private final int _itemHeight;
    private final int _itemWidthMax;
    private final int _hgap;
    private final int _vgap;

    public WrapGridLayout(int itemHeight, int itemWidthMax, int hgap, int vgap) {
        this._itemHeight = itemHeight;
        this._itemWidthMax = itemWidthMax;
        this._hgap = hgap;
        this._vgap = vgap;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Dimension preferredLayoutSize(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int count = parent.getComponentCount();
            if (count <= 0) {
                return new Dimension();
            }
            Insets insets = parent.getInsets();
            int targetWidth = this._itemWidthMax + insets.left + insets.right;
            JScrollPane scrollPane = (JScrollPane)SwingUtilities.getAncestorOfClass(JScrollPane.class, parent);
            if (scrollPane != null) {
                targetWidth = scrollPane.getViewport().getWidth();
            }
            int columns = this.calculateColumns(targetWidth - insets.left - insets.right);
            int rows = (count - 1) / columns + 1;
            int targetHeight = rows * this._itemHeight + (rows - 1) * this._vgap + insets.top + insets.bottom;
            return new Dimension(targetWidth, targetHeight);
        }
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return new Dimension(this._itemWidthMax / 2, this._itemHeight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void layoutContainer(Container parent) {
        Object object = parent.getTreeLock();
        synchronized (object) {
            int itemWidth;
            Component[] components;
            Insets insets = parent.getInsets();
            int width = parent.getWidth() - insets.left - insets.right;
            int height = parent.getHeight() - insets.top - insets.right;
            if (width <= 0 || height <= 0) {
                return;
            }
            int columns = this.calculateColumns(width);
            if (columns > (components = parent.getComponents()).length) {
                columns = components.length;
                itemWidth = this._itemWidthMax;
            } else {
                int hgapTotal = (columns - 1) * this._hgap;
                itemWidth = (width - hgapTotal) / columns;
            }
            int itemColumn = 0;
            int itemRow = 0;
            for (Component component : components) {
                int x = itemColumn * itemWidth + itemColumn * this._hgap;
                int y = itemRow * this._itemHeight + itemRow * this._vgap;
                component.setBounds(x + insets.left, y + insets.top, itemWidth, this._itemHeight);
                if (++itemColumn < columns) continue;
                itemColumn = 0;
                ++itemRow;
            }
        }
    }

    private int calculateColumns(int width) {
        int columns = 1;
        int remainingWidth = width - this._itemWidthMax;
        while (remainingWidth > 0) {
            remainingWidth -= this._itemWidthMax + this._hgap;
            ++columns;
        }
        return columns;
    }
}

