/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.manager.palette;

import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.entity.manager.palette.Favourite;
import com.paterva.maltego.util.FileUtilities;
import com.paterva.maltego.util.StringUtilities;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Children;
import org.openide.nodes.Index;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.NbPreferences;

public final class FavouriteEntities {
    private static final String FAV_HASH = "_M429_FH_";
    private static final String ATTR_POSITION = "position";
    private static final String EXTENSION = ".entity";
    private static FavouriteEntities _instance;
    private final String storeName;
    private final String storeFolderName;
    private final String storeFileName;
    private final int sizeOfFavourites;
    private final ArrayList<Favourite> favourites;
    private FileObject _favouriteFolder;
    private Node favouritesNode;

    public static synchronized FavouriteEntities getInstance() {
        if (_instance == null) {
            _instance = new FavouriteEntities();
        }
        return _instance;
    }

    private FavouriteEntities() {
        this.storeName = "FavouriteEntities";
        this.storeFolderName = "FavFolder";
        this.storeFileName = "FavFile";
        this.sizeOfFavourites = 5;
        this.favourites = new ArrayList(this.sizeOfFavourites);
    }

    public void recreate() throws IOException {
        this.getFavouriteFolder(true);
        this.retrieve();
        for (Favourite f : this.favourites) {
            this.copyToFavouritesFolder(f);
        }
    }

    public ArrayList<Favourite> getFavourites() {
        return this.favourites;
    }

    public Node getFavouritesNode() {
        return this.favouritesNode;
    }

    public void setFavouritesNode(Node nd) {
        Children children = nd.getChildren();
        if (children != null) {
            for (int i = 0; i < children.getNodesCount(); ++i) {
                Node node = children.getNodeAt(i);
                node.setValue("isReadonly", (Object)true);
            }
        }
        this.favouritesNode = nd;
        this.setFavoutiresNodeAttributes();
    }

    private void setFavoutiresNodeAttributes() {
        this.favouritesNode.setDisplayName("* Recently Used *");
        this.favouritesNode.setValue("isReadonly", (Object)true);
        this.favouritesNode.setValue("isExpanded", (Object)true);
    }

    public void addMaltegoEntities(Collection<MaltegoEntity> mes) {
        for (MaltegoEntity me : mes) {
            String typeName = me.getTypeName();
            String fileName = typeName + EXTENSION;
            String folderName = this.getEntityFolderName(typeName);
            if (folderName == null) continue;
            this.addFavourite(folderName, fileName);
        }
    }

    public void addFavourite(String folderName, String fileName) {
        Favourite favourite = new Favourite(folderName, fileName);
        int indexOf = this.favourites.indexOf(favourite);
        if (indexOf == 0) {
            return;
        }
        if (indexOf > 0) {
            favourite = this.favourites.remove(indexOf);
        } else if (this.favourites.size() == this.sizeOfFavourites) {
            this.deleteFromFavouritesFolder(this.favourites.remove(this.sizeOfFavourites - 1));
        }
        this.favourites.add(0, favourite);
        this.store();
        this.copyToFavouritesFolder(favourite);
        if (this.favourites.size() == 1 && this.favouritesNode != null) {
            this.setFavoutiresNodeAttributes();
        }
    }

    private FileObject getFavouriteFolder(boolean fresh) {
        try {
            if (this._favouriteFolder == null || fresh) {
                FileObject favFo;
                FileObject maltego = FileUtil.getConfigRoot().getFileObject("Maltego");
                FileObject entities = maltego.getFileObject("Entities");
                this._favouriteFolder = entities.getFileObject("RecentlyUsed");
                if (this._favouriteFolder != null) {
                    this._favouriteFolder.delete();
                }
                if ((favFo = entities.createFolder("RecentlyUsed")) != null) {
                    favFo.setAttribute(ATTR_POSITION, (Object)0);
                }
                this.putFavouriteNodeFirst();
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return this._favouriteFolder;
    }

    private void putFavouriteNodeFirst() {
        Children children;
        Index cookie;
        Node favNode = this.getFavouritesNode();
        if (favNode != null && (cookie = (Index)favNode.getCookie(Index.class)) != null && (children = favNode.getChildren()) != null) {
            for (int i = 0; i < children.getNodesCount(); ++i) {
                Node node = children.getNodeAt(i);
                if (node == null || !"RecentlyUsed".equals(node.getDisplayName())) continue;
                cookie.move(i, 0);
                break;
            }
        }
    }

    private void copyToFavouritesFolder(Favourite f) {
        try {
            FileObject favouriteFolder = this.getFavouriteFolder(false);
            FileObject fo = f.getFileObject();
            if (fo != null) {
                String newFavouriteEntityName = fo.getName();
                for (FileObject childFo : favouriteFolder.getChildren()) {
                    String childFoName = childFo.getName();
                    if (!newFavouriteEntityName.equals(childFoName) && !FavouriteEntities.stripEntitySuffix(FavouriteEntities.getUniqueDeterministicFileName(f.getFileName())).equals(childFoName)) continue;
                    return;
                }
                FileObject favChild = fo.copy(favouriteFolder, FavouriteEntities.getUniqueDeterministicFileName(f.getFileName()), "");
                if (favChild != null) {
                    favChild.setAttribute(ATTR_POSITION, (Object)0);
                }
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private void deleteFromFavouritesFolder(Favourite f) {
        try {
            for (FileObject fo : this.getFavouriteFolder(false).getChildren()) {
                String foName = fo.getName();
                if (!foName.equals(FavouriteEntities.stripEntitySuffix(f.getFileName())) && !foName.equals(FavouriteEntities.stripEntitySuffix(FavouriteEntities.getUniqueDeterministicFileName(f.getFileName())))) continue;
                fo.delete();
                break;
            }
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private String getEntityFolderName(String entityFileName) {
        FileObject entityFolder = this.getFavouriteFolder(false).getParent();
        for (FileObject fo : entityFolder.getChildren()) {
            if (fo.getName().equals("RecentlyUsed")) continue;
            for (FileObject childFo : fo.getChildren()) {
                if (!childFo.getName().equals(entityFileName)) continue;
                return fo.getName();
            }
        }
        return null;
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(this.getClass()).node(this.storeName);
    }

    private void store() {
        Preferences prefs = this.getPreferences();
        try {
            prefs.clear();
        }
        catch (BackingStoreException backingStoreException) {
            // empty catch block
        }
        for (int i = 0; i < this.favourites.size(); ++i) {
            Favourite fav = this.favourites.get(i);
            prefs.put(this.storeFolderName + i, fav.getFolderName());
            prefs.put(this.storeFileName + i, fav.getFileName());
        }
    }

    private void retrieve() {
        String folder;
        this.favourites.clear();
        Preferences prefs = this.getPreferences();
        for (int i = 0; i < this.sizeOfFavourites && (folder = prefs.get(this.storeFolderName + i, null)) != null; ++i) {
            String file = prefs.get(this.storeFileName + i, null);
            this.favourites.add(new Favourite(folder, file));
        }
    }

    public static boolean isFavCategory(Node node) {
        return node != null && (node.equals((Object)FavouriteEntities.getInstance().getFavouritesNode()) || FavouriteEntities.isFavCategory(node.getDisplayName()));
    }

    public static boolean isFavCategory(String category) {
        return category != null && ("* Recently Used *".equals(category) || "RecentlyUsed".equals(category));
    }

    public static boolean isFavChild(String text) {
        return text != null && text.contains(FAV_HASH);
    }

    public static boolean isFavChild(Node node) {
        boolean favChild = false;
        if (node != null) {
            Children fvChildren;
            Node parentNode = node.getParentNode();
            if (parentNode != null && "RecentlyUsed".equals(parentNode.getName())) {
                favChild = true;
            }
            Node fv = FavouriteEntities.getInstance().getFavouritesNode();
            if (!favChild && fv != null && (fvChildren = fv.getChildren()) != null) {
                for (int i = 0; i < fvChildren.getNodesCount(); ++i) {
                    Node fnChild = fvChildren.getNodeAt(i);
                    if (!node.equals((Object)fnChild)) continue;
                    favChild = true;
                    break;
                }
            }
        }
        return favChild;
    }

    public static String stripFavHash(String fileName) {
        int index;
        if (!StringUtilities.isNullOrEmpty((String)fileName) && (index = fileName.lastIndexOf(FAV_HASH)) > -1) {
            fileName = fileName.substring(index + FAV_HASH.length(), fileName.length());
        }
        return fileName;
    }

    private static String stripEntitySuffix(String fileName) {
        int index;
        if (!StringUtilities.isNullOrEmpty((String)fileName) && (index = fileName.lastIndexOf(".")) > -1) {
            fileName = fileName.substring(0, index);
        }
        return fileName;
    }

    private static String getUniqueDeterministicFileName(String fileName) {
        String hash;
        try {
            MessageDigest digest = MessageDigest.getInstance("MD5");
            byte[] hashBytes = digest.digest(fileName.getBytes());
            hash = FavouriteEntities.getBase64(hashBytes);
        }
        catch (NoSuchAlgorithmException ex) {
            hash = FavouriteEntities.getBase64(fileName.getBytes());
        }
        return FileUtilities.replaceIllegalChars((String)hash) + FAV_HASH + fileName;
    }

    private static String getBase64(byte[] bytes) {
        String base64 = Base64.getEncoder().encodeToString(bytes);
        base64 = base64.substring(0, Math.min(10, base64.length()));
        return base64;
    }

    public static void removeFavoriteEntity(String typeName) {
        String name;
        FileObject fo;
        FileObject favouriteFolder = FavouriteEntities.getInstance().getFavouriteFolder(false);
        if (favouriteFolder != null && (fo = favouriteFolder.getFileObject(name = FavouriteEntities.getUniqueDeterministicFileName(typeName + EXTENSION))) != null) {
            try {
                fo.delete();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

