/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.runtime.objects;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.js.runtime.JSRuntime;
import com.oracle.truffle.js.runtime.builtins.JSOverloadedOperatorsObject;
import java.util.Arrays;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.collections.EconomicSet;

public class OperatorSet {
    public static final EconomicSet<String> BINARY_OPERATORS;
    public static final EconomicSet<String> UNARY_OPERATORS;
    public static final EconomicSet<String> ALL_OPERATORS;
    private static final EconomicSet<String> STRING_OPEN_OPERATORS;
    public static final OperatorSet NUMBER_OPERATOR_SET;
    public static final OperatorSet BIGINT_OPERATOR_SET;
    public static final OperatorSet STRING_OPERATOR_SET;
    private final int operatorCounter;
    private final EconomicMap<String, Object> selfOperatorDefinitions;
    private final EconomicMap<String, Object[]> leftOperatorDefinitions;
    private final EconomicMap<String, Object[]> rightOperatorDefinitions;
    private final EconomicSet<String> openOperators;

    public OperatorSet(int operatorCounter, EconomicSet<String> openOperators) {
        this(operatorCounter, null, null, null, openOperators);
    }

    public OperatorSet(int operatorCounter, EconomicMap<String, Object> selfOperatorDefinitions, EconomicMap<String, Object[]> leftOperatorDefinitions, EconomicMap<String, Object[]> rightOperatorDefinitions, EconomicSet<String> openOperators) {
        this.operatorCounter = operatorCounter;
        this.selfOperatorDefinitions = selfOperatorDefinitions;
        this.leftOperatorDefinitions = leftOperatorDefinitions;
        this.rightOperatorDefinitions = rightOperatorDefinitions;
        this.openOperators = openOperators;
    }

    @CompilerDirectives.TruffleBoundary
    public boolean isOperatorOpen(String operator) {
        return this.openOperators.contains((Object)operator);
    }

    public int getOperatorCounter() {
        return this.operatorCounter;
    }

    public static OperatorSet getOperatorSet(Object object) {
        if (JSRuntime.isNumber(object)) {
            return NUMBER_OPERATOR_SET;
        }
        if (JSRuntime.isBigInt(object)) {
            return BIGINT_OPERATOR_SET;
        }
        if (JSRuntime.isString(object)) {
            return STRING_OPERATOR_SET;
        }
        assert (object instanceof JSOverloadedOperatorsObject);
        return ((JSOverloadedOperatorsObject)object).getOperatorSet();
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getOperatorImplementation(JSOverloadedOperatorsObject operand, String operatorName) {
        return operand.getOperatorSet().selfOperatorDefinitions.get((Object)operatorName);
    }

    @CompilerDirectives.TruffleBoundary
    public static Object getOperatorImplementation(Object left, Object right, String operatorName) {
        OperatorSet rightOperatorSet;
        if (JSRuntime.isNullOrUndefined(left) || JSRuntime.isNullOrUndefined(right)) {
            return null;
        }
        OperatorSet leftOperatorSet = OperatorSet.getOperatorSet(left);
        if (leftOperatorSet == (rightOperatorSet = OperatorSet.getOperatorSet(right))) {
            return leftOperatorSet.selfOperatorDefinitions.get((Object)operatorName);
        }
        if (leftOperatorSet.operatorCounter < rightOperatorSet.operatorCounter) {
            Object[] rightOperatorDefinitions = (Object[])rightOperatorSet.rightOperatorDefinitions.get((Object)operatorName);
            if (rightOperatorDefinitions != null) {
                return rightOperatorDefinitions[leftOperatorSet.operatorCounter];
            }
            return null;
        }
        assert (leftOperatorSet.operatorCounter > rightOperatorSet.operatorCounter);
        Object[] leftOperatorDefinitions = (Object[])leftOperatorSet.leftOperatorDefinitions.get((Object)operatorName);
        if (leftOperatorDefinitions != null) {
            return leftOperatorDefinitions[rightOperatorSet.operatorCounter];
        }
        return null;
    }

    static {
        List<String> binaryOperators = Arrays.asList("-", "*", "/", "%", "**", "&", "^", "|", "<<", ">>", ">>>", "==", "+", "<");
        BINARY_OPERATORS = EconomicSet.create((int)binaryOperators.size());
        BINARY_OPERATORS.addAll(binaryOperators);
        List<String> unaryOperators = Arrays.asList("pos", "neg", "++", "--", "~");
        UNARY_OPERATORS = EconomicSet.create((int)unaryOperators.size());
        UNARY_OPERATORS.addAll(unaryOperators);
        ALL_OPERATORS = EconomicSet.create((int)(BINARY_OPERATORS.size() + UNARY_OPERATORS.size()));
        ALL_OPERATORS.addAll(BINARY_OPERATORS);
        ALL_OPERATORS.addAll(UNARY_OPERATORS);
        STRING_OPEN_OPERATORS = EconomicSet.create((int)3);
        STRING_OPEN_OPERATORS.addAll(Arrays.asList("+", "==", "<"));
        NUMBER_OPERATOR_SET = new OperatorSet(0, BINARY_OPERATORS);
        BIGINT_OPERATOR_SET = new OperatorSet(1, BINARY_OPERATORS);
        STRING_OPERATOR_SET = new OperatorSet(2, STRING_OPEN_OPERATORS);
    }
}

