/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.find.files.nodes;

import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.core.TypedPropertyBag;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.find.files.actions.SelectNodesAction;
import com.paterva.maltego.find.files.nodes.PropertyUtils;
import com.paterva.maltego.imgfactory.parts.LinkImageFactory;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import com.paterva.maltego.ui.graph.nodes.LinkProperties;
import java.awt.Image;
import javax.swing.Action;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class FoundLinkNode
extends AbstractNode {
    private MaltegoLink _link;
    private String _snippet;

    public FoundLinkNode(MaltegoLink link, String snippet) {
        this(link, snippet, new InstanceContent());
    }

    public FoundLinkNode(MaltegoLink link, String snippet, InstanceContent content) {
        super(Children.LEAF, (Lookup)new AbstractLookup((AbstractLookup.Content)content));
        this._link = link;
        this._snippet = snippet;
        content.add((Object)this._link);
        content.add((Object)this);
        content.add((Object)this.getLinkSpec());
        LinkRegistry registry = LinkRegistry.getDefault();
        String name = InheritanceHelper.getDisplayString((SpecRegistry)registry, (TypedPropertyBag)this._link);
        this.setDisplayName(name);
        this.setShortDescription(snippet);
    }

    public Image getIcon(int type) {
        return LinkImageFactory.getImage((MaltegoLinkSpec)this.getLinkSpec(), (int)this.getSize(type));
    }

    private int getSize(int type) {
        if (type == 1 || type == 3) {
            return 16;
        }
        return 32;
    }

    private MaltegoLinkSpec getLinkSpec() {
        return (MaltegoLinkSpec)LinkRegistry.getDefault().get(this._link.getTypeName());
    }

    protected Sheet createSheet() {
        Sheet sheet = LinkProperties.createBasicSheet((Node)this, (MaltegoLink)this._link, (MaltegoLinkSpec)this.getLinkSpec());
        PropertyUtils.addPartFindProperties(sheet, (Node)this, this._snippet);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        return new Action[]{SystemAction.get(SelectNodesAction.class)};
    }

    public Action getPreferredAction() {
        return SystemAction.get(SelectNodesAction.class);
    }
}

