/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.collab.session.xmpp.bosh;

import com.kenai.jbosh.AbstractBody;
import com.kenai.jbosh.BOSHClient;
import com.kenai.jbosh.BOSHClientConfig;
import com.kenai.jbosh.BOSHException;
import com.kenai.jbosh.BodyQName;
import com.kenai.jbosh.ComposableBody;
import com.paterva.maltego.collab.XmlPullParserUtils;
import com.paterva.maltego.collab.session.xmpp.bosh.BoshDebug;
import com.paterva.maltego.collab.session.xmpp.bosh.BoshProxy;
import com.paterva.maltego.collab.session.xmpp.bosh.XmppPacket;
import com.paterva.maltego.util.NormalException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import org.xmlpull.mxp1.MXParser;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

abstract class BoshState {
    private static final String HTTPBIND_NS = "http://jabber.org/protocol/httpbind";
    private static final String STREAM_NS = "http://etherx.jabber.org/streams";
    private BoshProxy _stateMachine;

    public BoshState() {
    }

    public BoshState(BoshProxy stateMachine) {
        this._stateMachine = stateMachine;
    }

    public abstract void start(Object ... var1);

    public abstract void destroy();

    protected abstract void handleServerMessage(AbstractBody var1);

    protected abstract void handleClientMessage(XmppPacket var1);

    protected void setState(BoshState state, Object ... params) {
        state._stateMachine = this._stateMachine;
        if (BoshDebug.DEBUG) {
            System.out.println(BoshDebug.format("Bosh state = " + state));
        }
        this._stateMachine.setCurrentState(state, params);
    }

    protected BOSHClient getBoshClient() {
        return this._stateMachine.getBoshClient();
    }

    protected BOSHClientConfig getBoshConfig() {
        return this.getBoshClient().getBOSHClientConfig();
    }

    protected void sendToClient(String block) {
        if (block != null && block.trim().length() > 0) {
            this._stateMachine.sendToClient(block);
        }
    }

    protected void sendToServer(ComposableBody body) throws IOException {
        try {
            this.getBoshClient().send(body);
        }
        catch (BOSHException ex) {
            String msg = ex.getMessage();
            if (msg.contains("Cannot send message when session is closed")) {
                NormalException.logStackTrace((Throwable)ex);
            }
            throw new IOException("Error sending message to server", ex);
        }
    }

    void serverMessageReceived(AbstractBody body) {
        this.handleServerMessage(body);
    }

    void clientMessageReceived(XmppPacket packet) {
        this.handleClientMessage(packet);
    }

    void connectionErrorOccurred(Throwable error) {
        NormalException.logStackTrace((Throwable)error);
        this.setState(BoshProxy.Faulted, new Object[0]);
    }

    protected XmlPullParser createServerMessageParser(AbstractBody body) throws XmlPullParserException {
        MXParser parser = new MXParser();
        parser.setFeature("http://xmlpull.org/v1/doc/features.html#process-namespaces", true);
        parser.setInput((Reader)new StringReader(body.toXML()));
        return parser;
    }

    protected static boolean isStream(XmlPullParser parser) {
        return "stream".equals(parser.getName()) && STREAM_NS.equals(parser.getNamespace());
    }

    public String toString() {
        return this.getClass().getName();
    }

    static class Faulted
    extends Abstract {
        Faulted() {
        }

        @Override
        public void start(Object ... params) {
        }
    }

    static class Closed
    extends Abstract {
        Closed() {
        }
    }

    static class Authenticated
    extends Connected {
        Authenticated() {
        }

        @Override
        protected void handleClientMessage(XmppPacket packet) {
            try {
                if (packet.getType() == 1) {
                    this.performStreamRestart();
                } else if (packet.getType() == 0) {
                    this.sendToServer(packet.getXml());
                }
            }
            catch (IOException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        private void performStreamRestart() throws IOException {
            this.sendToServer(ComposableBody.builder().setNamespaceDefinition("xmpp", "urn:xmpp:xbosh").setAttribute(BodyQName.createWithPrefix((String)"urn:xmpp:xbosh", (String)"restart", (String)"xmpp"), "true").build());
        }

        @Override
        protected void handleServerMessage(AbstractBody body) {
            try {
                int eventType;
                XmlPullParser parser = this.createServerMessageParser(body);
                do {
                    if ((eventType = parser.next()) != 2) continue;
                    String message = null;
                    if (!parser.getName().equals("body")) {
                        if ("features".equals(parser.getName()) && BoshState.STREAM_NS.equals(parser.getNamespace())) {
                            String features = XmlPullParserUtils.toXml(parser);
                            message = this.createStreamFeaturesBlock(this.getSID(), this.getServer(), features);
                        } else {
                            message = XmlPullParserUtils.toXml(parser);
                        }
                    }
                    if (message == null || message.trim().length() <= 0) continue;
                    this.sendToClient(message);
                } while (eventType != 1);
            }
            catch (XmlPullParserException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }
    }

    static class Connected
    extends Abstract {
        private String _sid;
        private String _server;

        Connected() {
        }

        @Override
        public synchronized void start(Object ... params) {
            this._sid = (String)params[0];
            this._server = (String)params[1];
        }

        protected String getSID() {
            return this._sid;
        }

        protected String getServer() {
            return this._server;
        }

        @Override
        protected void handleClientMessage(XmppPacket packet) {
            try {
                if (packet.getType() == 0) {
                    this.sendToServer(packet.getXml());
                } else if (packet.getType() == 2) {
                    System.out.println();
                }
            }
            catch (IOException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        @Override
        protected void handleServerMessage(AbstractBody body) {
            try {
                int eventType;
                XmlPullParser parser = this.createServerMessageParser(body);
                String message = null;
                boolean stop = false;
                boolean authenticated = false;
                do {
                    if ((eventType = parser.next()) != 2 || parser.getName().equals("body")) continue;
                    authenticated = "success".equals(parser.getName()) && "urn:ietf:params:xml:ns:xmpp-sasl".equals(parser.getNamespace());
                    message = XmlPullParserUtils.toXml(parser);
                    stop = true;
                } while (!stop && eventType != 1);
                this.sendToClient(message);
                if (authenticated) {
                    this.setState(BoshProxy.Authenticated, this.getSID(), this.getServer());
                }
            }
            catch (XmlPullParserException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
            catch (IOException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        protected void sendToServer(String payload) throws IOException {
            this.sendToServer(ComposableBody.builder().setPayloadXML(payload).build());
        }

        @Override
        protected void sendToServer(ComposableBody body) throws IOException {
            body = body.rebuild().setAttribute(BodyQName.create((String)BoshState.HTTPBIND_NS, (String)"sid"), this._sid).build();
            super.sendToServer(body);
        }
    }

    static class Connecting
    extends Abstract {
        Connecting() {
        }

        @Override
        protected void handleServerMessage(AbstractBody body) {
            String sid = null;
            String from = null;
            String features = null;
            try {
                int eventType;
                XmlPullParser parser = this.createServerMessageParser(body);
                boolean stop = false;
                do {
                    if ((eventType = parser.next()) != 2) continue;
                    if (parser.getName().equals("body")) {
                        from = body.getAttribute(BodyQName.create((String)BoshState.HTTPBIND_NS, (String)"from"));
                        sid = body.getAttribute(BodyQName.create((String)BoshState.HTTPBIND_NS, (String)"sid"));
                        continue;
                    }
                    if ("features".equals(parser.getName()) && BoshState.STREAM_NS.equals(parser.getNamespace())) {
                        features = XmlPullParserUtils.toXml(parser);
                        stop = true;
                        continue;
                    }
                    System.out.println("unkown node detected in stream negotiation");
                } while (!stop && eventType != 1);
            }
            catch (IOException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
            catch (XmlPullParserException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
            if (from == null) {
                from = this.getBoshConfig().getTo();
            }
            if (sid != null && from != null && features != null) {
                String block = this.createStreamFeaturesBlock(sid, from, features);
                this.sendToClient(block);
                this.setState(BoshProxy.Connected, sid, from);
            } else {
                this.setState(BoshProxy.Faulted, new Object[0]);
            }
        }

        @Override
        public void start(Object ... params) {
            try {
                this.sendToServer(ComposableBody.builder().build());
            }
            catch (IOException ex) {
                NormalException.showStackTrace((Throwable)ex);
            }
        }

        private void showAttributes(XmlPullParser parser) {
            for (int i = 0; i < parser.getAttributeCount(); ++i) {
                String prefix = parser.getAttributePrefix(i);
                String name = parser.getAttributeName(i);
                String ns = parser.getAttributeNamespace(i);
                String value = parser.getAttributeValue(i);
                System.out.println(String.format("%s:%s %s = %s", prefix, name, ns, value));
            }
        }
    }

    static class Idle
    extends Abstract {
        public Idle() {
        }

        public Idle(BoshProxy stateMachine) {
            super(stateMachine);
        }

        @Override
        protected void handleClientMessage(XmppPacket packet) {
            if (packet.getType() == 1) {
                this.setState(BoshProxy.Connecting, new Object[0]);
            } else {
                this.setState(BoshProxy.Faulted, new Object[0]);
            }
        }
    }

    static class Abstract
    extends BoshState {
        public Abstract() {
        }

        public Abstract(BoshProxy stateMachine) {
            super(stateMachine);
        }

        @Override
        public void start(Object ... params) {
        }

        @Override
        public void destroy() {
        }

        @Override
        protected void handleServerMessage(AbstractBody body) {
        }

        @Override
        protected void handleClientMessage(XmppPacket packet) {
        }

        protected String createStreamFeaturesBlock(String sid, String from, String features) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(String.format("<stream:stream xmlns:stream=\"http://etherx.jabber.org/streams\" xmlns=\"jabber:client\" from=\"%s\" id=\"%s\" xml:lang=\"en\" version=\"1.0\">", from, sid));
            if (features != null) {
                buffer.append(features);
            }
            return buffer.toString();
        }
    }
}

