/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.graph.table.io.convert;

import com.paterva.maltego.core.GraphID;
import com.paterva.maltego.core.MaltegoPart;
import com.paterva.maltego.entity.api.EntityRegistry;
import com.paterva.maltego.entity.api.LinkRegistry;
import com.paterva.maltego.entity.api.MaltegoLinkSpec;
import com.paterva.maltego.entity.api.inheritance.InheritanceHelper;
import com.paterva.maltego.graph.store.GraphStore;
import com.paterva.maltego.graph.store.GraphStoreRegistry;
import com.paterva.maltego.graph.store.data.GraphStoreException;
import com.paterva.maltego.graph.store.structure.GraphStructureReader;
import com.paterva.maltego.graph.table.PropertyToColumnMap;
import com.paterva.maltego.graph.table.TabularGraph;
import com.paterva.maltego.graph.table.TabularGraphEntity;
import com.paterva.maltego.graph.table.TabularGraphLink;
import com.paterva.maltego.graph.table.io.convert.TabularGraphImportOptions;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphEntityType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphLinkType;
import com.paterva.maltego.graph.table.io.convert.data.TabularGraphPartType;
import com.paterva.maltego.typing.PropertyDescriptor;
import com.paterva.maltego.typing.TypeDescriptor;
import com.paterva.maltego.typing.TypeRegistry;
import com.paterva.maltego.typing.descriptor.SpecRegistry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TabularGraphUtils {
    public static boolean ignoreRow(int rowCount) {
        return rowCount < 0 || TabularGraphImportOptions.isSamplingEnabled() && rowCount % TabularGraphImportOptions.getSamplingRate() != 0;
    }

    public static boolean isEntityLimitReached(int entityCount) {
        return TabularGraphImportOptions.isEntityLimitEnabled() && entityCount >= TabularGraphImportOptions.getEntityLimit();
    }

    public static int getEntityCount(GraphID graphID) throws GraphStoreException {
        GraphStore graphStore = GraphStoreRegistry.getDefault().forGraphID(graphID);
        GraphStructureReader structureReader = graphStore.getGraphStructureStore().getStructureReader();
        int graphEntityCount = structureReader.getEntityCount();
        return graphEntityCount;
    }

    public static void trimRowValues(List<Object> row) {
        if (TabularGraphImportOptions.isTrimValues()) {
            ArrayList<Object> trimmedValues = new ArrayList<Object>(row.size());
            for (Object object : row) {
                if (object instanceof String) {
                    String str = (String)object;
                    object = str.trim();
                }
                trimmedValues.add(object);
            }
            row.clear();
            row.addAll(trimmedValues);
        }
    }

    public static Map<Integer, TypeDescriptor> getDesiredColumnTypes(List<? extends PropertyToColumnMap> tableItems) {
        HashMap<Integer, TypeDescriptor> desiredColumnTypes = new HashMap<Integer, TypeDescriptor>();
        for (PropertyToColumnMap propertyToColumnMap : tableItems) {
            for (int column : propertyToColumnMap.getColumns()) {
                PropertyDescriptor pd = propertyToColumnMap.getProperty(column);
                TypeDescriptor type = TypeRegistry.getDefault().getType(pd.getType());
                desiredColumnTypes.put(column, type);
            }
        }
        return desiredColumnTypes;
    }

    public static Object[] toColumnValues(MaltegoPart part, PropertyToColumnMap properties) {
        ArrayList<Object> values = new ArrayList<Object>();
        for (int column : properties.getColumns()) {
            PropertyDescriptor pd = properties.getProperty(column);
            Object value = part.getValue(pd);
            values.add(value);
        }
        return values.toArray();
    }

    public static TabularGraphEntityType[] getEntityTypes(TabularGraph tabularGraph, List<String> entitySpecs, List<TabularGraphEntity> entities) {
        return (TabularGraphEntityType[])entities.stream().map(entity -> {
            try {
                return TabularGraphUtils.toType(tabularGraph, entitySpecs, entity);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }).toArray(TabularGraphEntityType[]::new);
    }

    public static TabularGraphLinkType[] getLinkTypes(TabularGraph tabularGraph, List<TabularGraphLink> links) {
        return (TabularGraphLinkType[])links.stream().map(link -> {
            try {
                return TabularGraphUtils.toType(tabularGraph, link);
            }
            catch (IOException ex) {
                throw new RuntimeException(ex);
            }
        }).toArray(TabularGraphLinkType[]::new);
    }

    private static TabularGraphEntityType toType(TabularGraph tabularGraph, List<String> entitySpecs, TabularGraphEntity entity) throws IOException {
        String spec = entity.getEntitySpecName();
        EntityRegistry registry = EntityRegistry.getDefault();
        TabularGraphEntityType type = new TabularGraphEntityType();
        type.tabularEntity = entity;
        type.spec = entitySpecs.indexOf(spec);
        if (type.spec < 0) {
            type.spec = entitySpecs.size();
            entitySpecs.add(spec);
        }
        TabularGraphUtils.updatePartType(tabularGraph, type, (PropertyToColumnMap)entity, spec, (SpecRegistry)registry);
        return type;
    }

    private static TabularGraphLinkType toType(TabularGraph tabularGraph, TabularGraphLink link) throws IOException {
        String spec = MaltegoLinkSpec.getManualSpec().getTypeName();
        LinkRegistry registry = LinkRegistry.getDefault();
        TabularGraphLinkType type = new TabularGraphLinkType();
        type.tabularLink = link;
        TabularGraphUtils.updatePartType(tabularGraph, type, (PropertyToColumnMap)link, spec, (SpecRegistry)registry);
        return type;
    }

    private static TabularGraphPartType updatePartType(TabularGraph tabularGraph, TabularGraphPartType type, PropertyToColumnMap part, String spec, SpecRegistry registry) throws IOException {
        int i;
        int[] columns = part.getColumns();
        Set strict = (Set)tabularGraph.getTypeStrictProperties().get(spec);
        if (strict == null) {
            strict = Collections.EMPTY_SET;
        }
        ArrayList<PropertyDescriptor> matchProperties = new ArrayList<PropertyDescriptor>();
        ArrayList<PropertyDescriptor> otherProperties = new ArrayList<PropertyDescriptor>();
        PropertyDescriptor valueProperty = InheritanceHelper.getValueProperty((SpecRegistry)registry, (String)spec);
        if (valueProperty == null) {
            throw new IOException("Entity of type \"" + spec + "\" is not currently installed. Please check that the required mapped entity types are available for tabular import/export.");
        }
        List linkedProperties = valueProperty.getLinkedProperties();
        boolean valuePropFound = false;
        for (int i2 = 0; i2 < columns.length; ++i2) {
            int column = columns[i2];
            PropertyDescriptor property = part.getProperty(column);
            if (strict.contains(property.getName())) {
                matchProperties.add(property);
                continue;
            }
            if (strict.isEmpty() && property.equals(valueProperty)) {
                matchProperties.add(property);
                valuePropFound = true;
                continue;
            }
            otherProperties.add(property);
        }
        PropertyDescriptor calculatedProperty = null;
        if (strict.isEmpty() && !valuePropFound && !linkedProperties.isEmpty()) {
            calculatedProperty = valueProperty;
            matchProperties.add(calculatedProperty);
        }
        Collections.sort(matchProperties);
        Collections.sort(otherProperties);
        type.matchProperties = matchProperties.toArray(new PropertyDescriptor[matchProperties.size()]);
        type.otherProperties = otherProperties.toArray(new PropertyDescriptor[otherProperties.size()]);
        type.matchPropertyIndexes = new int[matchProperties.size()];
        type.otherPropertyIndexes = new int[otherProperties.size()];
        for (i = 0; i < columns.length; ++i) {
            int column = columns[i];
            PropertyDescriptor property = part.getProperty(column);
            int index = matchProperties.indexOf(property);
            if (index >= 0) {
                type.matchPropertyIndexes[index] = column;
            }
            if ((index = otherProperties.indexOf(property)) < 0) continue;
            type.otherPropertyIndexes[index] = column;
        }
        if (calculatedProperty != null) {
            for (i = 0; i < type.matchProperties.length; ++i) {
                PropertyDescriptor matchProperty = type.matchProperties[i];
                if (!calculatedProperty.equals(matchProperty)) continue;
                type.calculatedPropertyIndex = i;
                type.matchPropertyIndexes[i] = -1;
            }
        }
        return type;
    }
}

