/*
 * Decompiled with CFR 0.152.
 */
package org.xlightweb;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.xlightweb.AbstractHttpHeader;
import org.xlightweb.BadMessageException;
import org.xlightweb.HttpUtils;
import org.xlightweb.IHttpRequestHeader;
import org.xsocket.connection.INonBlockingConnection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HttpRequestHeader
extends AbstractHttpHeader
implements IHttpRequestHeader {
    private static final Boolean NULL_BOOLEAN = null;
    private final INonBlockingConnection tcpConnection;
    private String method;
    private String path;
    private String rawQuery;
    private ArrayList<Parameter> queryParameters;
    private boolean isParamMapModified = false;
    private boolean parameterResolveRequired = false;
    private boolean isSecure = false;
    private String servername;
    private Integer serverport;
    private String keepAlive;
    private String host;
    private String userAgent;

    HttpRequestHeader(INonBlockingConnection tcpConnection) {
        this.tcpConnection = tcpConnection;
        this.isSecure = tcpConnection.isSecure();
        this.setProtocolSchemeSilence("HTTP");
        this.setProtocolVersionSilence("0.9");
    }

    public HttpRequestHeader(String method, String url) {
        this(method, url, null, "1.1");
    }

    public HttpRequestHeader(String method, String url, String contentType) {
        this(method, url, contentType, "1.1");
    }

    HttpRequestHeader(String method, String url, String contentType, String protocolVersion) {
        this.tcpConnection = null;
        this.parameterResolveRequired = true;
        this.method = method;
        this.setProtocolSchemeSilence("HTTP");
        this.setProtocolVersionSilence(protocolVersion);
        if (contentType != null) {
            this.addHeader("Content-Type", contentType);
        }
        if (method.equalsIgnoreCase("CONNECT")) {
            this.path = url.trim();
        } else {
            String scheme = null;
            int port = -1;
            try {
                URI uri = new URI(url.trim());
                this.path = uri.getRawPath();
                this.rawQuery = uri.getRawQuery();
                scheme = uri.getScheme();
                this.servername = uri.getHost();
                port = uri.getPort();
            }
            catch (URISyntaxException ue) {
                try {
                    URL u = new URL(url.trim());
                    this.path = u.getPath();
                    this.rawQuery = u.getQuery();
                    scheme = u.getProtocol();
                    this.servername = u.getHost();
                    port = u.getPort();
                }
                catch (MalformedURLException urle) {
                    throw new RuntimeException(urle.toString());
                }
            }
            if (scheme != null && scheme.equals("https")) {
                this.isSecure = true;
            }
            if (port != -1) {
                this.serverport = port;
                this.setHost(this.servername + ":" + this.serverport);
            } else {
                this.setHost(this.servername);
            }
            if (this.path.length() == 0) {
                this.path = "/";
            }
        }
    }

    INonBlockingConnection getUnderylingConnection() {
        return this.tcpConnection;
    }

    void setServernameSilence(String servername) {
        this.servername = servername;
    }

    void setServerportPortSilence(int serverport) {
        this.serverport = serverport;
    }

    @Override
    protected boolean onHeaderAdded(String headername, String headervalue) {
        if (headername.equalsIgnoreCase("Keep-Alive")) {
            this.keepAlive = headervalue;
            return true;
        }
        if (headername.equalsIgnoreCase("Host")) {
            this.host = headervalue;
            return true;
        }
        if (headername.equalsIgnoreCase("User-Agent")) {
            this.userAgent = headervalue;
            return true;
        }
        return super.onHeaderAdded(headername, headervalue);
    }

    @Override
    protected boolean onHeaderRemoved(String headername) {
        if (headername.equalsIgnoreCase("Keep-Alive")) {
            this.keepAlive = null;
            return true;
        }
        if (headername.equalsIgnoreCase("Host")) {
            this.host = null;
            return true;
        }
        if (headername.equalsIgnoreCase("User-Agent")) {
            this.userAgent = null;
            return true;
        }
        return super.onHeaderRemoved(headername);
    }

    @Override
    public void setKeepAlive(String keepAlive) {
        this.keepAlive = keepAlive;
    }

    @Override
    public String getKeepAlive() {
        return this.keepAlive;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public void setHost(String host) {
        this.host = host;
        this.servername = null;
        this.serverport = null;
    }

    @Override
    public String getUserAgent() {
        return this.userAgent;
    }

    @Override
    public void setUserAgent(String userAgent) {
        this.userAgent = userAgent;
    }

    @Override
    public Set<String> getHeaderNameSet() {
        Set<String> headerNames = super.getHeaderNameSet();
        if (this.keepAlive != null) {
            headerNames.add("Keep-Alive");
        }
        if (this.host != null) {
            headerNames.add("Host");
        }
        if (this.userAgent != null) {
            headerNames.add("User-Agent");
        }
        return headerNames;
    }

    @Override
    public List<String> getHeaderList(String headername) {
        if (headername.equalsIgnoreCase("Keep-Alive")) {
            if (this.keepAlive == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.keepAlive);
            return Collections.unmodifiableList(result);
        }
        if (headername.equalsIgnoreCase("Host")) {
            if (this.host == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.host);
            return Collections.unmodifiableList(result);
        }
        if (headername.equalsIgnoreCase("User-Agent")) {
            if (this.userAgent == null) {
                return null;
            }
            ArrayList<String> result = new ArrayList<String>();
            result.add(this.userAgent);
            return Collections.unmodifiableList(result);
        }
        return super.getHeaderList(headername);
    }

    @Override
    public String getHeader(String headername) {
        if (headername.equalsIgnoreCase("Keep-Alive")) {
            if (this.keepAlive == null) {
                return null;
            }
            return this.keepAlive;
        }
        if (headername.equalsIgnoreCase("Host")) {
            if (this.host == null) {
                return null;
            }
            return this.host;
        }
        if (headername.equalsIgnoreCase("User-Agent")) {
            if (this.userAgent == null) {
                return null;
            }
            return this.userAgent;
        }
        return super.getHeader(headername);
    }

    @Override
    public boolean containsHeader(String headername) {
        if (headername.equalsIgnoreCase("Keep-Alive")) {
            return this.keepAlive != null;
        }
        if (headername.equalsIgnoreCase("Host")) {
            return this.host != null;
        }
        if (headername.equalsIgnoreCase("User-Agent")) {
            return this.userAgent != null;
        }
        return super.containsHeader(headername);
    }

    @Override
    public String getRemoteHost() {
        if (this.tcpConnection != null) {
            return this.tcpConnection.getRemoteAddress().getHostName();
        }
        return null;
    }

    @Override
    public int getRemotePort() {
        if (this.tcpConnection != null) {
            return this.tcpConnection.getRemotePort();
        }
        return -1;
    }

    @Override
    public String getRemoteAddr() {
        if (this.tcpConnection != null) {
            return this.tcpConnection.getRemoteAddress().getHostAddress();
        }
        return null;
    }

    @Override
    public String getQueryString() {
        return this.rawQuery;
    }

    void setRawQueryStringSilence(String rawQuery) {
        this.rawQuery = rawQuery;
    }

    @Override
    public String getRequestURI() {
        return this.path;
    }

    @Override
    public void setRequestURI(String requestUri) {
        this.path = requestUri;
    }

    void setPathSilence(String path) {
        this.path = path;
    }

    @Override
    public URL getRequestUrl() {
        try {
            String p = this.path;
            if (this.rawQuery != null) {
                p = p + "?" + this.rawQuery;
            }
            String srvName = this.getServerName();
            if (this.isSecure) {
                if (this.serverport != null) {
                    return new URL("https", srvName, this.serverport, p);
                }
                return new URL("https", srvName, p);
            }
            if (this.serverport != null) {
                return new URL("http", srvName, this.serverport, p);
            }
            return new URL("http", srvName, p);
        }
        catch (MalformedURLException use) {
            throw new RuntimeException(use.toString());
        }
    }

    @Override
    public void setRequestUrl(URL url) {
        String protocol = url.getProtocol();
        if (protocol != null) {
            this.isSecure = protocol.equalsIgnoreCase("https");
        }
        this.path = url.getPath();
        if (this.path.trim().length() == 0) {
            this.path = "/";
        }
        this.rawQuery = url.getQuery();
        if (this.queryParameters != null) {
            this.queryParameters.clear();
        }
        if (url.getHost() != null) {
            this.servername = url.getHost();
            int port = url.getPort();
            if (port != -1) {
                this.serverport = port;
            }
            this.host = this.serverport != null ? this.servername + ":" + this.serverport : this.servername;
            this.setHost(this.host);
        }
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(String method) {
        this.setMethodSilence(method);
    }

    void setMethodSilence(String method) {
        this.method = method;
    }

    @Override
    public String getServerName() {
        if (this.servername == null) {
            this.resolveHostField();
            if (this.servername == null && this.tcpConnection != null) {
                return this.tcpConnection.getLocalAddress().getHostName();
            }
        }
        return this.servername;
    }

    @Override
    public int getServerPort() {
        if (this.serverport == null) {
            this.resolveHostField();
            if (this.serverport == null) {
                if (this.servername != null) {
                    if (this.isSecure()) {
                        return 443;
                    }
                    return 80;
                }
                if (this.tcpConnection != null) {
                    return this.tcpConnection.getLocalPort();
                }
                this.serverport = -1;
            }
        }
        return this.serverport;
    }

    private void resolveHostField() {
        String host;
        if (this.servername == null && (host = this.getHeader("HOST")) != null) {
            int pos = host.lastIndexOf(":");
            if (pos == -1) {
                this.servername = host;
            } else {
                this.servername = host.substring(0, pos);
                this.serverport = Integer.parseInt(host.substring(pos + 1, host.length()).trim());
            }
        }
    }

    void removeParameter(String parameterName) {
        this.isParamMapModified = true;
        ArrayList<Parameter> paramsToRemove = new ArrayList<Parameter>();
        for (Parameter parameter : this.getQueryParamList()) {
            if (!parameter.isDecodedNameSame(parameterName)) continue;
            paramsToRemove.add(parameter);
        }
        this.queryParameters.removeAll(paramsToRemove);
    }

    @Override
    public void setParameter(String parameterName, String parameterValue) {
        if (this.parameterResolveRequired) {
            this.parameterResolveRequired = false;
            this.resolveParameters();
        }
        this.removeParameter(parameterName);
        this.getQueryParamList().add(new Parameter(parameterName, parameterValue, true));
    }

    @Override
    public Enumeration getParameterNames() {
        return Collections.enumeration(this.getParameterNameSet());
    }

    @Override
    public Set<String> getParameterNameSet() {
        HashSet<String> result = new HashSet<String>();
        if (this.parameterResolveRequired) {
            this.parameterResolveRequired = false;
            this.resolveParameters();
        }
        for (Parameter param : this.getQueryParamList()) {
            result.add(param.getDecodedName());
        }
        return result;
    }

    @Override
    public String getParameter(String name) {
        if (this.parameterResolveRequired) {
            this.parameterResolveRequired = false;
            this.resolveParameters();
        }
        for (Parameter param : this.getQueryParamList()) {
            if (!param.isDecodedNameSame(name)) continue;
            return param.getDecodedValue();
        }
        return null;
    }

    private void resolveParameters() {
        if (this.rawQuery != null) {
            Map<String, List<String>> p = HttpUtils.parseParamters(this.rawQuery, this.getCharacterEncoding());
            for (Map.Entry<String, List<String>> entry : p.entrySet()) {
                for (String value : entry.getValue()) {
                    this.getQueryParamList().add(new Parameter(entry.getKey(), value, true));
                }
            }
        }
    }

    @Override
    public String[] getParameterValues(String name) {
        ArrayList<String> result = new ArrayList<String>();
        if (this.parameterResolveRequired) {
            this.parameterResolveRequired = false;
            this.resolveParameters();
        }
        for (Parameter param : this.getQueryParamList()) {
            if (!param.isDecodedNameSame(name)) continue;
            result.add(param.getDecodedValue());
        }
        return result.toArray(new String[result.size()]);
    }

    @Override
    public String getRequiredStringParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            return s;
        }
        throw new BadMessageException("mandatory parameter '" + name + "' is not set");
    }

    @Override
    public Integer getIntParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (NumberFormatException nfe) {
                throw new BadMessageException("parameter '" + name + "' is not a number");
            }
        }
        return null;
    }

    @Override
    public int getRequiredIntParameter(String name) throws BadMessageException {
        return Integer.parseInt(this.getRequiredStringParameter(name));
    }

    @Override
    public int getIntParameter(String name, int defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Integer.parseInt(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public Long getLongParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (NumberFormatException nfe) {
                throw new BadMessageException("parameter '" + name + "' is not a number");
            }
        }
        return null;
    }

    @Override
    public long getRequiredLongParameter(String name) throws BadMessageException {
        return Long.parseLong(this.getRequiredStringParameter(name));
    }

    @Override
    public long getLongParameter(String name, long defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Long.parseLong(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public Double getDoubleParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Double.parseDouble(s);
            }
            catch (NumberFormatException nfe) {
                throw new BadMessageException("parameter '" + name + "' is not a number");
            }
        }
        return null;
    }

    @Override
    public double getRequiredDoubleParameter(String name) throws BadMessageException {
        return Double.parseDouble(this.getRequiredStringParameter(name));
    }

    @Override
    public double getDoubleParameter(String name, double defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Double.parseDouble(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public Float getFloatParameter(String name) throws BadMessageException {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Float.valueOf(Float.parseFloat(s));
            }
            catch (NumberFormatException nfe) {
                throw new BadMessageException("parameter '" + name + "' is not a number");
            }
        }
        return null;
    }

    @Override
    public float getRequiredFloatParameter(String name) throws BadMessageException {
        return Float.parseFloat(this.getRequiredStringParameter(name));
    }

    @Override
    public float getFloatParameter(String name, float defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Float.parseFloat(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    @Override
    public Boolean getBooleanParameter(String name) {
        String s = this.getParameter(name);
        if (s != null) {
            return Boolean.parseBoolean(s);
        }
        return NULL_BOOLEAN;
    }

    @Override
    public boolean getRequiredBooleanParameter(String name) throws BadMessageException {
        return Boolean.parseBoolean(this.getRequiredStringParameter(name));
    }

    @Override
    public boolean getBooleanParameter(String name, boolean defaultVal) {
        String s = this.getParameter(name);
        if (s != null) {
            try {
                return Boolean.parseBoolean(s);
            }
            catch (Exception e) {
                return defaultVal;
            }
        }
        return defaultVal;
    }

    void addRawQueryParameterSilence(String paramName, String paramValue) throws IOException {
        this.getQueryParamList().add(new Parameter(paramName, paramValue, false));
    }

    private List<Parameter> getQueryParamList() {
        if (this.queryParameters == null) {
            this.queryParameters = new ArrayList();
        }
        return this.queryParameters;
    }

    private void writeRequestLineTo(StringBuilder sb) {
        sb.append(this.getMethod() + " " + this.path);
        if (this.isParamMapModified) {
            boolean isFirstEntry = true;
            for (Parameter param : this.getQueryParamList()) {
                if (isFirstEntry) {
                    isFirstEntry = false;
                    sb.append("?" + param.getEncodedName() + "=" + param.getEncodedValue());
                    continue;
                }
                sb.append("&" + param.getEncodedName() + "=" + param.getEncodedValue());
            }
        } else if (this.rawQuery != null) {
            sb.append("?");
            sb.append(this.rawQuery);
        }
        if (this.getProtocolScheme() != null) {
            sb.append(" ");
            sb.append(this.getProtocolScheme());
        }
        if (this.getProtocolVersion() != null) {
            sb.append("/");
            sb.append(this.getProtocolVersion());
        }
        sb.append("\r\n");
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.writeRequestLineTo(sb);
        if (this.keepAlive != null) {
            sb.append("Keep-Alive: ");
            sb.append(this.keepAlive);
            sb.append("\r\n");
        }
        if (this.host != null) {
            sb.append("Host: ");
            sb.append(this.host);
            sb.append("\r\n");
        }
        if (this.userAgent != null) {
            sb.append("User-Agent: ");
            sb.append(this.userAgent);
            sb.append("\r\n");
        }
        this.writeHeadersTo(sb);
        return sb.toString();
    }

    @Override
    public IHttpRequestHeader copy() {
        try {
            return (IHttpRequestHeader)this.clone();
        }
        catch (CloneNotSupportedException cnse) {
            throw new RuntimeException(cnse.toString());
        }
    }

    @Override
    protected Object clone() throws CloneNotSupportedException {
        HttpRequestHeader copy = (HttpRequestHeader)super.clone();
        if (this.queryParameters != null) {
            copy.queryParameters = (ArrayList)this.queryParameters.clone();
        }
        return copy;
    }

    private static class Parameter {
        private String encodedName = null;
        private String decodedName = null;
        private String encodedValue = null;
        private String decodedValue = null;

        public Parameter(String name, String value, boolean isDecoded) {
            if (isDecoded) {
                this.decodedName = name;
                this.decodedValue = value;
            } else {
                this.encodedName = name;
                this.encodedValue = value;
            }
        }

        String getDecodedName() {
            if (this.decodedName == null) {
                this.decodedName = Parameter.decode(this.encodedName);
            }
            return this.decodedName;
        }

        String getEncodedName() {
            if (this.encodedName == null) {
                this.encodedName = Parameter.encode(this.decodedName);
            }
            return this.encodedName;
        }

        String getDecodedValue() {
            if (this.decodedValue == null) {
                this.decodedValue = Parameter.decode(this.encodedValue);
            }
            return this.decodedValue;
        }

        String getEncodedValue() {
            if (this.encodedValue == null) {
                this.encodedValue = Parameter.encode(this.decodedValue);
            }
            return this.encodedValue;
        }

        boolean isDecodedNameSame(String decodedname) {
            return this.getDecodedName().equals(decodedname);
        }

        private static String decode(String encoded) {
            if (encoded == null) {
                return null;
            }
            try {
                return URLDecoder.decode(encoded, "UTF-8");
            }
            catch (UnsupportedEncodingException use) {
                throw new RuntimeException(use.toString());
            }
        }

        private static String encode(String decoded) {
            if (decoded == null) {
                return null;
            }
            try {
                return URLEncoder.encode(decoded, "UTF-8");
            }
            catch (UnsupportedEncodingException use) {
                throw new RuntimeException(use.toString());
            }
        }

        public String toString() {
            return this.getDecodedName() + "=" + this.getDecodedValue();
        }

        void writeTo(StringBuilder sb) {
            sb.append(this.getEncodedName());
            sb.append("=");
            sb.append(this.getEncodedValue());
        }
    }
}

